/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.AbsSavedState;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.common.R;
import com.serenegiant.view.ViewTransformDelegater;
import com.serenegiant.widget.IScaledView;
import com.serenegiant.widget.TransformImageView;

public class ZoomImageView
extends TransformImageView
implements ViewTransformDelegater.ViewTransformListener,
IScaledView {
    private static final boolean DEBUG = false;
    private static final String TAG = ZoomImageView.class.getSimpleName();
    private static final int REVERSING_TIMEOUT = 100;
    private static final float[] REVERSE = new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 255.0f, 0.0f, -1.0f, 0.0f, 0.0f, 255.0f, 0.0f, 0.0f, -1.0f, 0.0f, 255.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    private final ViewTransformDelegater mDelegater;
    private ColorFilter mColorReverseFilter;
    private ColorFilter mSavedColorFilter;
    private WaitReverseReset mWaitReverseReset;
    @Nullable
    private ViewTransformDelegater.ViewTransformListener mViewTransformListener;
    private double mRequestedAspect = -1.0;

    public ZoomImageView(Context context) {
        this(context, null, 0);
    }

    public ZoomImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZoomImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.IScaledView, defStyle, 0);
        double requestedAspect = -1.0;
        int scaleMode = 0;
        try {
            requestedAspect = a.getFloat(R.styleable.IScaledView_aspect_ratio, -1.0f);
            scaleMode = a.getInt(R.styleable.IScaledView_scale_mode, 0);
        }
        catch (UnsupportedOperationException e) {
            Log.d((String)TAG, (String)TAG, (Throwable)e);
        }
        finally {
            a.recycle();
        }
        this.mDelegater = new ViewTransformDelegater((View)this){

            @Override
            protected void setTransform(@NonNull View view, @Nullable Matrix transform) {
                ZoomImageView.this.superSetImageMatrix(transform);
            }

            @Override
            @NonNull
            protected Matrix getTransform(@NonNull View view, @Nullable Matrix transform) {
                return ZoomImageView.this.superGetImageMatrix(transform);
            }

            @Override
            public RectF getContentBounds() {
                Drawable dr = ZoomImageView.this.getDrawable();
                RectF result = dr != null ? new RectF(dr.getBounds()) : new RectF();
                return result;
            }

            @Override
            public void onInit() {
                ZoomImageView.this.superSetScaleType(ImageView.ScaleType.CENTER_INSIDE);
                ZoomImageView.this.setFrame(ZoomImageView.this.getLeft(), ZoomImageView.this.getTop(), ZoomImageView.this.getRight(), ZoomImageView.this.getBottom());
            }
        };
        this.mDelegater.setScaleMode(scaleMode);
        this.setViewTransformer(this.mDelegater);
        this.setAspectRatio(requestedAspect);
    }

    protected void onDetachedFromWindow() {
        this.mDelegater.clearPendingTasks();
        super.onDetachedFromWindow();
    }

    protected Parcelable onSaveInstanceState() {
        return this.mDelegater.onSaveInstanceState(super.onSaveInstanceState());
    }

    protected void onRestoreInstanceState(Parcelable state) {
        super.onRestoreInstanceState(state);
        if (state instanceof AbsSavedState) {
            super.onRestoreInstanceState(((AbsSavedState)state).getSuperState());
        }
        this.mDelegater.onRestoreInstanceState(state);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mDelegater.onConfigurationChanged(newConfig);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.getWidth() == 0 || this.getHeight() == 0 || !this.hasImage()) {
            return;
        }
        this.init();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.hasImage()) {
            return super.onTouchEvent(event);
        }
        if (this.mDelegater.onTouchEvent(event)) {
            return true;
        }
        return super.onTouchEvent(event);
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        super.setScaleType(ImageView.ScaleType.MATRIX);
        Log.w((String)TAG, (String)"setScaleType: ignore this parameter on ZoomImageView2, fixed to ScaleType.MATRIX.");
    }

    public void setColorFilter(ColorFilter cf) {
        super.setColorFilter(cf);
        this.mSavedColorFilter = cf;
    }

    public boolean hasImage() {
        return this.getDrawable() != null;
    }

    public Bitmap getCurrentImage() {
        Bitmap offscreen = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(offscreen);
        canvas.setMatrix(super.getImageMatrix());
        super.getDrawable().draw(canvas);
        return offscreen;
    }

    public Bitmap getCurrentImage(Rect frame) {
        Bitmap image = this.getCurrentImage();
        if (frame != null && !frame.isEmpty()) {
            Bitmap tmp = Bitmap.createBitmap((Bitmap)image, (int)frame.left, (int)frame.top, (int)frame.width(), (int)frame.height(), null, (boolean)false);
            image.recycle();
            image = tmp;
        }
        return image;
    }

    public void setEnableHandleTouchEvent(int enabled) {
        this.mDelegater.setEnableHandleTouchEvent(enabled);
    }

    public int getEnableHandleTouchEvent() {
        return this.mDelegater.getEnableHandleTouchEvent();
    }

    public void setMaxScale(float maxScale) throws IllegalArgumentException {
        this.mDelegater.setMaxScale(maxScale);
    }

    public float getMaxScale() {
        return this.mDelegater.getMaxScale();
    }

    public void setMinScale(float minScale) throws IllegalArgumentException {
        this.mDelegater.setMinScale(minScale);
    }

    public float getMinScale() {
        return this.mDelegater.getMinScale();
    }

    public void setViewTransformListener(ViewTransformDelegater.ViewTransformListener listener) {
        this.mViewTransformListener = listener;
    }

    @Nullable
    public ViewTransformDelegater.ViewTransformListener getViewTransformListener() {
        return this.mViewTransformListener;
    }

    public float getScale() {
        return this.mDelegater.getScale();
    }

    public void setScale(float scale) {
        this.mDelegater.setScale(scale);
    }

    public void setScaleRelative(float scaleDelta) {
        this.mDelegater.setScaleRelative(scaleDelta);
    }

    @NonNull
    public PointF getTranslate(@NonNull PointF result) {
        return this.mDelegater.getTranslate(result);
    }

    public float getRotation() {
        return this.mDelegater.getRotation();
    }

    @Override
    public void setAspectRatio(double aspectRatio) {
        if (this.mRequestedAspect != aspectRatio) {
            this.mRequestedAspect = aspectRatio;
            this.requestLayout();
        }
    }

    @Override
    public void setAspectRatio(int width, int height) {
        this.setAspectRatio((double)width / (double)height);
    }

    @Override
    public double getAspectRatio() {
        return this.mRequestedAspect;
    }

    @Override
    public void setScaleMode(int scaleMode) {
        this.mDelegater.setScaleMode(scaleMode);
    }

    @Override
    public int getScaleMode() {
        return this.mDelegater.getScaleMode();
    }

    @Override
    public void setNeedResizeToKeepAspect(boolean keepAspect) {
        this.mDelegater.setKeepAspect(keepAspect);
    }

    private void init() {
        this.mDelegater.init();
        this.superSetScaleType(ImageView.ScaleType.MATRIX);
        this.superSetImageMatrix(this.mDelegater.getTransform(null));
    }

    private void resetColorFilter() {
        super.setColorFilter(this.mSavedColorFilter);
    }

    @Override
    public void onStateChanged(@NonNull View view, int newState) {
        switch (newState) {
            case 5: {
                if (this.mColorReverseFilter == null) {
                    this.mColorReverseFilter = new ColorMatrixColorFilter(new ColorMatrix(REVERSE));
                }
                super.setColorFilter(this.mColorReverseFilter);
                if (this.mWaitReverseReset == null) {
                    this.mWaitReverseReset = new WaitReverseReset();
                }
                this.postDelayed(this.mWaitReverseReset, 100L);
                break;
            }
            case 0: {
                this.resetColorFilter();
            }
        }
        if (this.mViewTransformListener != null) {
            this.mViewTransformListener.onStateChanged(view, newState);
        }
    }

    @Override
    public void onTransformed(@NonNull View view, @NonNull Matrix transform) {
        if (this.mViewTransformListener != null) {
            this.mViewTransformListener.onTransformed(view, transform);
        }
    }

    private final class WaitReverseReset
    implements Runnable {
        private WaitReverseReset() {
        }

        @Override
        public void run() {
            ZoomImageView.this.resetColorFilter();
        }
    }
}

