/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import com.serenegiant.view.ViewUtils;
import java.util.ArrayList;
import java.util.List;

public class ValueSelectorAdapter
extends ArrayAdapter<ValueEntry> {
    private static final boolean DEBUG = false;
    private static final String TAG = ValueSelectorAdapter.class.getSimpleName();
    private final LayoutInflater mInflater;
    private final int mLayoutId;
    private final int mTitleId;
    private final ValueSelectorAdapterListener mListener;
    private final View.OnTouchListener mOnTouchListener = new View.OnTouchListener(){

        @SuppressLint(value={"ClickableViewAccessibility"})
        public boolean onTouch(View v, MotionEvent event) {
            if (ValueSelectorAdapter.this.mListener != null) {
                ViewHolder holder = (ViewHolder)v.getTag();
                int position = holder != null ? holder.position : -1;
                try {
                    ValueSelectorAdapter.this.mListener.onTouch(v, event, position);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    };

    private static List<ValueEntry> createEntries(Context context, int entries_res, int values_res) {
        String[] entries = context.getResources().getStringArray(entries_res);
        String[] values = context.getResources().getStringArray(values_res);
        int n = Math.min(entries != null ? entries.length : 0, values != null ? values.length : 0);
        ArrayList<ValueEntry> result = new ArrayList<ValueEntry>(n);
        for (int i = 0; i < n; ++i) {
            result.add(new ValueEntry(entries[i], values[i]));
        }
        return result;
    }

    public ValueSelectorAdapter(Context context, @LayoutRes int layout_resource, int title_id, int entries_resource, int values_resource, ValueSelectorAdapterListener listener) {
        super(context, layout_resource, ValueSelectorAdapter.createEntries(context, entries_resource, values_resource));
        this.mInflater = LayoutInflater.from((Context)context);
        this.mLayoutId = layout_resource;
        this.mTitleId = title_id;
        this.mListener = listener;
    }

    @NonNull
    public View getView(int position, View convertView, @NonNull ViewGroup parent) {
        View rootView = convertView;
        if (rootView == null) {
            rootView = this.mInflater.inflate(this.mLayoutId, parent, false);
            ViewHolder holder = new ViewHolder();
            holder.titleTv = ViewUtils.findTitleView(rootView);
            rootView.setOnTouchListener(this.mOnTouchListener);
            rootView.setTag((Object)holder);
        }
        ViewHolder holder = (ViewHolder)rootView.getTag();
        ValueEntry item = (ValueEntry)this.getItem(position);
        if (item != null && holder.titleTv != null) {
            holder.titleTv.setText((CharSequence)item.title);
        }
        holder.position = position;
        return rootView;
    }

    public View getDropDownView(int position, View convertView, @NonNull ViewGroup parent) {
        return this.getView(position, convertView, parent);
    }

    public int getPosition(int value) {
        int position = -1;
        String _value = Integer.toString(value);
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            ValueEntry entry = (ValueEntry)this.getItem(i);
            if (!_value.equals(entry.value)) continue;
            position = i;
            break;
        }
        return position;
    }

    private static class ViewHolder {
        int position;
        TextView titleTv;

        private ViewHolder() {
        }
    }

    public static class ValueEntry {
        public final String title;
        public final String value;

        private ValueEntry(String title, String value) {
            this.title = title;
            this.value = value;
        }
    }

    public static interface ValueSelectorAdapterListener {
        public void onTouch(View var1, MotionEvent var2, int var3);
    }
}

