/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.serenegiant.graphics.BitmapHelper;
import com.serenegiant.graphics.ShaderDrawable;

public class ColorPickerView
extends View {
    private static final float SQRT2 = (float)Math.sqrt(2.0);
    private static final float PI = (float)Math.PI;
    private static final float BORDER_WIDTH_PX = 1.0f;
    private static final int DEFAULT_WIDTH = 100;
    private static final int DEFAULT_HEIGHT = 100;
    private static final float RECTANGLE_TRACKER_OFFSET_DP = 2.0f;
    private static final int BORDER_COLOR = -9539986;
    private static final int TRACKER_COLOR = -14935012;
    private static final int DEFAULT_SELECTED_RADIUS = 8;
    private static final int STATE_IDLE = 0;
    private static final int STATE_COLOR = 1;
    private static final int STATE_ALPHA = 2;
    private static final int STATE_VAL = 3;
    private boolean mShowAlphaSlider = true;
    private boolean mShowValSlider = true;
    private boolean mShowSelectedColor = true;
    private final float RECTANGLE_TRACKER_OFFSET;
    private final float DENSITY;
    private final int[] COLORS = new int[360];
    private final float[] HSV = new float[3];
    private final RectF mDrawingRect = new RectF();
    private final Paint mBorderPaint = new Paint();
    private final Paint mTrackerPaint = new Paint();
    private final ShaderDrawable mAlphaDrawable;
    private final Shader mAlphaShader;
    private final Paint mPaint = new Paint(1);
    private final Paint mGradientPaint = new Paint(1);
    private final Paint mSelectionPaint = new Paint(1);
    private final RectF mSelectionRect = new RectF();
    private final PointF mSelected = new PointF();
    private final RectF mSliderRect = new RectF();
    private final Paint mAlphaPaint = new Paint();
    private final RectF mAlphaRect = new RectF();
    private final Paint mValPaint = new Paint();
    private final RectF mValRect = new RectF();
    private int mState = 0;
    private ColorPickerListener mColorPickerListener;
    private int slider_width = 32;
    private int center_x;
    private int center_y;
    private final float SELECTED_RADIUS;
    private int radius;
    private int radius2;
    private int mColor = -1;
    private int mAlpha = 255;
    private float mVal = 0.0f;
    private float mHue = 360.0f;
    private float mSat = 0.0f;

    public ColorPickerView(Context context) {
        this(context, null, 0);
    }

    public ColorPickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ColorPickerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.DENSITY = context.getResources().getDisplayMetrics().density;
        this.RECTANGLE_TRACKER_OFFSET = 2.0f * this.DENSITY;
        this.SELECTED_RADIUS = 8.0f * this.DENSITY;
        this.mAlphaShader = new BitmapShader(BitmapHelper.makeCheckBitmap(), Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
        this.mAlphaDrawable = new ShaderDrawable(6, 0);
        this.mAlphaDrawable.setShader(this.mAlphaShader);
        this.radius = 0;
        this.internalSetColor(this.mColor, false);
        this.setHueColorArray(this.mAlpha, this.COLORS);
        this.mPaint.setShader((Shader)new SweepGradient(0.0f, 0.0f, this.COLORS, null));
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth(0.0f);
        this.mSelectionPaint.setColor(this.mColor);
        this.mSelectionPaint.setStrokeWidth(5.0f);
        this.mTrackerPaint.setColor(-14935012);
        this.mTrackerPaint.setStyle(Paint.Style.STROKE);
        this.mTrackerPaint.setStrokeWidth(2.0f * this.DENSITY);
        this.mTrackerPaint.setAntiAlias(true);
    }

    protected void onDraw(Canvas canvas) {
        this.mSelectionPaint.setStyle(Paint.Style.FILL);
        if (this.mShowSelectedColor) {
            this.mSelectionPaint.setShader(this.mAlphaShader);
            canvas.drawArc(this.mSelectionRect, 0.0f, 90.0f, true, this.mSelectionPaint);
            this.mSelectionPaint.setShader(null);
            this.mSelectionPaint.setColor(this.mColor);
            canvas.drawArc(this.mSelectionRect, 0.0f, 90.0f, true, this.mSelectionPaint);
        }
        int count = canvas.save();
        try {
            canvas.translate((float)this.center_x, (float)this.center_y);
            this.mSelectionPaint.setShader(this.mAlphaShader);
            canvas.drawCircle(0.0f, 0.0f, (float)this.radius, this.mSelectionPaint);
            canvas.drawCircle(0.0f, 0.0f, (float)this.radius, this.mPaint);
            canvas.drawCircle(0.0f, 0.0f, (float)this.radius, this.mGradientPaint);
        }
        finally {
            canvas.restoreToCount(count);
        }
        this.mSelectionPaint.setShader(null);
        this.mSelectionPaint.setColor(~this.mColor | 0xFF000000);
        this.mSelectionPaint.setStyle(Paint.Style.STROKE);
        canvas.drawCircle(this.mSelected.x, this.mSelected.y, this.SELECTED_RADIUS, this.mSelectionPaint);
        this.drawAlphaPanel(canvas);
        this.drawValPanel(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        switch (widthMode) {
            case 0: {
                width = 100;
                break;
            }
            case 0x40000000: {
                break;
            }
        }
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)widthMode);
        switch (heightMode) {
            case 0: {
                height = 100;
                break;
            }
            case 0x40000000: {
                break;
            }
        }
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)heightMode);
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.getWidth() != 0 && this.getHeight() != 0) {
            int width = this.getWidth();
            int height = this.getHeight();
            this.mDrawingRect.set(0.0f, 0.0f, (float)width, (float)height);
            int dimeter = Math.min(width, height);
            this.slider_width = dimeter / 10;
            if (this.slider_width < 32) {
                this.slider_width = (int)(32.0f * this.DENSITY);
            }
            int space = this.slider_width + (int)(16.0f * this.DENSITY);
            this.radius = (dimeter -= space) >>> 1;
            this.radius2 = this.radius * this.radius;
            this.center_x = width - (this.mShowValSlider ? this.slider_width : 0) >>> 1;
            this.center_y = height - (this.mShowAlphaSlider ? this.slider_width : 0) >>> 1;
            int selection_radius = (int)Math.sqrt(this.center_x * this.center_x + this.center_y * this.center_y) - this.radius;
            this.mSelectionRect.set((float)(-selection_radius), (float)(-selection_radius), (float)selection_radius, (float)selection_radius);
            this.mGradientPaint.setShader((Shader)new RadialGradient(0.0f, 0.0f, (float)this.radius, -1, 0xFFFFFF, Shader.TileMode.CLAMP));
            this.setupAlphaRect();
            this.setUpValRect();
            this.setColor(this.mAlpha, this.mHue, this.mSat, this.mVal, true);
        }
    }

    public int getColor() {
        return this.mColor;
    }

    public float getHue() {
        return this.mHue;
    }

    public float getSat() {
        return this.mSat;
    }

    public float getVal() {
        return this.mVal;
    }

    /*
     * Unable to fully structure code
     */
    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        x = event.getX();
        dx = x - (float)this.center_x;
        d = dx * dx + (dy = (y = event.getY()) - (float)this.center_y) * dy;
        inColorCircle = d <= (float)this.radius2;
        switch (event.getAction()) {
            case 0: {
                if (!inColorCircle) ** GOTO lbl10
                this.mState = 1;
                ** GOTO lbl17
lbl10:
                // 1 sources

                if (!this.mAlphaRect.contains(x, y)) ** GOTO lbl13
                this.mState = 2;
                ** GOTO lbl17
lbl13:
                // 1 sources

                if (this.mValRect.contains(x, y)) {
                    this.mState = 3;
                } else {
                    return false;
                }
            }
lbl17:
            // 4 sources

            case 2: {
                modified = false;
                switch (this.mState) {
                    case 1: {
                        angle = (float)Math.atan2(dy, dx);
                        unit = angle / 6.2831855f;
                        if (unit < 0.0f) {
                            unit += 1.0f;
                        }
                        this.setColor(this.mAlpha, 360.0f - unit * 360.0f, (float)Math.sqrt(d) / (float)this.radius, this.mVal, true);
                        modified = true;
                        break;
                    }
                    case 2: {
                        modified = this.trackAlpha(x, y);
                        if (!modified) break;
                        this.setHueColorArray(this.mAlpha, this.COLORS);
                        this.mPaint.setShader((Shader)new SweepGradient(0.0f, 0.0f, this.COLORS, null));
                        break;
                    }
                    case 3: {
                        modified = this.trackVal(x, y);
                        if (!modified) break;
                        this.setHueColorArray(this.mAlpha, this.COLORS);
                        this.mPaint.setShader((Shader)new SweepGradient(0.0f, 0.0f, this.COLORS, null));
                    }
                }
                if (!modified || this.mColorPickerListener == null) break;
                this.mColorPickerListener.onColorChanged(this, this.mColor);
                break;
            }
            case 1: {
                if (this.mColorPickerListener != null) {
                    this.mColorPickerListener.onColorChanged(this, this.mColor);
                }
                this.mState = 0;
            }
        }
        return true;
    }

    public void setColor(int cl) {
        this.internalSetColor(cl, true);
    }

    protected void internalSetColor(int cl, boolean force) {
        int alpha = Color.alpha((int)cl);
        int red = Color.red((int)cl);
        int blue = Color.blue((int)cl);
        int green = Color.green((int)cl);
        Color.RGBToHSV((int)red, (int)green, (int)blue, (float[])this.HSV);
        this.setColor(alpha, this.HSV[0], this.HSV[1], this.HSV[2], force);
    }

    protected void setColor(int alpha, float hue, float sat, float val, boolean force) {
        if (sat > 1.0f) {
            sat = 1.0f;
        }
        if (force || this.mAlpha != alpha || this.mHue != hue || this.mSat != sat || this.mVal != val) {
            this.mAlpha = alpha;
            this.mHue = hue;
            this.mSat = sat;
            this.mVal = val;
            this.mColor = this.HSVToColor(alpha, hue, sat, val);
            if (this.radius > 0) {
                float r = (float)this.radius * sat;
                float d = hue / 180.0f * (float)Math.PI;
                this.mSelected.set((float)this.center_x + r * (float)Math.cos(d), (float)this.center_y - r * (float)Math.sin(d));
                this.postInvalidate();
            }
        }
    }

    public void setColorPickerListener(ColorPickerListener listener) {
        this.mColorPickerListener = listener;
    }

    public ColorPickerListener getColorPickerListener() {
        return this.mColorPickerListener;
    }

    public void setShowSelectedColor(boolean showSelectedColor) {
        this.mShowSelectedColor = showSelectedColor;
    }

    public boolean getShowSelectedColor() {
        return this.mShowSelectedColor;
    }

    public void showAlpha(boolean showAlpha) {
        if (this.mShowAlphaSlider != showAlpha) {
            this.mShowAlphaSlider = showAlpha;
            this.postInvalidate();
        }
    }

    public boolean isShowAlpha() {
        return this.mShowAlphaSlider;
    }

    public void setShowVal(boolean showVal) {
        if (this.mShowValSlider != showVal) {
            this.mShowValSlider = showVal;
            this.postInvalidate();
        }
    }

    public boolean isShowVal() {
        return this.mShowValSlider;
    }

    private final int HSVToColor(int alpha, float hue, float saturation, float value) {
        if (hue >= 360.0f) {
            hue = 359.99f;
        } else if (hue < 0.0f) {
            hue = 0.0f;
        }
        if (saturation > 1.0f) {
            saturation = 1.0f;
        } else if (saturation < 0.0f) {
            saturation = 0.0f;
        }
        if (value > 1.0f) {
            value = 1.0f;
        } else if (value < 0.0f) {
            value = 0.0f;
        }
        this.HSV[0] = hue;
        this.HSV[1] = saturation;
        this.HSV[2] = value;
        return Color.HSVToColor((int)alpha, (float[])this.HSV);
    }

    private final int[] setHueColorArray(int alpha, int[] colors) {
        int n = colors.length;
        float resolution = 360.0f / (float)n;
        this.HSV[1] = 1.0f;
        this.HSV[2] = this.mVal;
        float i = 360.0f;
        for (int count = 0; (double)i >= 0.0 && count < n; ++count) {
            this.HSV[0] = i;
            colors[count] = Color.HSVToColor((int)alpha, (float[])this.HSV);
            i -= resolution;
        }
        this.HSV[0] = 0.0f;
        colors[n - 1] = Color.HSVToColor((int)alpha, (float[])this.HSV);
        return colors;
    }

    private final void drawTrackerHorizontal(Canvas canvas, float x, float y, float height) {
        float width = 4.0f * this.DENSITY / 2.0f;
        this.mSliderRect.left = x - width;
        this.mSliderRect.right = x + width;
        this.mSliderRect.top = y - this.RECTANGLE_TRACKER_OFFSET;
        this.mSliderRect.bottom = y + height + this.RECTANGLE_TRACKER_OFFSET;
        this.mTrackerPaint.setColor(-1842205);
        this.mTrackerPaint.setStyle(Paint.Style.FILL);
        canvas.drawRoundRect(this.mSliderRect, 2.0f, 2.0f, this.mTrackerPaint);
        this.mTrackerPaint.setColor(-14935012);
        this.mTrackerPaint.setStyle(Paint.Style.STROKE);
        canvas.drawRoundRect(this.mSliderRect, 2.0f, 2.0f, this.mTrackerPaint);
    }

    private final void drawTrackerVertical(Canvas canvas, float x, float y, float width) {
        float height = 4.0f * this.DENSITY / 2.0f;
        this.mSliderRect.left = x - this.RECTANGLE_TRACKER_OFFSET;
        this.mSliderRect.right = x + width + this.RECTANGLE_TRACKER_OFFSET;
        this.mSliderRect.top = y - height;
        this.mSliderRect.bottom = y + height;
        this.mTrackerPaint.setColor(-1842205);
        this.mTrackerPaint.setStyle(Paint.Style.FILL);
        canvas.drawRoundRect(this.mSliderRect, 2.0f, 2.0f, this.mTrackerPaint);
        this.mTrackerPaint.setColor(-14935012);
        this.mTrackerPaint.setStyle(Paint.Style.STROKE);
        canvas.drawRoundRect(this.mSliderRect, 2.0f, 2.0f, this.mTrackerPaint);
    }

    private void setupAlphaRect() {
        if (!this.mShowAlphaSlider) {
            return;
        }
        RectF dRect = this.mDrawingRect;
        this.mAlphaRect.set(dRect.left + 1.0f, dRect.bottom - (float)this.slider_width + 1.0f, dRect.right - (float)this.slider_width - 1.0f, dRect.bottom - 1.0f - this.RECTANGLE_TRACKER_OFFSET);
    }

    private final void drawAlphaPanel(Canvas canvas) {
        if (!this.mShowAlphaSlider) {
            return;
        }
        RectF rect = this.mAlphaRect;
        this.mBorderPaint.setColor(-9539986);
        canvas.drawRect(rect.left - 1.0f, rect.top - 1.0f, rect.right + 1.0f, rect.bottom + 1.0f, this.mBorderPaint);
        this.mAlphaPaint.setShader(this.mAlphaShader);
        canvas.drawRect(rect, this.mAlphaPaint);
        int color2 = this.HSVToColor(255, this.mHue, this.mSat, this.mVal);
        int acolor = this.HSVToColor(0, this.mHue, this.mSat, this.mVal);
        LinearGradient alphaShader = new LinearGradient(rect.left, rect.top, rect.right, rect.top, color2, acolor, Shader.TileMode.CLAMP);
        this.mAlphaPaint.setShader((Shader)alphaShader);
        canvas.drawRect(rect, this.mAlphaPaint);
        Point p = this.alphaToPoint(this.mAlpha);
        this.drawTrackerHorizontal(canvas, p.x, p.y, rect.height());
    }

    private final boolean trackAlpha(float x, float y) {
        int alpha;
        boolean result = false;
        if (this.mShowAlphaSlider && this.mAlpha != (alpha = this.pointToAlpha((int)x))) {
            this.setColor(alpha, this.mHue, this.mSat, this.mVal, true);
            result = true;
        }
        return result;
    }

    private final Point alphaToPoint(int alpha) {
        RectF r = this.mAlphaRect;
        float w = r.width();
        return new Point((int)(w - (float)alpha * w / 255.0f + r.left), (int)r.top);
    }

    private final int pointToAlpha(int x) {
        RectF rect = this.mAlphaRect;
        int width = (int)rect.width();
        x = (float)x < rect.left ? 0 : ((float)x > rect.right ? width : (x -= (int)rect.left));
        return 255 - x * 255 / width;
    }

    private final void setUpValRect() {
        if (!this.mShowValSlider) {
            return;
        }
        RectF dRect = this.mDrawingRect;
        this.mValRect.set(dRect.right - (float)this.slider_width + 1.0f, dRect.top + 1.0f + this.RECTANGLE_TRACKER_OFFSET, dRect.right - 1.0f - this.RECTANGLE_TRACKER_OFFSET, dRect.bottom - 1.0f - (float)(this.mShowAlphaSlider ? 16 + this.slider_width : 0));
    }

    private final void drawValPanel(Canvas canvas) {
        if (!this.mShowValSlider) {
            return;
        }
        RectF rect = this.mValRect;
        this.mBorderPaint.setColor(-9539986);
        canvas.drawRect(rect.left - 1.0f, rect.top - 1.0f, rect.right + 1.0f, rect.bottom + 1.0f, this.mBorderPaint);
        int color2 = this.HSVToColor(255, this.mHue, this.mSat, 1.0f);
        int acolor = this.HSVToColor(255, this.mHue, this.mSat, 0.0f);
        LinearGradient mValShader = new LinearGradient(rect.left, rect.top, rect.left, rect.bottom, color2, acolor, Shader.TileMode.CLAMP);
        this.mValPaint.setShader((Shader)mValShader);
        canvas.drawRect(rect, this.mValPaint);
        Point p = this.valToPoint(this.mVal);
        this.drawTrackerVertical(canvas, p.x, p.y, rect.width());
    }

    private final boolean trackVal(float x, float y) {
        boolean result = false;
        float val = this.pointToVal(y);
        if (this.mVal != val) {
            this.setColor(this.mAlpha, this.mHue, this.mSat, val, true);
            result = true;
        }
        return result;
    }

    private final Point valToPoint(float val) {
        RectF rect = this.mValRect;
        float height = rect.height();
        Point p = new Point();
        p.y = (int)(height - val * height + rect.top);
        p.x = (int)rect.left;
        return p;
    }

    private final float pointToVal(float y) {
        RectF rect = this.mValRect;
        float height = rect.height();
        y = y < rect.top ? 0.0f : (y > rect.bottom ? height : (y -= rect.top));
        return 1.0f - y * 1.0f / height;
    }

    public static interface ColorPickerListener {
        public void onColorChanged(ColorPickerView var1, int var2);
    }
}

