/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.view.animation;

import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import androidx.annotation.NonNull;
import com.serenegiant.view.ViewUtils;

public class ResizeAnimation
extends Animation {
    private static final boolean DEBUG = false;
    private static final String TAG = ResizeAnimation.class.getSimpleName();
    @NonNull
    private final View mTargetView;
    private final int mStartWidth;
    private final int mStartHeight;
    private final int mDiffWidth;
    private final int mDiffHeight;

    public ResizeAnimation(@NonNull View view, int startWidth, int startHeight, int endWidth, int endHeight) {
        this.mTargetView = view;
        this.mStartWidth = startWidth;
        this.mStartHeight = startHeight;
        this.mDiffWidth = endWidth - startWidth;
        this.mDiffHeight = endHeight - startHeight;
        ViewUtils.requestResize(this.mTargetView, startWidth, startHeight);
    }

    protected void applyTransformation(float interpolatedTime, Transformation t) {
        super.applyTransformation(interpolatedTime, t);
        ViewUtils.requestResize(this.mTargetView, (int)((float)this.mStartWidth + (float)this.mDiffWidth * interpolatedTime), (int)((float)this.mStartHeight + (float)this.mDiffHeight * interpolatedTime));
    }

    public void initialize(int width, int height, int parentWidth, int parentHeight) {
        super.initialize(width, height, parentWidth, parentHeight);
    }

    public boolean willChangeBounds() {
        return this.mDiffWidth != 0 || this.mDiffHeight != 0;
    }
}

