/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.text.TextUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class IEnum {
    private IEnum() {
    }

    public static <E extends EnumInterface> E as(Class<E> enumClazz, int id2) throws IllegalArgumentException {
        for (EnumInterface e : (EnumInterface[])enumClazz.getEnumConstants()) {
            if (e.id() != id2) continue;
            return (E)e;
        }
        throw new IllegalArgumentException();
    }

    public static <E extends EnumInterface> E as(Class<E> enumClazz, String label) throws IllegalArgumentException {
        if (!TextUtils.isEmpty((CharSequence)label)) {
            for (EnumInterface e : (EnumInterface[])enumClazz.getEnumConstants()) {
                if (!label.equalsIgnoreCase(e.label())) continue;
                return (E)e;
            }
            String _label = label.toUpperCase();
            for (EnumInterface e : (EnumInterface[])enumClazz.getEnumConstants()) {
                if (!label.startsWith(e.name().toUpperCase())) continue;
                return (E)e;
            }
        }
        throw new IllegalArgumentException();
    }

    public static <E extends EnumInterface> E as(Class<E> enumClazz, int id2, String label) throws IllegalArgumentException {
        try {
            return IEnum.as(enumClazz, id2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return IEnum.as(enumClazz, label);
        }
    }

    public static <E extends EnumInterface> E as(Class<E> enumClazz, String label, int id2) throws IllegalArgumentException {
        try {
            return IEnum.as(enumClazz, label);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return IEnum.as(enumClazz, id2);
        }
    }

    public static <E extends EnumInterface> String identity(Class<E> enumClazz, String value) {
        String result = null;
        if (!TextUtils.isEmpty((CharSequence)value)) {
            String _value = value.toUpperCase();
            for (EnumInterface e : (EnumInterface[])enumClazz.getEnumConstants()) {
                if (!_value.startsWith(e.name().toUpperCase())) continue;
                result = value.substring(e.name().length() + 1);
            }
        }
        return result;
    }

    public static JSONObject put(JSONObject payload, String key, EnumInterface v) throws JSONException {
        payload.put(key, (Object)v.label());
        return payload;
    }

    public static interface EnumInterfaceEx
    extends EnumInterface {
        public void put(JSONObject var1) throws JSONException;

        public void put(String var1, JSONObject var2) throws JSONException;
    }

    public static interface EnumInterface {
        public int id();

        public String label();

        public String name();

        public int ordinal();
    }
}

