/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.system;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;

public class ContextUtils {
    private ContextUtils() {
    }

    @Nullable
    public static <T> T getSystemService(@NonNull Context context, @NonNull Class<T> serviceClass) {
        return (T)ContextCompat.getSystemService((Context)context, serviceClass);
    }

    @NonNull
    public static <T> T requireSystemService(@NonNull Context context, @NonNull Class<T> serviceClass) throws IllegalArgumentException {
        Object result = ContextCompat.getSystemService((Context)context, serviceClass);
        if (result != null) {
            return (T)result;
        }
        throw new IllegalArgumentException();
    }
}

