/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.net;

import android.util.Log;
import androidx.annotation.NonNull;
import java.util.Arrays;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class SSLSessionUtils {
    private static final boolean DEBUG = false;
    private static final String TAG = SSLSessionUtils.class.getSimpleName();

    private SSLSessionUtils() {
    }

    public static void dump(@NonNull SSLSession session) {
        Log.i((String)TAG, (String)("id=" + Arrays.toString(session.getId())));
        Log.i((String)TAG, (String)("context=" + session.getSessionContext()));
        Log.i((String)TAG, (String)("creationTime=" + session.getCreationTime()));
        Log.i((String)TAG, (String)("lastAccessedTime=" + session.getLastAccessedTime()));
        Log.i((String)TAG, (String)("isValid=" + session.isValid()));
        String[] names = session.getValueNames();
        if (names != null && names.length > 0) {
            for (String name : names) {
                Log.i((String)TAG, (String)("values[" + name + "]=" + session.getValue(name)));
            }
        }
        try {
            Log.i((String)TAG, (String)("peerCertificates=" + Arrays.toString(session.getPeerCertificates())));
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            // empty catch block
        }
        Log.i((String)TAG, (String)("localCertificates=" + Arrays.toString(session.getLocalCertificates())));
        try {
            Log.i((String)TAG, (String)("peerCertificateChain=" + Arrays.toString(session.getPeerCertificateChain())));
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            // empty catch block
        }
        try {
            Log.i((String)TAG, (String)("peerPrincipal=" + session.getPeerPrincipal()));
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            // empty catch block
        }
        Log.i((String)TAG, (String)("localPrincipal=" + session.getLocalPrincipal()));
        Log.i((String)TAG, (String)("cipherSuite=" + session.getCipherSuite()));
        Log.i((String)TAG, (String)("protocol=" + session.getProtocol()));
        Log.i((String)TAG, (String)("peerHost=" + session.getPeerHost()));
        Log.i((String)TAG, (String)("peerPort=" + session.getPeerPort()));
        Log.i((String)TAG, (String)("packetBufferSize=" + session.getPacketBufferSize()));
        Log.i((String)TAG, (String)("applicationBufferSize=" + session.getApplicationBufferSize()));
    }
}

