/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.mediastore;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.graphics.MatrixUtils;
import com.serenegiant.mediastore.MediaInfo;
import com.serenegiant.mediastore.ThumbnailLoader;

public abstract class ThumbnailLoaderDrawable
extends Drawable
implements Runnable {
    private static final boolean DEBUG = false;
    private static final String TAG = ThumbnailLoaderDrawable.class.getSimpleName();
    private static final int DEFAULT_PAINT_FLAGS = 6;
    private final Context mContext;
    private final Paint mPaint = new Paint(6);
    private final Paint mDebugPaint = new Paint(6);
    private final Matrix mDrawMatrix = new Matrix();
    private Bitmap mBitmap;
    private int mRotationDegree = 0;
    private ThumbnailLoader mLoader;
    private int mTargetDensity = 160;
    private int mBitmapWidth;
    private int mBitmapHeight;

    public ThumbnailLoaderDrawable(@NonNull Context context, int width, int height) {
        this.mContext = context;
        this.mDebugPaint.setColor(-65536);
        this.mDebugPaint.setTextSize(18.0f);
        this.mBitmapWidth = width;
        this.mBitmapHeight = height;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.updateDrawMatrix(this.getBounds());
    }

    public void draw(@NonNull Canvas canvas) {
        Rect bounds = this.getBounds();
        if (this.mBitmap != null) {
            canvas.save();
            try {
                canvas.clipRect(bounds);
                canvas.concat(this.mDrawMatrix);
                canvas.rotate((float)this.mRotationDegree, (float)bounds.centerX(), (float)bounds.centerY());
                canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, this.mPaint);
            }
            finally {
                canvas.restore();
            }
        } else {
            this.mPaint.setColor(-3355444);
            canvas.drawRect(bounds, this.mPaint);
        }
    }

    @NonNull
    protected Context getContext() {
        return this.mContext;
    }

    private void updateDrawMatrix(@NonNull Rect bounds) {
        if (this.mBitmap == null || bounds.isEmpty()) {
            this.mDrawMatrix.reset();
            return;
        }
        MatrixUtils.updateDrawMatrix(MatrixUtils.ScaleType.CENTER_CROP, this.mDrawMatrix, bounds.width(), bounds.height(), this.mBitmap.getWidth(), this.mBitmap.getHeight());
        this.invalidateSelf();
    }

    public void setAlpha(int alpha) {
        int oldAlpha = this.mPaint.getAlpha();
        if (alpha != oldAlpha) {
            this.mPaint.setAlpha(alpha);
            this.invalidateSelf();
        }
    }

    public void setColorFilter(@Nullable ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
        this.invalidateSelf();
    }

    public int getIntrinsicWidth() {
        return this.mBitmapWidth;
    }

    public int getIntrinsicHeight() {
        return this.mBitmapHeight;
    }

    public int getOpacity() {
        Bitmap bm = this.mBitmap;
        return bm == null || bm.hasAlpha() || this.mPaint.getAlpha() < 255 ? -3 : -1;
    }

    public void setTargetDensity(@NonNull Canvas canvas) {
        this.setTargetDensity(canvas.getDensity());
    }

    public void setTargetDensity(@NonNull DisplayMetrics metrics) {
        this.setTargetDensity(metrics.densityDpi);
    }

    public void setTargetDensity(int density) {
        if (this.mTargetDensity != density) {
            int n = this.mTargetDensity = density == 0 ? 160 : density;
            if (this.mBitmap != null) {
                this.computeBitmapSize();
            }
            this.invalidateSelf();
        }
    }

    public void setRotation(int rotationDegree) {
        if (this.mRotationDegree != rotationDegree) {
            this.mRotationDegree = rotationDegree;
            this.invalidateSelf();
        }
    }

    public int getRotation() {
        return this.mRotationDegree;
    }

    @Override
    public void run() {
        this.setBitmap(this.mLoader.getBitmap());
    }

    @NonNull
    protected abstract ThumbnailLoader createLoader();

    @Nullable
    protected abstract Bitmap checkCache(long var1);

    public void startLoad(@NonNull MediaInfo info) {
        Bitmap newBitmap;
        if (this.mLoader != null) {
            this.mLoader.cancelLoad();
        }
        if ((newBitmap = this.checkCache(info.id)) == null) {
            this.mBitmap = null;
            this.mLoader = this.createLoader();
            this.mLoader.startLoad(info);
        } else {
            this.setBitmap(newBitmap);
        }
        this.invalidateSelf();
    }

    protected void setBitmap(@Nullable Bitmap bitmap) {
        if (bitmap != this.mBitmap) {
            this.mBitmap = bitmap;
            this.computeBitmapSize();
            this.updateDrawMatrix(this.getBounds());
        }
    }

    private void computeBitmapSize() {
        if (this.mBitmap != null) {
            this.mBitmapWidth = this.mBitmap.getScaledWidth(this.mTargetDensity);
            this.mBitmapHeight = this.mBitmap.getScaledHeight(this.mTargetDensity);
        } else {
            this.mBitmapHeight = -1;
            this.mBitmapWidth = -1;
        }
    }
}

