/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.mediastore;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.documentfile.provider.DocumentFile;
import com.serenegiant.mediastore.MediaStoreUtils;
import com.serenegiant.utils.UriHelper;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MediaStoreOutputStream
extends OutputStream {
    private static final boolean DEBUG = false;
    private static final String TAG = MediaStoreOutputStream.class.getSimpleName();
    @NonNull
    private final ContentResolver mCr;
    @NonNull
    private final Uri mUri;
    @NonNull
    private final FileOutputStream mOutputStream;
    @Nullable
    private final String mOutputPath;
    private final Object closeLock = new Object();
    private volatile boolean closed = false;

    @Deprecated
    public MediaStoreOutputStream(@NonNull Context context, @Nullable String mimeType, @NonNull String nameWithExt) throws FileNotFoundException {
        this(context, mimeType, null, nameWithExt);
    }

    @Deprecated
    public MediaStoreOutputStream(@NonNull Context context, @Nullable String mimeType, @Nullable String relativePath, @NonNull String nameWithExt) throws FileNotFoundException {
        this.mCr = context.getContentResolver();
        this.mUri = MediaStoreUtils.getContentUri(this.mCr, mimeType, relativePath, nameWithExt, null);
        ParcelFileDescriptor pfd = this.mCr.openFileDescriptor(this.mUri, "w");
        this.mOutputStream = new FileOutputStream(pfd.getFileDescriptor());
        this.mOutputPath = UriHelper.getPath(context, this.mUri);
    }

    @Deprecated
    public MediaStoreOutputStream(@NonNull Context context, @Nullable String mimeType, @Nullable String relativePath, @NonNull String nameWithExt, @Nullable String dataPath) throws FileNotFoundException {
        this.mCr = context.getContentResolver();
        this.mUri = MediaStoreUtils.getContentUri(this.mCr, mimeType, relativePath, nameWithExt, dataPath);
        ParcelFileDescriptor pfd = this.mCr.openFileDescriptor(this.mUri, "rw");
        this.mOutputStream = new FileOutputStream(pfd.getFileDescriptor());
        this.mOutputPath = UriHelper.getPath(context, this.mUri);
    }

    public MediaStoreOutputStream(@NonNull Context context, @NonNull DocumentFile output) throws FileNotFoundException {
        this.mCr = context.getContentResolver();
        this.mUri = output.getUri();
        ParcelFileDescriptor pfd = this.mCr.openFileDescriptor(this.mUri, "rw");
        this.mOutputStream = new FileOutputStream(pfd.getFileDescriptor());
        this.mOutputPath = UriHelper.getPath(context, this.mUri);
    }

    @NonNull
    public Uri getUri() {
        return this.mUri;
    }

    @Deprecated
    @Nullable
    public String getOutputPath() {
        return this.mOutputPath;
    }

    @NonNull
    public FileDescriptor getFd() throws IOException {
        return this.mOutputStream.getFD();
    }

    @Override
    public void write(int b) throws IOException {
        this.mOutputStream.write(b);
    }

    @Override
    public void write(@NonNull byte[] b) throws IOException {
        this.mOutputStream.write(b, 0, b.length);
    }

    @Override
    public void write(@NonNull byte[] b, int off, int len) throws IOException {
        if (this.closed && len > 0) {
            throw new IOException("Stream Closed");
        }
        this.mOutputStream.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.mOutputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        try {
            this.mOutputStream.close();
        }
        finally {
            if (UriHelper.isContentUri(this.mUri)) {
                MediaStoreUtils.updateContentUri(this.mCr, this.mUri);
            }
        }
    }
}

