/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.serenegiant.math.Fraction;

public class VideoConfig
implements Parcelable,
Cloneable {
    private static final boolean DEBUG = false;
    private static final String TAG = VideoConfig.class.getSimpleName();
    public static final float BPP_MIN = 0.01f;
    public static float BPP_MAX = 0.3f;
    public static final int FPS_MIN = 2;
    public static final int FPS_MAX = 121;
    private static final int IFRAME_MIN = 1;
    private static final int IFRAME_MAX = 30;
    public static final VideoConfig DEFAULT_CONFIG = new VideoConfig(0.25f, 10.0f, 300.0f, 30, 30000L, Build.VERSION.SDK_INT >= 18, Build.VERSION.SDK_INT >= 18);
    private float BPP;
    private float mIframeIntervalsS;
    private float mNumFramesBetweenIframeOn30fps;
    private int mCaptureFps;
    private long mMaxDuration;
    private boolean mUseMediaMuxer;
    private boolean mUseSurfaceCapture;
    public static final Parcelable.Creator<VideoConfig> CREATOR = new Parcelable.Creator<VideoConfig>(){

        public VideoConfig createFromParcel(Parcel in) {
            return new VideoConfig(in);
        }

        public VideoConfig[] newArray(int size) {
            return new VideoConfig[size];
        }
    };

    public VideoConfig() {
        this(DEFAULT_CONFIG);
    }

    public VideoConfig(@NonNull VideoConfig src) {
        this.BPP = src.BPP;
        this.mIframeIntervalsS = src.mIframeIntervalsS;
        this.mNumFramesBetweenIframeOn30fps = src.mNumFramesBetweenIframeOn30fps;
        this.mCaptureFps = src.mCaptureFps;
        this.mMaxDuration = src.mMaxDuration;
        this.mUseMediaMuxer = src.mUseMediaMuxer;
        this.mUseSurfaceCapture = src.mUseSurfaceCapture;
    }

    private VideoConfig(float BPP, float mIframeIntervalsS, float mNumFramesBetweenIframeOn30fps, int mCaptureFps, long mMaxDuration, boolean mUseMediaMuxer, boolean mUseSurfaceCapture) {
        this.BPP = BPP;
        this.mIframeIntervalsS = mIframeIntervalsS;
        this.mNumFramesBetweenIframeOn30fps = mNumFramesBetweenIframeOn30fps;
        this.mCaptureFps = mCaptureFps;
        this.mMaxDuration = mMaxDuration;
        this.mUseMediaMuxer = mUseMediaMuxer;
        this.mUseSurfaceCapture = mUseSurfaceCapture;
    }

    @NonNull
    public VideoConfig clone() throws CloneNotSupportedException {
        return (VideoConfig)super.clone();
    }

    public VideoConfig set(@NonNull VideoConfig src) {
        this.BPP = src.BPP;
        this.mIframeIntervalsS = src.mIframeIntervalsS;
        this.mNumFramesBetweenIframeOn30fps = src.mNumFramesBetweenIframeOn30fps;
        this.mCaptureFps = src.mCaptureFps;
        this.mMaxDuration = src.mMaxDuration;
        this.mUseMediaMuxer = src.mUseMediaMuxer;
        this.mUseSurfaceCapture = src.mUseSurfaceCapture;
        return this;
    }

    public VideoConfig reset() {
        return this.set(DEFAULT_CONFIG);
    }

    public long maxDuration() {
        return this.mMaxDuration;
    }

    @NonNull
    public VideoConfig setMaxDuration(long duration) {
        this.mMaxDuration = duration;
        return this;
    }

    public boolean useMediaMuxer() {
        return this.mUseMediaMuxer;
    }

    @NonNull
    public VideoConfig setUseMediaMuxer(boolean use) {
        this.mUseMediaMuxer = use & Build.VERSION.SDK_INT >= 18;
        return this;
    }

    public boolean useSurfaceCapture() {
        return this.mUseSurfaceCapture;
    }

    @NonNull
    public VideoConfig setUseSurfaceCapture(boolean use) {
        this.mUseSurfaceCapture = use & Build.VERSION.SDK_INT >= 18;
        return this;
    }

    @NonNull
    public VideoConfig setCaptureFps(int fps) {
        this.mCaptureFps = fps > 121 ? 121 : Math.max(fps, 2);
        return this;
    }

    public int captureFps() {
        return this.mCaptureFps > 121 ? 121 : Math.max(this.mCaptureFps, 2);
    }

    public Fraction getCaptureFps() {
        return new Fraction(this.captureFps(), 1);
    }

    @NonNull
    public VideoConfig setIFrameIntervals(float iFrameIntervalSecs) {
        this.mIframeIntervalsS = iFrameIntervalSecs;
        this.mNumFramesBetweenIframeOn30fps = this.mIframeIntervalsS * 30.0f;
        return this;
    }

    public int iFrameIntervals() {
        return (int)this.mIframeIntervalsS;
    }

    public Fraction getIFrameIntervals() {
        return new Fraction(this.mIframeIntervalsS);
    }

    public final int calcIFrameIntervals() {
        float iframe;
        int fps = this.captureFps();
        try {
            iframe = fps < 2 ? 1.0f : (float)Math.ceil(this.mNumFramesBetweenIframeOn30fps / (float)fps);
        }
        catch (Exception e) {
            iframe = this.mIframeIntervalsS;
        }
        if ((int)iframe < 1) {
            iframe = 1.0f;
        } else if ((int)iframe > 30) {
            iframe = 30.0f;
        }
        return (int)iframe;
    }

    private static int calcBitrate(int width, int height, int frameRate, float bpp) {
        int r = (int)(Math.floor(bpp * (float)frameRate * (float)width * (float)height / 1000.0f / 100.0f) * 100.0) * 1000;
        if (r < 200000) {
            r = 200000;
        } else if (r > 20000000) {
            r = 20000000;
        }
        return r;
    }

    public int getBitrate(int width, int height) {
        return VideoConfig.calcBitrate(width, height, this.captureFps(), this.BPP);
    }

    public int getBitrate(int width, int height, int frameRate) {
        return VideoConfig.calcBitrate(width, height, frameRate, this.BPP);
    }

    public int getBitrate(int width, int height, int frameRate, float bpp) {
        return VideoConfig.calcBitrate(width, height, frameRate, bpp);
    }

    private static float calcBPP(int width, int height, int captureFps, int bitrate) {
        return (float)bitrate / (float)(captureFps * width * height);
    }

    public float calcBPP(int width, int height, int bitrate) {
        return VideoConfig.calcBPP(width, height, this.captureFps(), bitrate);
    }

    @NonNull
    public VideoConfig setBPP(int width, int height, int bitrate) throws IllegalArgumentException {
        this.setBPP(this.calcBPP(width, height, bitrate));
        return this;
    }

    @NonNull
    public VideoConfig setBPP(float bpp) throws IllegalArgumentException {
        if (bpp < 0.01f || bpp > BPP_MAX) {
            throw new IllegalArgumentException("bpp should be within [BPP_MIN, BPP_MAX]");
        }
        this.BPP = bpp;
        return this;
    }

    public float bpp() {
        return this.BPP;
    }

    public int getSizeRate(int width, int height) {
        int bitrate = this.getBitrate(width, height);
        return bitrate * 60 / 8;
    }

    @NonNull
    public String toString() {
        return "VideoConfig{BPP=" + this.BPP + ", mIframeIntervalsS=" + this.mIframeIntervalsS + ", mNumFramesBetweenIframeOn30fps=" + this.mNumFramesBetweenIframeOn30fps + ", mCaptureFps=" + this.mCaptureFps + ", mMaxDuration=" + this.mMaxDuration + ", mUseMediaMuxer=" + this.mUseMediaMuxer + ", mUseSurfaceCapture=" + this.mUseSurfaceCapture + '}';
    }

    protected VideoConfig(Parcel in) {
        this.BPP = in.readFloat();
        this.mIframeIntervalsS = in.readFloat();
        this.mNumFramesBetweenIframeOn30fps = in.readFloat();
        this.mCaptureFps = in.readInt();
        this.mMaxDuration = in.readLong();
        this.mUseMediaMuxer = in.readByte() != 0;
        this.mUseSurfaceCapture = in.readByte() != 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(this.BPP);
        dest.writeFloat(this.mIframeIntervalsS);
        dest.writeFloat(this.mNumFramesBetweenIframeOn30fps);
        dest.writeInt(this.mCaptureFps);
        dest.writeLong(this.mMaxDuration);
        dest.writeByte((byte)(this.mUseMediaMuxer ? 1 : 0));
        dest.writeByte((byte)(this.mUseSurfaceCapture ? 1 : 0));
    }
}

