/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.hardware.display.VirtualDisplay;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.media.projection.MediaProjection;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.NonNull;
import com.serenegiant.egl.EGLBase;
import com.serenegiant.egl.EglTask;
import com.serenegiant.gl.GLDrawer2D;
import com.serenegiant.media.AbstractVideoEncoder;
import com.serenegiant.media.EncoderListener;
import com.serenegiant.media.IRecorder;
import com.serenegiant.media.MediaCodecUtils;
import com.serenegiant.media.MediaReaper;
import com.serenegiant.utils.HandlerThreadHandler;

@TargetApi(value=21)
public class MediaScreenEncoder
extends AbstractVideoEncoder {
    private static final boolean DEBUG = false;
    private static final String TAG = MediaScreenEncoder.class.getSimpleName();
    private static final String MIME = "video/avc";
    private MediaProjection mMediaProjection;
    private final int mDensity;
    private Surface mInputSurface;
    private final Handler mHandler;
    private volatile boolean requestDraw;
    @NonNull
    private final DrawTask mDrawTask = new DrawTask(null, 0);
    private final VirtualDisplay.Callback mCallback = new VirtualDisplay.Callback(){

        public void onPaused() {
        }

        public void onResumed() {
        }

        public void onStopped() {
            MediaScreenEncoder.this.mRequestStop = true;
        }
    };

    public MediaScreenEncoder(@NonNull IRecorder recorder, @NonNull EncoderListener listener, @NonNull MediaProjection projection, int density) {
        super(MIME, recorder, listener);
        this.mMediaProjection = projection;
        this.mDensity = density;
        this.mHandler = HandlerThreadHandler.createHandler(TAG);
    }

    @Override
    protected boolean internalPrepare(@NonNull MediaReaper.ReaperListener listener) throws Exception {
        this.mTrackIndex = -1;
        this.mIsCapturing = true;
        MediaCodecInfo codecInfo = MediaCodecUtils.selectVideoEncoder(MIME);
        if (codecInfo == null) {
            Log.e((String)TAG, (String)"Unable to find an appropriate codec for video/avc");
            return true;
        }
        MediaFormat format = MediaFormat.createVideoFormat((String)MIME, (int)this.mWidth, (int)this.mHeight);
        format.setInteger("color-format", 2130708361);
        format.setInteger("bitrate", this.mBitRate > 0 ? this.mBitRate : this.getConfig().getBitrate(this.mWidth, this.mHeight));
        format.setInteger("frame-rate", this.mFramerate > 0 ? this.mFramerate : this.getConfig().captureFps());
        format.setInteger("i-frame-interval", this.mIFrameIntervals > 0 ? this.mIFrameIntervals : this.getConfig().calcIFrameIntervals());
        this.mMediaCodec = MediaCodec.createEncoderByType((String)MIME);
        this.mMediaCodec.configure(format, null, null, 1);
        this.mInputSurface = this.mMediaCodec.createInputSurface();
        this.mMediaCodec.start();
        this.mReaper = new MediaReaper.VideoReaper(this.mMediaCodec, listener, this.mWidth, this.mHeight);
        new Thread((Runnable)this.mDrawTask, DrawTask.class.getSimpleName()).start();
        return false;
    }

    @Override
    public void release() {
        super.release();
        this.mInputSurface = null;
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void stop() {
        this.mDrawTask.release();
        super.stop();
    }

    @Override
    public void signalEndOfInputStream() {
        if (this.mMediaCodec != null) {
            this.mMediaCodec.signalEndOfInputStream();
        }
    }

    private final class DrawTask
    extends EglTask {
        private VirtualDisplay display;
        private long intervals;
        private int mTexId;
        private SurfaceTexture mSourceTexture;
        private Surface mSourceSurface;
        private EGLBase.IEglSurface mEncoderSurface;
        private GLDrawer2D mDrawer;
        private final float[] mTexMatrix;
        private final SurfaceTexture.OnFrameAvailableListener mOnFrameAvailableListener;
        private final Runnable mDrawTask;

        public DrawTask(EGLBase.IContext<?> sharedContext, int flags) {
            super(sharedContext, flags);
            this.mTexMatrix = new float[16];
            this.mOnFrameAvailableListener = new SurfaceTexture.OnFrameAvailableListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                    if (MediaScreenEncoder.this.mIsCapturing) {
                        Object object = MediaScreenEncoder.this.mSync;
                        synchronized (object) {
                            MediaScreenEncoder.this.requestDraw = true;
                            MediaScreenEncoder.this.mSync.notify();
                        }
                    }
                }
            };
            this.mDrawTask = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean localRequestDraw;
                    Object object = MediaScreenEncoder.this.mSync;
                    synchronized (object) {
                        localRequestDraw = MediaScreenEncoder.this.requestDraw;
                        if (!localRequestDraw) {
                            try {
                                MediaScreenEncoder.this.mSync.wait(DrawTask.this.intervals);
                                localRequestDraw = MediaScreenEncoder.this.requestDraw;
                                MediaScreenEncoder.this.requestDraw = false;
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                    }
                    if (MediaScreenEncoder.this.mIsCapturing && !MediaScreenEncoder.this.mRequestStop) {
                        if (localRequestDraw) {
                            DrawTask.this.mSourceTexture.updateTexImage();
                            DrawTask.this.mSourceTexture.getTransformMatrix(DrawTask.this.mTexMatrix);
                        }
                        DrawTask.this.mEncoderSurface.makeCurrent();
                        DrawTask.this.mDrawer.draw(33984, DrawTask.this.mTexId, DrawTask.this.mTexMatrix, 0);
                        DrawTask.this.mEncoderSurface.swap();
                        DrawTask.this.makeCurrent();
                        GLES20.glClear((int)16384);
                        GLES20.glFlush();
                        MediaScreenEncoder.this.frameAvailableSoon();
                        DrawTask.this.queueEvent(this);
                    } else {
                        DrawTask.this.releaseSelf();
                    }
                }
            };
        }

        @Override
        protected void onStart() {
            this.mDrawer = GLDrawer2D.create(this.isGLES3(), true);
            this.mTexId = this.mDrawer.initTex(33984);
            this.mSourceTexture = new SurfaceTexture(this.mTexId);
            this.mSourceTexture.setDefaultBufferSize(MediaScreenEncoder.this.mWidth, MediaScreenEncoder.this.mHeight);
            this.mSourceSurface = new Surface(this.mSourceTexture);
            this.mSourceTexture.setOnFrameAvailableListener(this.mOnFrameAvailableListener, MediaScreenEncoder.this.mHandler);
            this.mEncoderSurface = this.getEgl().createFromSurface(MediaScreenEncoder.this.mInputSurface);
            this.intervals = (long)(1000.0f / (float)MediaScreenEncoder.this.mFramerate);
            this.display = MediaScreenEncoder.this.mMediaProjection.createVirtualDisplay("Capturing Display", MediaScreenEncoder.this.mWidth, MediaScreenEncoder.this.mHeight, MediaScreenEncoder.this.mDensity, 16, this.mSourceSurface, MediaScreenEncoder.this.mCallback, MediaScreenEncoder.this.mHandler);
            this.queueEvent(this.mDrawTask);
        }

        @Override
        protected void onStop() {
            if (this.mDrawer != null) {
                this.mDrawer.release();
                this.mDrawer = null;
            }
            if (this.mSourceSurface != null) {
                this.mSourceSurface.release();
                this.mSourceSurface = null;
            }
            if (this.mSourceTexture != null) {
                this.mSourceTexture.release();
                this.mSourceTexture = null;
            }
            if (this.mEncoderSurface != null) {
                this.mEncoderSurface.release();
                this.mEncoderSurface = null;
            }
            this.makeCurrent();
            if (this.display != null && Build.VERSION.SDK_INT >= 19) {
                this.display.release();
            }
            if (MediaScreenEncoder.this.mMediaProjection != null) {
                MediaScreenEncoder.this.mMediaProjection.stop();
                MediaScreenEncoder.this.mMediaProjection = null;
            }
        }

        @Override
        protected boolean onError(Throwable e) {
            return false;
        }

        @Override
        protected Object processRequest(int request, int arg1, int arg2, Object obj) {
            return null;
        }
    }
}

