/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaScannerConnection;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.documentfile.provider.DocumentFile;
import com.serenegiant.media.IPostMuxer;
import com.serenegiant.media.MediaRawChannelWriter;
import com.serenegiant.media.PostMuxBuilder;
import com.serenegiant.media.VideoConfig;
import com.serenegiant.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;

public class MediaRawChannelMuxer
implements IPostMuxer {
    private static final boolean DEBUG = false;
    private static final String TAG = MediaRawChannelMuxer.class.getSimpleName();
    private final Object mSync = new Object();
    private final WeakReference<Context> mWeakContext;
    @NonNull
    private final VideoConfig mVideoConfig;
    private final MediaFormat mConfigFormatVideo;
    private final MediaFormat mConfigFormatAudio;
    @Deprecated
    @Nullable
    private final String mOutputPath;
    @Nullable
    private final DocumentFile mOutputDoc;
    @NonNull
    private final String mTempName;
    private volatile boolean mIsRunning;
    private boolean mReleased;
    private int mLastTrackIndex = -1;
    private MediaRawChannelWriter mVideoWriter;
    private MediaRawChannelWriter mAudioWriter;
    private final MediaRawChannelWriter[] mMediaRawFileWriters = new MediaRawChannelWriter[2];

    @Deprecated
    public MediaRawChannelMuxer(@NonNull Context context, @Nullable VideoConfig config, @NonNull String output, @Nullable MediaFormat configFormatVideo, @Nullable MediaFormat configFormatAudio) {
        this.mWeakContext = new WeakReference<Context>(context);
        this.mVideoConfig = config != null ? config : new VideoConfig();
        this.mOutputPath = output;
        this.mOutputDoc = null;
        this.mTempName = FileUtils.getDateTimeString();
        this.mConfigFormatVideo = configFormatVideo;
        this.mConfigFormatAudio = configFormatAudio;
    }

    public MediaRawChannelMuxer(@NonNull Context context, @Nullable VideoConfig config, @NonNull DocumentFile output, @Nullable MediaFormat configFormatVideo, @Nullable MediaFormat configFormatAudio) {
        this.mWeakContext = new WeakReference<Context>(context);
        this.mVideoConfig = config != null ? config : new VideoConfig();
        this.mOutputPath = null;
        this.mOutputDoc = output;
        this.mTempName = FileUtils.getDateTimeString();
        this.mConfigFormatVideo = configFormatVideo;
        this.mConfigFormatAudio = configFormatAudio;
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.mReleased) {
                this.mReleased = true;
                if (this.mVideoWriter != null) {
                    this.mVideoWriter.release();
                    this.mVideoWriter = null;
                }
                if (this.mAudioWriter != null) {
                    this.mAudioWriter.release();
                    this.mAudioWriter = null;
                }
                this.mMediaRawFileWriters[1] = null;
                this.mMediaRawFileWriters[0] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.mSync;
        synchronized (object) {
            this.checkReleased();
            if (this.mIsRunning) {
                throw new IllegalStateException("already started");
            }
            if (this.mLastTrackIndex < 0) {
                throw new IllegalStateException("no track added");
            }
            this.mIsRunning = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.mSync;
        synchronized (object) {
            this.mIsRunning = false;
            this.mLastTrackIndex = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build() throws IOException {
        Context context = this.getContext();
        String tempDir = this.getTempDir();
        if (!TextUtils.isEmpty((CharSequence)this.mOutputPath)) {
            try {
                PostMuxBuilder builder = new PostMuxBuilder(this.mVideoConfig.useMediaMuxer());
                builder.buildFromRawChannel(context, tempDir, this.mOutputPath);
            }
            finally {
                MediaRawChannelMuxer.delete(new File(tempDir));
            }
            try {
                MediaScannerConnection.scanFile((Context)context.getApplicationContext(), (String[])new String[]{this.mOutputPath}, null, null);
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        } else if (this.mOutputDoc != null) {
            try {
                PostMuxBuilder builder = new PostMuxBuilder(this.mVideoConfig.useMediaMuxer());
                builder.buildFromRawChannel(context, tempDir, this.mOutputDoc);
            }
            finally {
                MediaRawChannelMuxer.delete(new File(tempDir));
            }
        } else {
            throw new IOException("unexpected output file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStarted() {
        Object object = this.mSync;
        synchronized (object) {
            return !this.mReleased && this.mIsRunning;
        }
    }

    @Override
    public int addTrack(@NonNull MediaFormat format) throws IllegalArgumentException, IllegalStateException {
        String mime;
        this.checkReleased();
        if (this.mIsRunning) {
            throw new IllegalStateException("already started");
        }
        Context context = this.getContext();
        String tempDir = this.getTempDir();
        String string2 = mime = format.containsKey("mime") ? format.getString("mime") : null;
        if (!TextUtils.isEmpty((CharSequence)mime)) {
            Object object = this.mSync;
            synchronized (object) {
                int trackIndex = this.mLastTrackIndex + 1;
                if (mime.startsWith("video/")) {
                    if (this.mVideoWriter == null) {
                        try {
                            this.mMediaRawFileWriters[trackIndex] = this.mVideoWriter = MediaRawChannelWriter.newInstance(context, 0, this.mConfigFormatVideo != null ? this.mConfigFormatVideo : format, format, tempDir);
                            this.mLastTrackIndex = trackIndex;
                            return trackIndex;
                        }
                        catch (IOException e) {
                            throw new IllegalArgumentException(e);
                        }
                    }
                    throw new IllegalArgumentException("Video track is already added");
                }
                if (mime.startsWith("audio/")) {
                    if (this.mAudioWriter == null) {
                        try {
                            this.mMediaRawFileWriters[trackIndex] = this.mAudioWriter = MediaRawChannelWriter.newInstance(context, 1, this.mConfigFormatAudio != null ? this.mConfigFormatAudio : format, format, tempDir);
                            this.mLastTrackIndex = trackIndex;
                            return trackIndex;
                        }
                        catch (IOException e) {
                            throw new IllegalArgumentException(e);
                        }
                    }
                    throw new IllegalArgumentException("Audio track is already added");
                }
                throw new IllegalArgumentException("Unexpected mime type=" + mime);
            }
        }
        throw new IllegalArgumentException("Mime is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeSampleData(int trackIndex, @NonNull ByteBuffer buffer, @NonNull MediaCodec.BufferInfo info) {
        MediaRawChannelWriter writer;
        this.checkReleased();
        if (!this.mIsRunning) {
            throw new IllegalStateException("Can't write, muxer is not started");
        }
        if (trackIndex < 0 || trackIndex > this.mLastTrackIndex) {
            throw new IllegalArgumentException("trackIndex is invalid");
        }
        if (info.size < 0 || info.offset < 0 || info.offset + info.size > buffer.capacity() || info.presentationTimeUs < 0L) {
            throw new IllegalArgumentException("bufferInfo must specify a valid buffer offset, size and presentation time");
        }
        Object object = this.mSync;
        synchronized (object) {
            writer = this.mMediaRawFileWriters[trackIndex];
        }
        if (writer != null) {
            try {
                writer.writeSampleData(buffer, info);
            }
            catch (IOException e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    @Nullable
    protected Context getContext() {
        return (Context)this.mWeakContext.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReleased() throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mReleased) {
                throw new IllegalStateException("already released");
            }
        }
    }

    private String getTempDir() {
        Context context = this.getContext();
        try {
            return context.getDir(this.mTempName, 0).getAbsolutePath();
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
            return new File(Environment.getDataDirectory(), this.mTempName).getAbsolutePath();
        }
    }

    private static final void delete(@Nullable File path) {
        if (path != null) {
            try {
                if (path.isDirectory()) {
                    File[] files = path.listFiles();
                    int n = files != null ? files.length : 0;
                    for (int i = 0; i < n; ++i) {
                        MediaRawChannelMuxer.delete(files[i]);
                    }
                }
                path.delete();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }
}

