/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import androidx.annotation.NonNull;
import androidx.documentfile.provider.DocumentFile;
import com.serenegiant.media.MediaMuxerWrapper;
import com.serenegiant.system.BuildCheck;
import java.io.IOException;
import java.nio.ByteBuffer;

public interface IMuxer {
    public int addTrack(@NonNull MediaFormat var1);

    public void writeSampleData(int var1, @NonNull ByteBuffer var2, @NonNull MediaCodec.BufferInfo var3);

    public void start();

    public void stop();

    public void release();

    public boolean isStarted();

    public static class DefaultFactory
    implements IMuxerFactory {
        @Override
        @SuppressLint(value={"InlinedApi"})
        public IMuxer createMuxer(boolean useMediaMuxer, String outputPath) throws IOException {
            if (!useMediaMuxer || !BuildCheck.isAPI18()) {
                throw new IOException("Unsupported muxer type");
            }
            MediaMuxerWrapper result = new MediaMuxerWrapper(outputPath, 0);
            return result;
        }

        @Override
        @SuppressLint(value={"NewApi"})
        public IMuxer createMuxer(boolean useMediaMuxer, int fd) throws IOException {
            if (useMediaMuxer && BuildCheck.isAPI18()) {
                if (BuildCheck.isAPI29()) {
                    throw new UnsupportedOperationException("createMuxer from fd does not support on API29 and later devices");
                }
                if (!BuildCheck.isAPI26()) {
                    throw new UnsupportedOperationException("createMuxer from fd does not support on API<26");
                }
            } else {
                throw new IOException("Unsupported muxer type");
            }
            ParcelFileDescriptor pfd = ParcelFileDescriptor.fromFd((int)fd);
            MediaMuxerWrapper result = new MediaMuxerWrapper(pfd.getFileDescriptor(), 0);
            return result;
        }

        @Override
        @SuppressLint(value={"NewApi"})
        public IMuxer createMuxer(@NonNull Context context, boolean useMediaMuxer, @NonNull DocumentFile file) throws IOException {
            Uri uri = file.getUri();
            MediaMuxerWrapper result = null;
            if (useMediaMuxer && BuildCheck.isAPI18()) {
                result = MediaMuxerWrapper.newInstance(context, file, 0);
            }
            if (result == null) {
                throw new IOException("Unsupported muxer type");
            }
            return result;
        }
    }

    public static interface IMuxerFactory {
        @Deprecated
        public IMuxer createMuxer(boolean var1, String var2) throws IOException;

        @Deprecated
        public IMuxer createMuxer(boolean var1, int var2) throws IOException;

        public IMuxer createMuxer(@NonNull Context var1, boolean var2, @NonNull DocumentFile var3) throws IOException;
    }
}

