/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.graphics;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DrawFilter;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class ShaderDrawable
extends Drawable {
    private final Paint mPaint = new Paint();
    private final DrawFilter mDrawFilter;
    @Nullable
    private Shader mShader;

    public ShaderDrawable() {
        this(0, 0);
    }

    public ShaderDrawable(int clearflags) {
        this(clearflags, 0);
    }

    public ShaderDrawable(int clearflags, int setFlags) {
        this.mDrawFilter = new PaintFlagsDrawFilter(clearflags, setFlags);
    }

    public void draw(@NonNull Canvas canvas) {
        if (this.mShader != null) {
            int count = canvas.save();
            DrawFilter org = canvas.getDrawFilter();
            canvas.setDrawFilter(this.mDrawFilter);
            this.mPaint.setShader(this.mShader);
            canvas.drawPaint(this.mPaint);
            canvas.setDrawFilter(org);
            canvas.restoreToCount(count);
        }
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    @SuppressLint(value={"Override"})
    public ColorFilter getColorFilter() {
        return this.mPaint.getColorFilter();
    }

    public int getOpacity() {
        return 0;
    }

    public void setBounds(@NonNull RectF bounds) {
        super.setBounds((int)bounds.left, (int)bounds.top, (int)bounds.right, (int)bounds.bottom);
    }

    public void setBounds(float left, float top, float right, float bottom) {
        super.setBounds((int)left, (int)top, (int)right, (int)bottom);
    }

    public Shader setShader(@Nullable Shader shader) {
        if (this.mShader != shader) {
            this.mShader = shader;
        }
        return shader;
    }

    @Nullable
    public Shader getShader() {
        return this.mShader;
    }
}

