/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glutils;

import android.graphics.Bitmap;
import android.graphics.Paint;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.serenegiant.gl.GLSurface;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.glutils.GLImageReceiver;
import com.serenegiant.glutils.ImageReader;
import com.serenegiant.graphics.BitmapHelper;
import com.serenegiant.utils.Pool;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingDeque;

public class GLBitmapImageReader
implements ImageReader<Bitmap>,
GLImageReceiver.Callback {
    private static final boolean DEBUG = false;
    private static final String TAG = GLBitmapImageReader.class.getSimpleName();
    @NonNull
    private final Object mSync = new Object();
    @NonNull
    private final Bitmap.Config mConfig;
    private final int mMaxImages;
    @NonNull
    private final Pool<Bitmap> mPool;
    @NonNull
    private final LinkedBlockingDeque<Bitmap> mQueue = new LinkedBlockingDeque();
    @NonNull
    private final Paint mPaint = new Paint();
    @Nullable
    private ByteBuffer mWorkBuffer;
    private GLSurface mReadSurface;
    private volatile boolean mAllBitmapAcquired = false;
    @Nullable
    private ImageReader.OnImageAvailableListener<Bitmap> mListener;
    @Nullable
    private Handler mListenerHandler;
    private int mWidth;
    private int mHeight;
    private final Runnable mOnImageAvailableTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = GLBitmapImageReader.this.mSync;
            synchronized (object) {
                if (GLBitmapImageReader.this.mListener != null) {
                    GLBitmapImageReader.this.mListener.onImageAvailable(GLBitmapImageReader.this);
                }
            }
        }
    };

    public GLBitmapImageReader(int width, int height, final @NonNull Bitmap.Config config, int maxImages) {
        this.mWidth = width;
        this.mHeight = height;
        this.mConfig = config;
        this.mMaxImages = maxImages;
        this.mPool = new Pool<Bitmap>(1, maxImages, new Object[0]){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            protected Bitmap createObject(Object ... args) {
                Object object = GLBitmapImageReader.this.mSync;
                synchronized (object) {
                    return Bitmap.createBitmap((int)GLBitmapImageReader.this.mWidth, (int)GLBitmapImageReader.this.mHeight, (Bitmap.Config)config);
                }
            }
        };
    }

    @Override
    @WorkerThread
    public void onInitialize(@NonNull GLImageReceiver reader) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public void onRelease() {
        this.setOnImageAvailableListener((ImageReader.OnImageAvailableListener<Bitmap>)null, (Handler)null);
        LinkedBlockingDeque<Bitmap> linkedBlockingDeque = this.mQueue;
        synchronized (linkedBlockingDeque) {
            this.mQueue.clear();
        }
        this.mWorkBuffer = null;
        this.mPool.clear();
    }

    @Override
    @WorkerThread
    public void onCreateInputSurface(@NonNull GLImageReceiver reader) {
    }

    @Override
    @WorkerThread
    public void onReleaseInputSurface(@NonNull GLImageReceiver reader) {
        this.mWorkBuffer = null;
        if (this.mReadSurface != null) {
            this.mReadSurface.release();
            this.mReadSurface = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public void onResize(int width, int height) {
        Object object = this.mSync;
        synchronized (object) {
            this.mWidth = width;
            this.mHeight = height;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public void onFrameAvailable(@NonNull GLImageReceiver reader, boolean isOES, int texId, @NonNull float[] texMatrix) {
        Bitmap bitmap;
        int width = reader.getWidth();
        int height = reader.getHeight();
        int bytes = width * height * BitmapHelper.getPixelBytes(this.mConfig);
        if (this.mWorkBuffer == null || this.mWorkBuffer.capacity() != bytes) {
            Object object = this.mSync;
            synchronized (object) {
                this.mWidth = width;
                this.mHeight = height;
            }
            this.mWorkBuffer = ByteBuffer.allocateDirect(bytes);
        }
        if ((bitmap = this.obtainBitmap(width, height)) != null) {
            this.mAllBitmapAcquired = false;
            if (this.mReadSurface == null) {
                try {
                    this.mReadSurface = GLSurface.wrap(reader.isGLES3(), 36197, 33985, texId, width, height, false);
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                    return;
                }
            }
            this.mReadSurface.makeCurrent();
            this.mWorkBuffer.clear();
            GLUtils.glReadPixels(this.mWorkBuffer, width, height);
            this.mWorkBuffer.clear();
            bitmap.copyPixelsFromBuffer((Buffer)this.mWorkBuffer);
            LinkedBlockingDeque<Bitmap> linkedBlockingDeque = this.mQueue;
            synchronized (linkedBlockingDeque) {
                this.mQueue.addLast(bitmap);
            }
        }
        this.mAllBitmapAcquired = true;
        this.callOnFrameAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOnImageAvailableListener(@Nullable ImageReader.OnImageAvailableListener<Bitmap> listener, @Nullable Handler handler) throws IllegalArgumentException {
        Object object = this.mSync;
        synchronized (object) {
            if (listener != null) {
                Looper looper;
                Looper looper2 = looper = handler != null ? handler.getLooper() : Looper.myLooper();
                if (looper == null) {
                    throw new IllegalArgumentException("handler is null but the current thread is not a looper");
                }
                if (this.mListenerHandler == null || this.mListenerHandler.getLooper() != looper) {
                    this.mListenerHandler = new Handler(looper);
                }
                this.mListener = listener;
            } else {
                this.mListener = null;
                this.mListenerHandler = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Bitmap acquireLatestImage() throws IllegalStateException {
        LinkedBlockingDeque<Bitmap> linkedBlockingDeque = this.mQueue;
        synchronized (linkedBlockingDeque) {
            Bitmap result = this.mQueue.pollLast();
            while (!this.mQueue.isEmpty()) {
                this.recycle(this.mQueue.pollFirst());
            }
            if (this.mAllBitmapAcquired && result == null) {
                throw new IllegalStateException("all bitmap is acquired!");
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Bitmap acquireNextImage() throws IllegalStateException {
        LinkedBlockingDeque<Bitmap> linkedBlockingDeque = this.mQueue;
        synchronized (linkedBlockingDeque) {
            Bitmap result = this.mQueue.pollFirst();
            if (this.mAllBitmapAcquired && result == null) {
                throw new IllegalStateException("all bitmap is acquired!");
            }
            return result;
        }
    }

    @Override
    public void recycle(@NonNull Bitmap image) {
        this.mAllBitmapAcquired = false;
        if (!image.isRecycled()) {
            this.mPool.recycle(image);
        } else {
            this.mPool.release(image);
        }
    }

    public int getMaxImages() {
        return this.mMaxImages;
    }

    @NonNull
    public Bitmap.Config getConfig() {
        return this.mConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Bitmap obtainBitmap(int width, int height) {
        Bitmap result = this.mPool.obtain(new Object[0]);
        if (result == null) {
            LinkedBlockingDeque<Bitmap> linkedBlockingDeque = this.mQueue;
            synchronized (linkedBlockingDeque) {
                result = this.mQueue.pollFirst();
            }
        }
        if (result != null && (result.getWidth() != width || result.getHeight() != height)) {
            result = Bitmap.createBitmap((int)this.mWidth, (int)this.mHeight, (Bitmap.Config)this.mConfig);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callOnFrameAvailable() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mListenerHandler != null) {
                this.mListenerHandler.removeCallbacks(this.mOnImageAvailableTask);
                this.mListenerHandler.post(this.mOnImageAvailableTask);
            }
        }
    }
}

