/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glpipeline;

import android.opengl.GLES20;
import android.os.Handler;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.serenegiant.egl.EGLBase;
import com.serenegiant.gl.GLContext;
import com.serenegiant.gl.GLDrawer2D;
import com.serenegiant.gl.GLManager;
import com.serenegiant.glpipeline.ProxyPipeline;
import com.serenegiant.glutils.AbstractDistributeTask;
import com.serenegiant.glutils.IMirror;
import com.serenegiant.math.Fraction;

public class SurfaceDistributePipeline
extends ProxyPipeline
implements IMirror {
    private static final boolean DEBUG = false;
    private static final String TAG = SurfaceDistributePipeline.class.getSimpleName();
    private static final String RENDERER_THREAD_NAME = "SurfaceDistributePipeline";
    private final boolean mOwnManager;
    @NonNull
    private final GLManager mManager;
    @NonNull
    private final DistributeTask mDistributeTask;
    private volatile boolean isRunning;

    public SurfaceDistributePipeline(@NonNull GLManager manager) {
        this(manager, false, null);
    }

    public SurfaceDistributePipeline(@NonNull GLManager manager, boolean useSharedContext, @Nullable GLDrawer2D.DrawerFactory factory) {
        Handler glHandler;
        Handler.Callback handlerCallback = new Handler.Callback(){

            public boolean handleMessage(@NonNull Message msg) {
                SurfaceDistributePipeline.this.mDistributeTask.handleRequest(msg.what, msg.arg1, msg.arg2, msg.obj);
                return true;
            }
        };
        this.mOwnManager = useSharedContext;
        if (useSharedContext) {
            this.mManager = manager.createShared(handlerCallback);
            glHandler = this.mManager.getGLHandler();
        } else {
            this.mManager = manager;
            glHandler = manager.createGLHandler(handlerCallback);
        }
        this.mDistributeTask = new DistributeTask(this.mManager.getGLContext(), glHandler, this.getWidth(), this.getHeight(), factory);
        this.mDistributeTask.start(RENDERER_THREAD_NAME);
    }

    @Override
    protected void internalRelease() {
        if (this.isValid()) {
            this.mDistributeTask.release();
        }
        super.internalRelease();
    }

    @NonNull
    public GLManager getGLManager() throws IllegalStateException {
        return this.mManager;
    }

    @Override
    public void resize(int width, int height) throws IllegalStateException {
        super.resize(width, height);
        if (width > 0 && height > 0) {
            this.mDistributeTask.resize(width, height);
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.mDistributeTask.isRunning();
    }

    @Override
    @WorkerThread
    public void onFrameAvailable(boolean isOES, int texId, @NonNull @Size(min=16L) float[] texMatrix) {
        super.onFrameAvailable(isOES, texId, texMatrix);
        this.mDistributeTask.requestFrame(isOES, texId, texMatrix);
    }

    public void addSurface(int id2, Object surface, boolean isRecordable) throws IllegalStateException, IllegalArgumentException {
        this.mDistributeTask.addSurface(id2, surface);
    }

    public void addSurface(int id2, Object surface, boolean isRecordable, @Nullable Fraction maxFps) throws IllegalStateException, IllegalArgumentException {
        this.mDistributeTask.addSurface(id2, surface, maxFps);
    }

    public void removeSurface(int id2) {
        this.mDistributeTask.removeSurface(id2);
    }

    public void removeSurfaceAll() {
        this.mDistributeTask.removeSurfaceAll();
    }

    public void clearSurface(int id2, int color) {
        this.mDistributeTask.clearSurface(id2, color);
    }

    public void clearSurfaceAll(int color) {
        this.mDistributeTask.clearSurfaceAll(color);
    }

    public void setMvpMatrix(int id2, int offset, @NonNull float[] matrix) {
        this.mDistributeTask.setMvpMatrix(id2, offset, matrix);
    }

    @Override
    public void setMirror(int mirror) {
        this.mDistributeTask.setMirror(mirror % 4);
    }

    @Override
    public int getMirror() {
        return this.mDistributeTask.getMirror();
    }

    public boolean isEnabled(int id2) {
        return this.mDistributeTask.isEnabled(id2);
    }

    public void setEnabled(int id2, boolean enable) {
        this.mDistributeTask.setEnabled(id2, enable);
    }

    public int getCount() {
        return this.mDistributeTask.getCount();
    }

    private class DistributeTask
    extends AbstractDistributeTask {
        @NonNull
        private final GLContext mGLContext;
        @NonNull
        private final Handler mGLHandler;
        private final boolean isGLES3;
        private volatile boolean isRunning;

        public DistributeTask(@NonNull GLContext glContext, Handler glHandler, int width, @Nullable int height, GLDrawer2D.DrawerFactory factory) {
            super(width, height, factory);
            this.mGLContext = glContext;
            this.mGLHandler = glHandler;
            this.isGLES3 = glContext.isGLES3();
            this.isRunning = true;
        }

        @Override
        public void release() {
            if (this.isRunning) {
                this.isRunning = false;
                this.mGLHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        DistributeTask.this.handleOnStop();
                        if (SurfaceDistributePipeline.this.mOwnManager && SurfaceDistributePipeline.this.isValid()) {
                            SurfaceDistributePipeline.this.mManager.release();
                        }
                    }
                });
            }
            super.release();
        }

        @Override
        public void start(String tag) {
            this.mGLHandler.post(new Runnable(){

                @Override
                public void run() {
                    DistributeTask.this.handleOnStart();
                }
            });
        }

        @Override
        public boolean waitReady() {
            return true;
        }

        @Override
        public boolean isRunning() {
            return this.isRunning && SurfaceDistributePipeline.this.mManager.isValid();
        }

        @Override
        public boolean isFinished() {
            return !this.isRunning();
        }

        @Override
        public boolean offer(int request) {
            return this.mGLHandler.sendEmptyMessage(request);
        }

        @Override
        public boolean offer(int request, Object obj) {
            return this.mGLHandler.sendMessage(this.mGLHandler.obtainMessage(request, obj));
        }

        @Override
        public boolean offer(int request, int arg1) {
            return this.mGLHandler.sendMessage(this.mGLHandler.obtainMessage(request, (Object)arg1));
        }

        @Override
        public boolean offer(int request, int arg1, int arg2) {
            return this.mGLHandler.sendMessage(this.mGLHandler.obtainMessage(request, arg1, arg2));
        }

        @Override
        public boolean offer(int request, int arg1, int arg2, Object obj) {
            return this.mGLHandler.sendMessage(this.mGLHandler.obtainMessage(request, arg1, arg2, obj));
        }

        @Override
        public void removeRequest(int request) {
            this.mGLHandler.removeMessages(request);
        }

        @Override
        @NonNull
        public EGLBase getEgl() {
            return this.mGLContext.getEgl();
        }

        @Override
        @NonNull
        public GLContext getGLContext() {
            return this.mGLContext;
        }

        @Override
        @NonNull
        public EGLBase.IContext<?> getContext() {
            return this.mGLContext.getContext();
        }

        @Override
        public int getGlVersion() {
            return this.mGLContext.getGlVersion();
        }

        @Override
        public void makeCurrent() {
            this.mGLContext.makeDefault();
        }

        @Override
        public boolean isGLES3() {
            return this.isGLES3;
        }

        @Override
        public boolean isOES3Supported() {
            return this.mGLContext.isOES3Supported();
        }

        @Override
        public boolean isMasterSurfaceValid() {
            return true;
        }

        @Override
        @WorkerThread
        public void requestFrame(boolean isOES, int texId, @NonNull float[] texMatrix) {
            if (SurfaceDistributePipeline.this.mOwnManager || !this.isFirstFrameRendered()) {
                super.requestFrame(isOES, texId, texMatrix);
            } else {
                super.handleDrawTargets(isOES, texId, texMatrix);
                this.makeCurrent();
                GLES20.glClear((int)16384);
            }
        }

        @Override
        protected Object handleRequest(int request, int arg1, int arg2, Object obj) {
            return super.handleRequest(request, arg1, arg2, obj);
        }

        @Override
        protected void handleReCreateInputSurface() {
        }

        @Override
        protected void handleReleaseInputSurface() {
        }

        @Override
        protected void handleUpdateTexture() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyParent(boolean isRunning) {
            SurfaceDistributePipeline surfaceDistributePipeline = SurfaceDistributePipeline.this;
            synchronized (surfaceDistributePipeline) {
                SurfaceDistributePipeline.this.isRunning = isRunning;
                SurfaceDistributePipeline.this.notifyAll();
            }
        }

        @Override
        public void callOnFrameAvailable() {
        }
    }
}

