/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.gl;

import android.annotation.SuppressLint;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.serenegiant.gl.GLConst;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.gl.IGLSurface;
import com.serenegiant.gl.ShaderConst;
import com.serenegiant.utils.BufferHelper;
import java.nio.FloatBuffer;

public class GLDrawer2D
implements GLConst {
    private static final boolean DEBUG = false;
    private static final String TAG = GLDrawer2D.class.getSimpleName();
    public static DrawerFactory DEFAULT_FACTORY = new DrawerFactory(){

        @Override
        @NonNull
        public GLDrawer2D create(boolean isGLES3, boolean isOES) {
            return GLDrawer2D.create(isGLES3, isOES);
        }
    };
    protected static final boolean USE_VBO = true;
    protected static final float[] DEFAULT_VERTICES = new float[]{1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f};
    protected static final float[] DEFAULT_TEXCOORD = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
    protected static final float[] DEFAULT_TEXCOORD_FLIP_VERTICAL = new float[]{1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f};
    protected static final int FLOAT_SZ = 4;
    private int mBufVertex = -1;
    private int mBufTexCoord = -1;
    public final boolean isGLES3;
    protected final int VERTEX_NUM;
    protected final int VERTEX_SZ;
    protected final FloatBuffer pVertex;
    protected final FloatBuffer pTexCoord;
    protected final int mTexTarget;
    protected int hProgram;
    protected int maPositionLoc;
    protected int maTextureCoordLoc;
    protected int muTextureLoc;
    protected int muMVPMatrixLoc;
    protected int muTexMatrixLoc;
    @Size(min=16L)
    @NonNull
    protected final float[] mMvpMatrix = new float[16];
    private int errCnt;
    private final int[] status = new int[1];

    public static GLDrawer2D create(boolean isGLES3, boolean isOES) {
        return GLDrawer2D.create(isGLES3, isOES, null, null, null, null);
    }

    @SuppressLint(value={"NewApi"})
    public static GLDrawer2D create(boolean isGLES3, boolean isOES, @Nullable String fs) {
        return GLDrawer2D.create(isGLES3, isOES, null, null, null, fs);
    }

    @SuppressLint(value={"NewApi"})
    public static GLDrawer2D create(boolean isGLES3, boolean isOES, @Nullable String vs, @Nullable String fs) {
        return GLDrawer2D.create(isGLES3, isOES, null, null, vs, fs);
    }

    @SuppressLint(value={"NewApi"})
    public static GLDrawer2D create(boolean isGLES3, boolean isOES, @NonNull float[] vertices, @NonNull float[] texcoord) {
        return GLDrawer2D.create(isGLES3, isOES, vertices, texcoord, null, null);
    }

    @SuppressLint(value={"NewApi"})
    public static GLDrawer2D create(boolean isGLES3, boolean isOES, @NonNull float[] vertices, @NonNull float[] texcoord, @Nullable String fs) {
        return GLDrawer2D.create(isGLES3, isOES, vertices, texcoord, null, fs);
    }

    @SuppressLint(value={"NewApi"})
    public static GLDrawer2D create(boolean isGLES3, boolean isOES, @Nullable float[] vertices, @Nullable float[] texcoord, @Nullable String vs, @Nullable String fs) {
        if (isGLES3 && GLUtils.getSupportedGLVersion() > 2) {
            return new GLDrawer2D(true, isOES, vertices, texcoord, vs, fs);
        }
        return new GLDrawer2D(false, isOES, vertices, texcoord, vs, fs);
    }

    protected GLDrawer2D(boolean isGLES3, boolean isOES, @Nullable @Size(min=8L) float[] vertices, @Nullable @Size(min=8L) float[] texcoord, @Nullable String vs, @Nullable String fs) {
        String _vs;
        this.isGLES3 = isGLES3;
        float[] _vertices = vertices != null && vertices.length >= 2 ? vertices : DEFAULT_VERTICES;
        float[] _texcoord = texcoord != null && texcoord.length >= 2 ? texcoord : DEFAULT_TEXCOORD;
        this.VERTEX_NUM = Math.min(_vertices.length, _texcoord.length) / 2;
        this.VERTEX_SZ = this.VERTEX_NUM * 2;
        String string2 = !TextUtils.isEmpty((CharSequence)vs) ? vs : (_vs = isGLES3 ? "#version 300 es\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nin highp vec4 aPosition;\nin highp vec4 aTextureCoord;\nout highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n" : "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n");
        String _fs = !TextUtils.isEmpty((CharSequence)fs) ? fs : (isGLES3 ? (isOES ? ShaderConst.FRAGMENT_SHADER_EXT_ES3 : ShaderConst.FRAGMENT_SHADER_ES3) : (isOES ? ShaderConst.FRAGMENT_SHADER_EXT_ES2 : ShaderConst.FRAGMENT_SHADER_ES2));
        this.mTexTarget = isOES ? 36197 : 3553;
        this.pVertex = BufferHelper.createFloatBuffer(_vertices);
        this.pTexCoord = BufferHelper.createFloatBuffer(_texcoord);
        Matrix.setIdentityM((float[])this.mMvpMatrix, (int)0);
        this.updateShader(_vs, _fs);
    }

    @CallSuper
    public void release() {
        this.releaseShader();
    }

    public boolean isOES() {
        return this.mTexTarget == 36197;
    }

    @Size(min=16L)
    @NonNull
    public float[] getMvpMatrix() {
        return this.mMvpMatrix;
    }

    public GLDrawer2D setMvpMatrix(@NonNull @Size(min=16L) float[] matrix, int offset) {
        System.arraycopy(matrix, offset, this.mMvpMatrix, 0, 16);
        return this;
    }

    public void copyMvpMatrix(@NonNull @Size(min=16L) float[] matrix, int offset) {
        System.arraycopy(this.mMvpMatrix, 0, matrix, offset, 16);
    }

    public void setMirror(int mirror) {
        GLUtils.setMirror(this.mMvpMatrix, mirror);
    }

    public void rotate(int degrees) {
        GLUtils.rotate(this.mMvpMatrix, degrees);
    }

    public void setRotation(int degrees) {
        GLUtils.setRotation(this.mMvpMatrix, degrees);
    }

    public void draw(@NonNull IGLSurface surface) {
        this.draw(surface.getTexUnit(), surface.getTexId(), surface.getTexMatrix(), 0, this.mMvpMatrix, 0);
    }

    public synchronized void draw(int texUnit, int texId, @Nullable float[] tex_matrix, int offset) {
        this.draw(texUnit, texId, tex_matrix, offset, this.mMvpMatrix, 0);
    }

    public synchronized void draw(int texUnit, int texId, @Nullable float[] tex_matrix, int tex_offset, @Nullable float[] mvp_matrix, int mvp_offset) {
        if (this.hProgram < 0) {
            return;
        }
        this.glUseProgram();
        if (tex_matrix != null) {
            this.updateTexMatrix(tex_matrix, tex_offset);
        }
        if (mvp_matrix != null) {
            this.updateMvpMatrix(mvp_matrix, mvp_offset);
        }
        this.bindTexture(texUnit, texId);
        if (this.validateProgram(this.hProgram)) {
            this.drawVertices();
            this.errCnt = 0;
        } else if (this.errCnt++ == 0) {
            Log.w((String)TAG, (String)"draw:invalid program");
            this.resetShader();
        }
        this.finishDraw();
    }

    protected void updateTexMatrix(@NonNull @Size(min=16L) float[] texMatrix, int offset) {
        GLES20.glUniformMatrix4fv((int)this.muTexMatrixLoc, (int)1, (boolean)false, (float[])texMatrix, (int)offset);
    }

    protected void updateMvpMatrix(@NonNull @Size(min=16L) float[] mvpMatrix, int offset) {
        GLES20.glUniformMatrix4fv((int)this.muMVPMatrixLoc, (int)1, (boolean)false, (float[])mvpMatrix, (int)offset);
    }

    protected void bindTexture(int texUnit, int texId) {
        GLES20.glActiveTexture((int)texUnit);
        GLES20.glBindTexture((int)this.mTexTarget, (int)texId);
        GLES20.glUniform1i((int)this.muTextureLoc, (int)GLUtils.gLTextureUnit2Index(texUnit));
    }

    protected void updateVertices() {
        if (this.mBufVertex <= -1) {
            this.pVertex.clear();
            this.mBufVertex = GLUtils.createBuffer(34962, this.pVertex, 35044);
        }
        if (this.mBufTexCoord <= -1) {
            this.pTexCoord.clear();
            this.mBufTexCoord = GLUtils.createBuffer(34962, this.pTexCoord, 35044);
        }
        GLES20.glBindBuffer((int)34962, (int)this.mBufVertex);
        GLES20.glVertexAttribPointer((int)this.maPositionLoc, (int)2, (int)5126, (boolean)false, (int)0, (int)0);
        GLES20.glEnableVertexAttribArray((int)this.maPositionLoc);
        GLES20.glBindBuffer((int)34962, (int)this.mBufTexCoord);
        GLES20.glVertexAttribPointer((int)this.maTextureCoordLoc, (int)2, (int)5126, (boolean)false, (int)0, (int)0);
        GLES20.glEnableVertexAttribArray((int)this.maTextureCoordLoc);
    }

    protected void drawVertices() {
        GLES20.glDrawArrays((int)5, (int)0, (int)this.VERTEX_NUM);
    }

    protected void finishDraw() {
        GLES20.glBindTexture((int)this.mTexTarget, (int)0);
        GLES20.glUseProgram((int)0);
    }

    public int initTex(int texUnit) {
        return GLUtils.initTex(this.mTexTarget, texUnit, 9728);
    }

    public int initTex(int texUnit, int filterParam) {
        return GLUtils.initTex(this.mTexTarget, texUnit, filterParam);
    }

    public void deleteTex(int hTex) {
        GLUtils.deleteTex(hTex);
    }

    public synchronized void updateShader(@NonNull String vs, @NonNull String fs) {
        this.releaseShader();
        this.hProgram = this.loadShader(vs, fs);
        this.init();
    }

    public void updateShader(@NonNull String fs) {
        this.updateShader(this.isGLES3 ? "#version 300 es\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nin highp vec4 aPosition;\nin highp vec4 aTextureCoord;\nout highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n" : "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", fs);
    }

    public void resetShader() {
        this.releaseShader();
        this.hProgram = this.isGLES3 ? this.loadShader("#version 300 es\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nin highp vec4 aPosition;\nin highp vec4 aTextureCoord;\nout highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", this.isOES() ? ShaderConst.FRAGMENT_SHADER_EXT_ES3 : ShaderConst.FRAGMENT_SHADER_ES3) : this.loadShader("#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", this.isOES() ? ShaderConst.FRAGMENT_SHADER_EXT_ES2 : ShaderConst.FRAGMENT_SHADER_ES2);
        this.init();
    }

    protected void releaseShader() {
        if (this.hProgram > -1) {
            this.internalReleaseShader(this.hProgram);
        }
        this.hProgram = -1;
    }

    protected int loadShader(@NonNull String vs, @NonNull String fs) {
        return GLUtils.loadShader(vs, fs);
    }

    protected void internalReleaseShader(int program) {
        if (this.mBufVertex > -1) {
            GLUtils.deleteBuffer(this.mBufVertex);
            this.mBufVertex = -1;
        }
        if (this.mBufTexCoord > -1) {
            GLUtils.deleteBuffer(this.mBufTexCoord);
            this.mBufTexCoord = -1;
        }
        GLES20.glDeleteProgram((int)program);
    }

    public int glGetAttribLocation(@NonNull String name) {
        GLES20.glUseProgram((int)this.hProgram);
        return GLES20.glGetAttribLocation((int)this.hProgram, (String)name);
    }

    public int glGetUniformLocation(@NonNull String name) {
        GLES20.glUseProgram((int)this.hProgram);
        return GLES20.glGetUniformLocation((int)this.hProgram, (String)name);
    }

    public void glUseProgram() {
        GLES20.glUseProgram((int)this.hProgram);
    }

    protected void init() {
        GLES20.glUseProgram((int)this.hProgram);
        this.maPositionLoc = GLES20.glGetAttribLocation((int)this.hProgram, (String)"aPosition");
        this.maTextureCoordLoc = GLES20.glGetAttribLocation((int)this.hProgram, (String)"aTextureCoord");
        this.muTextureLoc = GLES20.glGetAttribLocation((int)this.hProgram, (String)"sTexture");
        this.muMVPMatrixLoc = GLES20.glGetUniformLocation((int)this.hProgram, (String)"uMVPMatrix");
        this.muTexMatrixLoc = GLES20.glGetUniformLocation((int)this.hProgram, (String)"uTexMatrix");
        GLES20.glUniformMatrix4fv((int)this.muMVPMatrixLoc, (int)1, (boolean)false, (float[])this.mMvpMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.muTexMatrixLoc, (int)1, (boolean)false, (float[])this.mMvpMatrix, (int)0);
        this.updateVertices();
    }

    protected boolean validateProgram(int program) {
        if (program >= 0) {
            GLES20.glValidateProgram((int)program);
            GLES20.glGetProgramiv((int)program, (int)35715, (int[])this.status, (int)0);
            return this.status[0] == 1;
        }
        return false;
    }

    public static interface DrawerFactory {
        @NonNull
        public GLDrawer2D create(boolean var1, boolean var2);
    }
}

