/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.db;

import android.annotation.SuppressLint;
import android.database.Cursor;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public final class CursorHelper {
    private static final boolean DEBUG = false;
    private static final String TAG = CursorHelper.class.getSimpleName();

    private CursorHelper() {
    }

    public static String get(@Nullable Cursor cursor, @NonNull String columnName, @Nullable String defaultValue) {
        String result = defaultValue;
        if (cursor != null && !cursor.isClosed()) {
            try {
                result = cursor.getString(cursor.getColumnIndexOrThrow(columnName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static CharSequence get(@Nullable Cursor cursor, @NonNull String columnName, @Nullable CharSequence defaultValue) {
        CharSequence result = defaultValue;
        if (cursor != null && !cursor.isClosed()) {
            try {
                result = cursor.getString(cursor.getColumnIndexOrThrow(columnName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static String getString(@Nullable Cursor cursor, @NonNull String columnName, @Nullable CharSequence defaultValue) {
        CharSequence result = CursorHelper.get(cursor, columnName, defaultValue);
        return result != null ? result.toString() : null;
    }

    public static int get(@Nullable Cursor cursor, @NonNull String columnName, int defaultValue) {
        int result = defaultValue;
        if (cursor != null && !cursor.isClosed()) {
            try {
                result = cursor.getInt(cursor.getColumnIndexOrThrow(columnName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static short get(@Nullable Cursor cursor, @NonNull String columnName, short defaultValue) {
        short result = defaultValue;
        if (cursor != null && !cursor.isClosed()) {
            try {
                result = cursor.getShort(cursor.getColumnIndexOrThrow(columnName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static long get(@Nullable Cursor cursor, @NonNull String columnName, long defaultValue) {
        long result = defaultValue;
        if (cursor != null && !cursor.isClosed()) {
            try {
                result = cursor.getLong(cursor.getColumnIndexOrThrow(columnName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static float get(@Nullable Cursor cursor, @NonNull String columnName, float defaultValue) {
        float result = defaultValue;
        if (cursor != null && !cursor.isClosed()) {
            try {
                result = cursor.getFloat(cursor.getColumnIndexOrThrow(columnName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static double get(@Nullable Cursor cursor, @NonNull String columnName, double defaultValue) {
        double result = defaultValue;
        if (cursor != null && !cursor.isClosed()) {
            try {
                result = cursor.getDouble(cursor.getColumnIndexOrThrow(columnName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findPositionFromId(@Nullable Cursor cursor, long requestID) {
        int position;
        block5: {
            position = -1;
            if (cursor != null && !cursor.isClosed()) {
                int savedPosition = cursor.getPosition();
                try {
                    if (!cursor.moveToFirst()) break block5;
                    do {
                        long rowId;
                        if ((rowId = CursorHelper.get(cursor, "_id", 0L)) != requestID) continue;
                        position = cursor.getPosition();
                        break;
                    } while (cursor.moveToNext());
                }
                finally {
                    cursor.moveToPosition(savedPosition);
                }
            }
        }
        return position;
    }

    @SuppressLint(value={"NewApi"})
    public static void dumpCursor(@Nullable Cursor cursor) {
        if (cursor != null && !cursor.isClosed() && cursor.moveToFirst()) {
            StringBuilder sb = new StringBuilder();
            int n = cursor.getColumnCount();
            String[] columnNames = cursor.getColumnNames();
            int row = 0;
            do {
                sb.setLength(0);
                sb.append("row=").append(row).append(", ");
                for (int i = 0; i < n; ++i) {
                    switch (cursor.getType(i)) {
                        case 2: {
                            sb.append(columnNames[i]).append("=").append(cursor.getDouble(i));
                            break;
                        }
                        case 1: {
                            sb.append(columnNames[i]).append("=").append(cursor.getLong(i));
                            break;
                        }
                        case 3: {
                            sb.append(columnNames[i]).append("=").append(cursor.getString(i));
                            break;
                        }
                        case 4: {
                            sb.append(columnNames[i]).append("=").append("BLOB");
                            break;
                        }
                        case 0: {
                            sb.append(columnNames[i]).append("=").append("NULL");
                            break;
                        }
                        default: {
                            sb.append(columnNames[i]).append("=").append("UNKNOWN");
                        }
                    }
                    sb.append(", ");
                }
                Log.v((String)TAG, (String)("dumpCursor:" + sb));
                ++row;
            } while (cursor.moveToNext());
        }
    }

    public static String toString(@Nullable Cursor cursor) {
        if (cursor == null) {
            return "{null}";
        }
        if (cursor.isClosed()) {
            return "{closed}";
        }
        if (cursor.isBeforeFirst()) {
            return "{before first}";
        }
        if (cursor.isAfterLast()) {
            return "{after last}";
        }
        StringBuilder sb = new StringBuilder();
        int n = cursor.getColumnCount();
        String[] columnNames = cursor.getColumnNames();
        sb.append("{");
        for (int i = 0; i < n; ++i) {
            switch (cursor.getType(i)) {
                case 2: {
                    sb.append(columnNames[i]).append("=").append(cursor.getDouble(i));
                    break;
                }
                case 1: {
                    sb.append(columnNames[i]).append("=").append(cursor.getLong(i));
                    break;
                }
                case 3: {
                    sb.append(columnNames[i]).append("=").append(cursor.getString(i));
                    break;
                }
                case 4: {
                    sb.append(columnNames[i]).append("=").append("BLOB");
                    break;
                }
                case 0: {
                    sb.append(columnNames[i]).append("=").append("NULL");
                    break;
                }
                default: {
                    sb.append(columnNames[i]).append("=").append("UNKNOWN");
                }
            }
            if (i >= n - 1) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }
}

