/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.camera;

import androidx.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;

public interface CameraConst {
    public static final int FACING_UNSPECIFIED = -1;
    public static final int FACING_BACK = 0;
    public static final int FACING_FRONT = 1;
    public static final int DEFAULT_WIDTH = 640;
    public static final int DEFAULT_HEIGHT = 480;

    public static final class CameraInfo {
        public String id;
        public int face;
        public int orientation;
        public int width;
        public int height;

        public CameraInfo() {
        }

        public CameraInfo(String id2, int face, int orientation, int width, int height) {
            this.id = id2;
            this.face = face;
            this.orientation = orientation;
            this.width = width;
            this.height = height;
        }

        public CameraInfo(String id2, int face, int orientation) {
            this.id = id2;
            this.face = face;
            this.orientation = orientation;
        }

        public void set(String id2, int face, int orientation, int width, int height) {
            this.id = id2;
            this.face = face;
            this.orientation = orientation;
            this.width = width;
            this.height = height;
        }

        public void set(@NonNull CameraInfo other) {
            this.id = other.id;
            this.face = other.face;
            this.orientation = other.orientation;
            this.width = other.width;
            this.height = other.height;
        }

        public void set(int face) {
            this.face = face;
            this.id = String.format(Locale.US, "FACE_%d", face);
        }

        @NonNull
        public String toString() {
            return String.format(Locale.US, "Size(%dx%d),face=%d, id=%s, orientation=%d", this.width, this.height, this.face, this.id, this.orientation);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FaceType {
    }
}

