/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.uvc;

import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import com.serenegiant.usb.uvc.IPipeline;

@Keep
public class DistributePipeline
extends IPipeline {
    private static final String TAG = DistributePipeline.class.getSimpleName();

    public DistributePipeline() {
        super(400);
        this.mNativePtr = this.nativeCreate();
    }

    @Override
    public int getState() {
        return this.nativeGetState(this.mNativePtr);
    }

    @Override
    public void setPipeline(@Nullable IPipeline next_pipeline) {
        if (this.getState() < 20) {
            throw new IllegalStateException("already released");
        }
        this.nativeSetPipeline(this.mNativePtr, next_pipeline);
    }

    @Override
    public void start() {
        int result = DistributePipeline.nativeStart(this.mNativePtr);
        if (result != 0) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void stop() {
        int result = DistributePipeline.nativeStop(this.mNativePtr);
        if (result != 0) {
            Log.w((String)TAG, (String)("nativeStop returned " + result));
        }
    }

    @Override
    public void release() {
        this.nativeDestroy(this.mNativePtr);
        this.mNativePtr = 0L;
    }

    public void addPipeline(IPipeline next_pipeline) {
        if (this.getState() <= 10) {
            throw new IllegalStateException("already released");
        }
        this.nativeAddPipeline(this.mNativePtr, next_pipeline);
    }

    public void removePipeline(IPipeline next_pipeline) {
        if (this.getState() > 10) {
            this.nativeRemovePipeline(this.mNativePtr, next_pipeline);
        }
    }

    public int getCounts() {
        int result = DistributePipeline.nativeGetCounts(this.mNativePtr);
        if (result < 0) {
            throw new IllegalStateException();
        }
        return result;
    }

    private final native long nativeCreate();

    private final native void nativeDestroy(long var1);

    private final native int nativeGetState(long var1);

    private final native int nativeSetPipeline(long var1, IPipeline var3);

    private final native int nativeAddPipeline(long var1, IPipeline var3);

    private final native int nativeRemovePipeline(long var1, IPipeline var3);

    private static final native int nativeGetCounts(long var0);

    private static final native int nativeStart(long var0);

    private static final native int nativeStop(long var0);
}

