/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.XmlRes;
import com.serenegiant.libaandusb.R;
import com.serenegiant.usb.DeviceDetector;
import com.serenegiant.usb.DeviceFilter;
import com.serenegiant.usb.NativeLibLoader;
import com.serenegiant.usb.USBMonitor;
import com.serenegiant.utils.HandlerThreadHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DeviceDetectorFragment
extends Fragment {
    private static final boolean DEBUG = false;
    private static final String TAG = DeviceDetectorFragment.class.getSimpleName();
    private static final String ARGS_DEVICE_FILTERS = "ARGS_DEVICE_FILTERS";
    private final Object mSync = new Object();
    @NonNull
    private final DeviceDetector mDeviceDetector = DeviceDetector.getInstance();
    private USBMonitor mUSBMonitor;
    private Handler mAsyncHandler;
    private final USBMonitor.OnDeviceConnectListener mOnDeviceConnectListener = new USBMonitor.OnDeviceConnectListener(){

        public void onAttach(@NonNull UsbDevice device) {
            if (DeviceDetectorFragment.this.mUSBMonitor.hasPermission(device)) {
                DeviceDetectorFragment.this.addDevice(device);
            } else {
                DeviceDetectorFragment.this.mUSBMonitor.requestPermission(device);
            }
        }

        public void onPermission(@NonNull UsbDevice device) {
            DeviceDetectorFragment.this.addDevice(device);
        }

        public void onConnected(@NonNull UsbDevice device, @NonNull USBMonitor.UsbControlBlock ctrlBlock) {
        }

        public void onDisconnect(@NonNull UsbDevice device) {
        }

        public void onDetach(@NonNull UsbDevice device) {
            DeviceDetectorFragment.this.mDeviceDetector.remove(device.getDeviceName());
        }

        public void onCancel(@NonNull UsbDevice device) {
        }

        public void onError(UsbDevice device, @NonNull Throwable t) {
            Log.w((String)TAG, (String)"OnDeviceConnectListener#onError:", (Throwable)t);
        }
    };
    private final DeviceDetector.DeviceDetectorCallback mDeviceDetectorCallback = new DeviceDetector.DeviceDetectorCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRequestRefreshDevices() {
            Object object = DeviceDetectorFragment.this.mSync;
            synchronized (object) {
                if (DeviceDetectorFragment.this.mAsyncHandler != null) {
                    DeviceDetectorFragment.this.mAsyncHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            DeviceDetectorFragment.this.mDeviceDetector.clearAll();
                            if (DeviceDetectorFragment.this.mUSBMonitor != null && DeviceDetectorFragment.this.mUSBMonitor.isRegistered()) {
                                DeviceDetectorFragment.this.mUSBMonitor.refreshDevices();
                            }
                        }
                    });
                }
            }
        }
    };

    public static void initUVCDeviceDetector(@NonNull Activity activity) {
        DeviceDetectorFragment.initDeviceDetector(activity, R.xml.device_filter_uvc);
    }

    public static void initDeviceDetector(@NonNull Activity activity, @XmlRes int filtersXml) {
        FragmentManager fm = activity.getFragmentManager();
        Fragment detector = fm.findFragmentByTag(DeviceDetectorFragment.class.getName());
        if (!(detector instanceof DeviceDetectorFragment)) {
            FragmentTransaction ft = fm.beginTransaction();
            if (detector != null) {
                ft.remove(detector);
            }
            detector = new DeviceDetectorFragment();
            Bundle args = new Bundle();
            if (filtersXml != 0) {
                List filters = DeviceFilter.getDeviceFilters((Context)activity, (int)filtersXml);
                args.putParcelableArrayList(ARGS_DEVICE_FILTERS, new ArrayList(filters));
            }
            detector.setArguments(args);
            ft.add(detector, DeviceDetectorFragment.class.getName()).commit();
        }
    }

    public DeviceDetectorFragment() {
        this.setRetainInstance(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAttach(Context context) {
        ArrayList filters;
        super.onAttach(context);
        Object object = this.mSync;
        synchronized (object) {
            this.mAsyncHandler = HandlerThreadHandler.createHandler((String)TAG);
        }
        this.mUSBMonitor = new USBMonitor(context, this.mOnDeviceConnectListener);
        Bundle args = this.getArguments();
        if (args != null && (filters = args.getParcelableArrayList(ARGS_DEVICE_FILTERS)) != null) {
            this.mUSBMonitor.setDeviceFilter((List)filters);
        }
        this.mDeviceDetector.add(this.mDeviceDetectorCallback);
    }

    public void onStart() {
        super.onStart();
        if (this.mUSBMonitor != null) {
            this.mUSBMonitor.register();
        }
    }

    public void onStop() {
        if (this.mUSBMonitor != null) {
            this.mUSBMonitor.unregister();
        }
        super.onStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDetach() {
        this.mDeviceDetector.remove(this.mDeviceDetectorCallback);
        if (this.mUSBMonitor != null) {
            this.mUSBMonitor.destroy();
            this.mUSBMonitor = null;
        }
        Object object = this.mSync;
        synchronized (object) {
            if (this.mAsyncHandler != null) {
                try {
                    this.mAsyncHandler.removeCallbacksAndMessages(null);
                    this.mAsyncHandler.getLooper().quit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mAsyncHandler = null;
            }
        }
        super.onDetach();
    }

    private void addDevice(@NonNull UsbDevice device) {
        if (this.mUSBMonitor.hasPermission(device)) {
            try {
                USBMonitor.UsbControlBlock ctrl = this.mUSBMonitor.openDevice(device);
                this.mDeviceDetector.add(device.getDeviceName(), ctrl.getFileDescriptor());
            }
            catch (IOException e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    static {
        NativeLibLoader.loadNative();
    }
}

