/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.camera;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.view.Display;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.camera.AbstractCamera;
import com.serenegiant.camera.BuiltInCamera;
import com.serenegiant.camera.BuiltInCamera2;
import com.serenegiant.camera.CameraConst;
import com.serenegiant.camera.FuncMaxMinDef;
import com.serenegiant.camera.ICamera;
import com.serenegiant.camera.ICameraControlEx;
import com.serenegiant.camera.ISurfacePreview;
import com.serenegiant.camera.RawFrameType;
import com.serenegiant.camera.Size;
import com.serenegiant.camera.SizeUtils;
import com.serenegiant.glutils.IRendererHolder;
import com.serenegiant.glutils.RendererHolder;
import com.serenegiant.system.BuildCheck;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractBuiltInCamera<T>
extends AbstractCamera
implements CameraConst,
ICamera,
ISurfacePreview,
ICameraControlEx {
    private static final boolean DEBUG = false;
    private static final String TAG = AbstractBuiltInCamera.class.getSimpleName();
    @NonNull
    private final WeakReference<Context> mWeakContext;
    @NonNull
    protected final CameraConst.CameraInfo mInfo = new CameraConst.CameraInfo();
    @NonNull
    protected final List<Size> mSupportedResolutions = new ArrayList<Size>();
    protected float currentMinFps = 1.0f;
    protected float currentMaxFps = 31.0f;
    @Nullable
    private IRendererHolder mRendererHolder;
    private boolean mExternalRendererHolder;
    @Nullable
    private SurfaceTexture mPreviewSurfaceTexture;
    @Nullable
    private T mCamera;
    private int preview_surface_id = 0;
    protected long mControlSupports;
    protected long mProcSupports;

    @SuppressLint(value={"NewApi"})
    public static AbstractBuiltInCamera<?> createInstance(@NonNull Context context, int id, boolean forceCameraV1) throws Exception {
        if (forceCameraV1 || !BuildCheck.isAndroid5()) {
            return new BuiltInCamera(context, id);
        }
        return new BuiltInCamera2(context, id);
    }

    @Deprecated
    public static int getScreenRotation(@NonNull Context context) {
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        int rotation = display.getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        return degrees;
    }

    protected AbstractBuiltInCamera(@NonNull Context context, int face) {
        this.mWeakContext = new WeakReference<Context>(context);
        this.mInfo.set(face);
        this.mRendererHolder = null;
        this.mInfo.width = 640;
        this.mInfo.height = 480;
    }

    @NonNull
    protected Context requireContext() throws IllegalStateException {
        Context result = (Context)this.mWeakContext.get();
        if (result == null) {
            throw new IllegalStateException();
        }
        return result;
    }

    @Override
    public void release() {
        this.disconnect();
        this.internalRelease();
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.release();
    }

    public void connect() throws Exception {
        if (!this.isStreaming()) {
            this.internalConnect();
        }
    }

    public void disconnect() {
        if (this.isStreaming()) {
            this.stopStream();
            this.internalDisconnect();
        }
    }

    @Override
    public boolean stopStream() {
        this.writeLock();
        try {
            this.setState(0, -1025);
            this.internalStopStream();
        }
        finally {
            this.writeUnlock();
        }
        return true;
    }

    @Override
    public String getDeviceKeyName() {
        return this.mInfo.id;
    }

    @Override
    public int getDeviceKey() {
        return this.getDeviceKeyName().hashCode();
    }

    @Override
    public boolean isConnected() {
        this.readLock();
        try {
            boolean bl = super.isConnected() && this.mCamera != null;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public boolean isStreaming() {
        this.readLock();
        try {
            boolean bl = super.isStreaming() && this.mCamera != null;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void setVideoSize(@Nullable Size sz) {
        this.setVideoSize(sz, 0.0f);
    }

    @Override
    public void setVideoSize(@Nullable Size sz, float bandwidthFactor) throws IllegalArgumentException {
        if (sz != null) {
            float maxFps = this.currentMaxFps;
            try {
                maxFps = sz.getCurrentFrameRate();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setVideoSize(sz.width, sz.height, this.currentMinFps, maxFps, bandwidthFactor);
        }
    }

    @Override
    @NonNull
    public String getSupportedSizeStringAll() throws IllegalStateException {
        return SizeUtils.toJsonString(this.mSupportedResolutions);
    }

    @Override
    @NonNull
    public List<Size> getSupportedSizeListAll() throws IllegalStateException {
        return this.mSupportedResolutions;
    }

    @Override
    @NonNull
    public String getSupportedSizeString() throws IllegalStateException {
        return this.getSupportedSizeStringAll();
    }

    @Override
    @NonNull
    public List<Size> getSupportedSizeList() throws IllegalStateException {
        return this.getSupportedSizeListAll();
    }

    @Override
    @Nullable
    public Size getCurrentVideoSize() {
        Size result = SizeUtils.findSize(this.getSupportedSizeStringAll(), RawFrameType.RAW_FRAME_INTERNAL_CAMERA, this.mInfo.width, this.mInfo.height);
        if (result == null) {
            result = new Size(RawFrameType.RAW_FRAME_INTERNAL_CAMERA, 0, this.mInfo.width, this.mInfo.height, new int[]{333333});
        }
        return result;
    }

    @Override
    public double getAspectRatio() {
        double video_height;
        double video_width;
        Size sz = this.getCurrentVideoSize();
        int rotation = this.getRotation();
        if (rotation % 180 == 0) {
            video_width = sz != null ? (double)sz.width : 640.0;
            video_height = sz != null ? (double)sz.height : 480.0;
        } else {
            video_width = sz != null ? (double)sz.height : 480.0;
            video_height = sz != null ? (double)sz.width : 640.0;
        }
        return video_width / video_height;
    }

    protected void resize(int width, int height) {
        int video_height;
        int video_width;
        int rotation = this.getRotation();
        if (rotation % 180 == 0) {
            video_width = width;
            video_height = height;
        } else {
            video_width = height;
            video_height = width;
        }
        if (this.mRendererHolder != null) {
            this.mRendererHolder.resize(video_width, video_height);
        }
        if (this.mPreviewSurfaceTexture != null) {
            this.mPreviewSurfaceTexture.setDefaultBufferSize(video_width, video_height);
        }
    }

    protected T getCamera() {
        this.readLock();
        try {
            T t = this.mCamera;
            return t;
        }
        finally {
            this.readUnlock();
        }
    }

    protected T swap(T camera) {
        T c;
        this.writeLock();
        try {
            c = this.mCamera;
            this.mCamera = camera;
        }
        finally {
            this.writeUnlock();
        }
        return c;
    }

    protected final void internalConnect() throws Exception {
        this.writeLock();
        try {
            this.setState(256, -257);
            this.internalOpenCamera();
            this.updateCameraParamsLocked();
            this.setState(512, -513);
        }
        finally {
            this.setState(0, -257);
            this.writeUnlock();
        }
        this.updateCurrentSize();
        this.internalUpdateRotation();
    }

    protected abstract void internalOpenCamera() throws Exception;

    protected abstract void internalReOpen();

    protected abstract void internalStopStream();

    protected abstract boolean internalDisconnect();

    @Nullable
    protected abstract Size getVideoSizeSetting();

    protected void internalRelease() {
        this.clearCameraParams();
        this.releaseRendererHolder();
        this.mPreviewSurfaceTexture = null;
    }

    protected abstract void updateCurrentSize();

    public abstract void toggleFacing();

    public abstract int getRotation();

    public abstract void updateRotation();

    protected void internalUpdateRotation() {
        Size sz = this.getCurrentVideoSize();
        int video_width = sz != null ? sz.width : 640;
        int video_height = sz != null ? sz.height : 480;
        this.resize(video_width, video_height);
    }

    protected void releaseRendererHolder() {
        if (!this.mExternalRendererHolder && this.mRendererHolder != null) {
            this.mRendererHolder.release();
            this.mExternalRendererHolder = false;
        }
        this.mRendererHolder = null;
    }

    @NonNull
    protected IRendererHolder createRendererHolder() {
        this.mExternalRendererHolder = false;
        return new RendererHolder(this.mInfo.width, this.mInfo.height, null);
    }

    @Nullable
    public IRendererHolder getRendererHolder() {
        return this.mRendererHolder;
    }

    public void setRendererHolder(@Nullable IRendererHolder rendererHolder) {
        boolean b;
        boolean bl = b = rendererHolder != null;
        if (b) {
            this.releaseRendererHolder();
        }
        this.mRendererHolder = rendererHolder;
        this.mExternalRendererHolder = b;
        if (b) {
            this.mPreviewSurfaceTexture = null;
        }
    }

    public void setPreviewSurfaceTexture(@Nullable SurfaceTexture surfaceTexture) {
        this.mPreviewSurfaceTexture = surfaceTexture;
        if (surfaceTexture != null) {
            this.releaseRendererHolder();
        }
    }

    @NonNull
    protected SurfaceTexture getInputSurfaceTexture() {
        if (this.mPreviewSurfaceTexture != null) {
            return this.mPreviewSurfaceTexture;
        }
        if (this.mRendererHolder == null) {
            this.mRendererHolder = this.createRendererHolder();
        }
        return this.mRendererHolder.getSurfaceTexture();
    }

    public void setPreviewSurface(@Nullable SurfaceHolder holder) {
        Surface surface = holder != null ? holder.getSurface() : null;
        this.setPreviewSurface(surface);
    }

    public void setPreviewSurface(@Nullable SurfaceTexture texture) {
        Surface surface = texture != null ? new Surface(texture) : null;
        this.setPreviewSurface(surface);
    }

    public void setPreviewSurface(@Nullable Surface surface) {
        if (this.preview_surface_id != 0) {
            this.removeSurface(this.preview_surface_id);
            this.preview_surface_id = 0;
        }
        int n = this.preview_surface_id = surface != null ? surface.hashCode() : 0;
        if (this.mRendererHolder == null) {
            this.mRendererHolder = this.createRendererHolder();
        }
        this.addSurface(this.preview_surface_id, surface, false);
    }

    public void addSurface(int id, Object surface, boolean isRecordable) {
        if (this.mRendererHolder != null && id != 0 && surface != null) {
            this.mRendererHolder.addSurface(id, surface, isRecordable);
        }
    }

    public void removeSurface(int id) {
        if (this.preview_surface_id == id) {
            this.preview_surface_id = 0;
        }
        if (this.mRendererHolder != null) {
            this.mRendererHolder.removeSurface(id);
        }
    }

    @Override
    public void updateCameraParams() {
        this.writeLock();
        try {
            this.updateCameraParamsLocked();
        }
        finally {
            this.writeUnlock();
        }
    }

    protected void updateCameraParamsLocked() {
        this.mProcSupports = 0L;
        this.mControlSupports = 0L;
    }

    protected void clearCameraParams() {
        this.writeLock();
        try {
            this.mProcSupports = 0L;
            this.mControlSupports = 0L;
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public long getSupportedCtrl() {
        this.readLock();
        try {
            long l = this.mControlSupports;
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public long getSupportedProc() {
        this.readLock();
        try {
            long l = this.mProcSupports;
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkSupportFlag(long flag) {
        this.readLock();
        try {
            if (this.mProcSupports == 0L && this.mControlSupports == 0L) {
                this.updateCameraParamsLocked();
            }
            long _flag = flag;
            if (flag == 0x1000800L || flag == 0x2000800L || flag == 0x1001000L || flag == 0x2001000L) {
                _flag &= 0xFFFFFFL;
            }
            if ((flag & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                boolean bl = (this.mProcSupports & (_flag &= Integer.MAX_VALUE)) == _flag;
                return bl;
            }
            boolean bl = (this.mControlSupports & _flag) == _flag;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public boolean resetScanningMode() {
        return this.setScanningMode(this.getScanningModeDef());
    }

    @Override
    public int resetExposureMode() {
        return this.setExposureMode(this.getExposureModeDef());
    }

    @Override
    public int resetExposurePriority() {
        return this.setExposurePriority(this.getExposurePriorityDef());
    }

    @Override
    public int resetExposure() {
        return this.setExposure(this.getExposureDef());
    }

    @Override
    public int resetExposureRel() {
        return this.setExposureRel(this.getExposureRelDef());
    }

    @Override
    public int resetFocus() {
        return this.setFocus(this.getFocusDef());
    }

    @Override
    public int resetFocusRel() {
        return this.setFocusRel(this.getFocusRelDef());
    }

    @Override
    public int resetIris() {
        return this.setIris(this.getIrisDef());
    }

    @Override
    public int resetIrisRel() {
        return this.setIrisRel(this.getIrisRelDef());
    }

    @Override
    public int resetPanTilt() {
        int def = this.getPanTiltDef();
        return this.setPanTilt((def & 0xFF0000) >>> 16, def & 0xFFFF);
    }

    @Override
    public int resetPan() {
        return this.setPan(this.getPanDef());
    }

    @Override
    public int resetPanRel() {
        int def = this.getPanRelDef();
        return this.setPanRel((def & 0xFF0000) >>> 16, def & 0xFFFF);
    }

    @Override
    public int resetTilt() {
        return this.setTilt(this.getTiltDef());
    }

    @Override
    public int resetTiltRel() {
        int def = this.getTiltRel();
        return this.setTiltRel((def & 0xFF0000) >>> 16, def & 0xFFFF);
    }

    @Override
    public int resetRoll() {
        return this.setRoll(this.getRollDef());
    }

    @Override
    public int resetRollRel() {
        int def = this.getRollRel();
        return this.setRollRel((def & 0xFF0000) >>> 16, def & 0xFFFF);
    }

    @Override
    public boolean resetPrivacy() {
        return this.setPrivacy(this.getPrivacyDef());
    }

    @Override
    public boolean resetAutoWhiteBlance() {
        return this.setAutoWhiteBlance(this.getAutoWhiteBlanceDef());
    }

    @Override
    public int resetWhiteBlance() {
        return this.setWhiteBlance(this.getWhiteBlanceDef());
    }

    @Override
    public boolean resetAutoWhiteBlanceCompo() {
        return this.setAutoWhiteBlanceCompo(this.getAutoWhiteBlanceCompoDef());
    }

    @Override
    public int resetWhiteBlanceCompo() {
        return this.setWhiteBlanceCompo(this.getWhiteBlanceCompoDef());
    }

    @Override
    public int resetBacklightComp() {
        return this.setBacklightComp(this.getBacklightCompDef());
    }

    @Override
    public int resetBrightness() {
        return this.setBrightness(this.getBrightnessDef());
    }

    @Override
    public int resetContrast() {
        return this.setContrast(this.getContrastDef());
    }

    @Override
    public boolean resetAutoContrast() {
        return this.setAutoContrast(this.getAutoContrastDef());
    }

    @Override
    public int resetSharpness() {
        return this.setSharpness(this.getSharpnessDef());
    }

    @Override
    public int resetGain() {
        return this.setGain(this.getGainDef());
    }

    @Override
    public int resetGamma() {
        return this.setGamma(this.getGammaDef());
    }

    @Override
    public int resetSaturation() {
        return this.setSaturation(this.getSaturationDef());
    }

    @Override
    public int resetHue() {
        return this.setHue(this.getHueDef());
    }

    @Override
    public boolean resetAutoHue() {
        return this.setAutoHue(this.getAutoHueDef());
    }

    @Override
    public int resetPowerlineFrequency() {
        return this.setPowerlineFrequency(this.getPowerlineFrequencyDef());
    }

    @Override
    public int resetZoom() {
        return this.setZoom(this.getZoomDef());
    }

    @Override
    public int resetZoomRel() {
        int def;
        return this.setZoomRel((def & 0xFF0000) >>> 16, ((def = this.getZoomRelDef()) & 0xFFFF) != 0);
    }

    @Override
    public int resetDigitalMultiplier() {
        return this.setDigitalMultiplier(this.getDigitalMultiplierDef());
    }

    @Override
    public int resetDigitalMultiplierLimit() {
        return this.setDigitalMultiplierLimit(this.getDigitalMultiplierLimitDef());
    }

    @Override
    public int resetAnalogVideoStandard() {
        return this.setAnalogVideoStandard(this.getAnalogVideoStandardDef());
    }

    @Override
    public boolean resetAnalogVideoLockState() {
        return this.setAnalogVideoLockState(this.getAnalogVideoLockStateDef());
    }

    @Override
    public boolean resetAutoFocus() {
        return this.setAutoFocus(this.getAutoFocusDef());
    }

    @Override
    public boolean setScanningMode(boolean b) {
        return false;
    }

    @Override
    public boolean getScanningMode() {
        return false;
    }

    @Override
    public boolean getScanningModeDef() {
        return false;
    }

    @Override
    public FuncMaxMinDef getScanningModeInfo() {
        return null;
    }

    @Override
    public int setExposureMode(int i) {
        return 0;
    }

    @Override
    public int getExposureMode() {
        return 0;
    }

    @Override
    public int getExposureModeDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getExposureModeInfo() {
        return null;
    }

    @Override
    public boolean setAutoFocus(boolean b) {
        return false;
    }

    @Override
    public boolean getAutoFocus() {
        return false;
    }

    @Override
    public boolean getAutoFocusDef() {
        return false;
    }

    @Override
    public FuncMaxMinDef getAutoFocusInfo() {
        return null;
    }

    @Override
    public int setFocus(int i) {
        return 0;
    }

    @Override
    public int getFocus() {
        return 0;
    }

    @Override
    public int getFocusDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getFocusInfo() {
        return null;
    }

    @Override
    public int setFocusRel(int i) {
        return 0;
    }

    @Override
    public int getFocusRel() {
        return 0;
    }

    @Override
    public int getFocusRelDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getFocusRelInfo() {
        return null;
    }

    @Override
    public int setIris(int i) {
        return 0;
    }

    @Override
    public int getIris() {
        return 0;
    }

    @Override
    public int getIrisDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getIrisInfo() {
        return null;
    }

    @Override
    public int setIrisRel(int i) {
        return 0;
    }

    @Override
    public int getIrisRel() {
        return 0;
    }

    @Override
    public int getIrisRelDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getIrisRelInfo() {
        return null;
    }

    @Override
    public int setPanTilt(int i, int i1) {
        return 0;
    }

    @Override
    public int getPanTilt() {
        return 0;
    }

    @Override
    public int getPanTiltDef() {
        return 0;
    }

    @Override
    public int setPan(int i) {
        return 0;
    }

    @Override
    public int getPan() {
        return 0;
    }

    @Override
    public int getPanDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getPanInfo() {
        return null;
    }

    @Override
    public int setPanRel(int i, int i1) {
        return 0;
    }

    @Override
    public int getPanRel() {
        return 0;
    }

    @Override
    public int getPanRelDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getPanRelInfo() {
        return null;
    }

    @Override
    public int setTilt(int i) {
        return 0;
    }

    @Override
    public int getTilt() {
        return 0;
    }

    @Override
    public int getTiltDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getTiltInfo() {
        return null;
    }

    @Override
    public int setTiltRel(int i, int i1) {
        return 0;
    }

    @Override
    public int getTiltRel() {
        return 0;
    }

    @Override
    public int getTiltRelDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getTiltRelInfo() {
        return null;
    }

    @Override
    public int setRoll(int i) {
        return 0;
    }

    @Override
    public int getRoll() {
        return 0;
    }

    @Override
    public int getRollDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getRollInfo() {
        return null;
    }

    @Override
    public int setRollRel(int i, int i1) {
        return 0;
    }

    @Override
    public int getRollRel() {
        return 0;
    }

    @Override
    public int getRollRelDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getRollRelInfo() {
        return null;
    }

    @Override
    public boolean setPrivacy(boolean b) {
        return false;
    }

    @Override
    public boolean getPrivacy() {
        return false;
    }

    @Override
    public boolean getPrivacyDef() {
        return false;
    }

    @Override
    public FuncMaxMinDef getPrivacyInfo() {
        return null;
    }

    @Override
    public boolean setAutoWhiteBlance(boolean b) {
        return false;
    }

    @Override
    public boolean getAutoWhiteBlance() {
        return false;
    }

    @Override
    public boolean getAutoWhiteBlanceDef() {
        return false;
    }

    @Override
    public FuncMaxMinDef getAutoWhiteBlanceInfo() {
        return null;
    }

    @Override
    public int setWhiteBlance(int i) {
        return 0;
    }

    @Override
    public int getWhiteBlance() {
        return 0;
    }

    @Override
    public int getWhiteBlanceDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getWhiteBlanceInfo() {
        return null;
    }

    @Override
    public boolean setAutoWhiteBlanceCompo(boolean b) {
        return false;
    }

    @Override
    public boolean getAutoWhiteBlanceCompo() {
        return false;
    }

    @Override
    public boolean getAutoWhiteBlanceCompoDef() {
        return false;
    }

    @Override
    public FuncMaxMinDef getAutoWhiteBlanceCompoInfo() {
        return null;
    }

    @Override
    public int setWhiteBlanceCompo(int i) {
        return 0;
    }

    @Override
    public int getWhiteBlanceCompo() {
        return 0;
    }

    @Override
    public int getWhiteBlanceCompoDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getWhiteBlanceCompoInfo() {
        return null;
    }

    @Override
    public int setBacklightComp(int i) {
        return 0;
    }

    @Override
    public int getBacklightComp() {
        return 0;
    }

    @Override
    public int getBacklightCompDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getBacklightCompInfo() {
        return null;
    }

    @Override
    public boolean setAutoContrast(boolean b) {
        return false;
    }

    @Override
    public boolean getAutoContrast() {
        return false;
    }

    @Override
    public boolean getAutoContrastDef() {
        return false;
    }

    @Override
    public FuncMaxMinDef getAutoContrastInfo() {
        return null;
    }

    @Override
    public int setGain(int i) {
        return 0;
    }

    @Override
    public int getGain() {
        return 0;
    }

    @Override
    public int getGainDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getGainInfo() {
        return null;
    }

    @Override
    public int setGamma(int i) {
        return 0;
    }

    @Override
    public int getGamma() {
        return 0;
    }

    @Override
    public int getGammaDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getGammaInfo() {
        return null;
    }

    @Override
    public int setHue(int i) {
        return 0;
    }

    @Override
    public int getHue() {
        return 0;
    }

    @Override
    public int getHueDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getHueInfo() {
        return null;
    }

    @Override
    public boolean setAutoHue(boolean b) {
        return false;
    }

    @Override
    public boolean getAutoHue() {
        return false;
    }

    @Override
    public boolean getAutoHueDef() {
        return false;
    }

    @Override
    public FuncMaxMinDef getAutoHueInfo() {
        return null;
    }

    @Override
    public int setPowerlineFrequency(int i) {
        return 0;
    }

    @Override
    public int getPowerlineFrequency() {
        return 0;
    }

    @Override
    public int getPowerlineFrequencyDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getPowerlineFrequencyInfo() {
        return null;
    }

    @Override
    public int setZoom(int i) {
        return 0;
    }

    @Override
    public int getZoom() {
        return 0;
    }

    @Override
    public int getZoomDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getZoomInfo() {
        return null;
    }

    @Override
    public int setZoomRel(int i, boolean b) {
        return 0;
    }

    @Override
    public int getZoomRel() {
        return 0;
    }

    @Override
    public int getZoomRelDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getZoomRelInfo() {
        return null;
    }

    @Override
    public int setDigitalMultiplier(int i) {
        return 0;
    }

    @Override
    public int getDigitalMultiplier() {
        return 0;
    }

    @Override
    public int getDigitalMultiplierDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getDigitalMultiplierInfo() {
        return null;
    }

    @Override
    public int setDigitalMultiplierLimit(int i) {
        return 0;
    }

    @Override
    public int getDigitalMultiplierLimit() {
        return 0;
    }

    @Override
    public int getDigitalMultiplierLimitDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getDigitalMultiplierLimitInfo() {
        return null;
    }

    @Override
    public int setAnalogVideoStandard(int i) {
        return 0;
    }

    @Override
    public int getAnalogVideoStandard() {
        return 0;
    }

    @Override
    public int getAnalogVideoStandardDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getAnalogVideoStandardInfo() {
        return null;
    }

    @Override
    public boolean setAnalogVideoLockState(boolean b) {
        return false;
    }

    @Override
    public boolean getAnalogVideoLockState() {
        return false;
    }

    @Override
    public boolean getAnalogVideoLockStateDef() {
        return false;
    }

    @Override
    public FuncMaxMinDef getAnalogVideoLockStateInfo() {
        return null;
    }
}

