/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.adapter;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.adapter.URIAdapter;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.feature.weex.WeexInstanceMgr;

public class PlusUriAdapter
implements URIAdapter {
    @Override
    @NonNull
    public Uri rewrite(WXSDKInstance wxsdkInstance, String type, Uri uri) {
        if (TextUtils.isEmpty((CharSequence)wxsdkInstance.getBundleUrl()) || PdrUtil.isEmpty((Object)uri)) {
            return uri;
        }
        String basePath = wxsdkInstance.getBundleUrl();
        String srcPath = uri.toString();
        if (uri.isRelative()) {
            if (uri.getEncodedPath().length() == 0) {
                return Uri.parse((String)basePath);
            }
            IWebview webview = WeexInstanceMgr.self().findWebview(wxsdkInstance);
            if (webview != null) {
                byte mode = webview.obtainApp().obtainRunningAppMode();
                if (!srcPath.startsWith("/storage") && mode == 1) {
                    String url = webview.obtainApp().convert2AbsFullPath(basePath, srcPath);
                    if ("web".equals(type)) {
                        url = webview.obtainApp().convert2WebviewFullPath(basePath, srcPath);
                    }
                    if (url.startsWith("/storage/")) {
                        srcPath = webview.obtainApp().convert2WebviewFullPath(basePath, srcPath);
                    } else {
                        if (url.startsWith("/")) {
                            url = url.substring(1, url.length());
                        }
                        srcPath = type.equals("font") ? "local:///" + url : "asset:///" + url;
                    }
                } else {
                    srcPath = webview.obtainApp().convert2WebviewFullPath(basePath, srcPath);
                }
            } else {
                srcPath = this.standardizedURL(basePath, srcPath);
            }
            if (basePath.startsWith("/storage")) {
                srcPath = "file://" + srcPath;
            } else if (basePath.startsWith("storage")) {
                srcPath = "file:///" + srcPath;
            }
            return Uri.parse((String)srcPath);
        }
        return uri;
    }

    @Override
    @NonNull
    public Uri rewrite(String bundleURL, String type, Uri uri) {
        String srcPath = uri.toString();
        if (uri.isRelative()) {
            if (uri.getEncodedPath().length() == 0) {
                return Uri.parse((String)bundleURL);
            }
            srcPath = this.standardizedURL(bundleURL, srcPath);
            return Uri.parse((String)srcPath);
        }
        return uri;
    }

    private String standardizedURL(String basePath, String pPath) {
        boolean doAppendBasePath;
        if (pPath.startsWith("./")) {
            pPath = pPath.substring("./".length());
            int p = basePath.lastIndexOf(47);
            if (p >= 0) {
                return basePath.substring(0, p + 1) + pPath;
            }
        }
        String spaceStr = "../";
        int pos = pPath.indexOf(spaceStr);
        int basePos = basePath.lastIndexOf(47);
        boolean bl = doAppendBasePath = basePos > -1;
        if (doAppendBasePath) {
            basePath = basePath.substring(0, basePos);
            while (pos > -1) {
                pPath = pPath.substring(spaceStr.length());
                basePos = basePath.lastIndexOf(47);
                basePath = basePath.substring(0, basePos);
                pos = pPath.indexOf(spaceStr);
            }
            pPath = basePath + '/' + pPath;
        }
        return pPath;
    }
}

