/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.listview;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.list.WXListComponent;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.ui.view.listview.ExtendedLinearLayoutManager;
import com.taobao.weex.ui.view.listview.ExtendedStaggeredGridLayoutManager;
import com.taobao.weex.ui.view.refresh.wrapper.BounceRecyclerView;
import io.dcloud.common.ui.blur.AppEventForBlurManager;
import io.dcloud.feature.weex.extend.DCWXSlider;
import io.dcloud.weex.FlingHelper;

public class WXRecyclerView
extends RecyclerView
implements WXGestureObservable {
    public static final int TYPE_LINEAR_LAYOUT = 1;
    public static final int TYPE_GRID_LAYOUT = 2;
    public static final int TYPE_STAGGERED_GRID_LAYOUT = 3;
    private WXGesture mGesture;
    private boolean scrollable = true;
    private boolean hasTouch = false;
    private JSONObject NestInfo = null;
    public boolean isNestParent = false;
    private int mCurrentDy = 0;
    private String mInstanceId;
    private FlingHelper mFlingHelper;
    private Float lastY = Float.valueOf(0.0f);
    private int totalDy = 0;
    private int velocityY = 0;
    private float headerHeight = 0.0f;
    boolean isStartFling = false;
    RecyclerView.OnScrollListener mParentScrollListener;
    RecyclerView.OnScrollListener mChildScrollListener;

    public void setNestInfo(JSONObject nestInfo) {
        this.NestInfo = nestInfo;
        if (nestInfo != null) {
            this.isNestParent = nestInfo.getBooleanValue("isNestParent");
            this.mInstanceId = nestInfo.getString("instanceId");
            if (this.mFlingHelper == null) {
                this.mFlingHelper = new FlingHelper(this.getContext());
            }
            if (this.isNestParent) {
                this.setDescendantFocusability(131072);
                if (this.mParentScrollListener == null) {
                    this.headerHeight = nestInfo.getFloat("headerHeight").floatValue();
                    this.mParentScrollListener = new RecyclerView.OnScrollListener(){

                        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                            super.onScrollStateChanged(recyclerView, newState);
                            if (newState == 0) {
                                WXRecyclerView.this.mCurrentDy = 0;
                                WXRecyclerView.this.dispatchChildFling();
                            }
                        }

                        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                            super.onScrolled(recyclerView, dx, dy);
                            WXRecyclerView.this.mCurrentDy = dy;
                            if (WXRecyclerView.this.isStartFling) {
                                WXRecyclerView.this.totalDy = 0;
                                WXRecyclerView.this.isStartFling = false;
                            }
                            WXRecyclerView.this.totalDy += dy;
                        }
                    };
                    this.addOnScrollListener(this.mParentScrollListener);
                }
            } else if (this.mChildScrollListener == null) {
                this.mChildScrollListener = new RecyclerView.OnScrollListener(){

                    public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                        if (newState == 0) {
                            WXRecyclerView.this.mCurrentDy = 0;
                            WXRecyclerView.this.dispatchParentFling();
                        }
                        super.onScrollStateChanged(recyclerView, newState);
                    }

                    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                        super.onScrolled(recyclerView, dx, dy);
                        WXRecyclerView.this.mCurrentDy = dy;
                        if (WXRecyclerView.this.isStartFling) {
                            WXRecyclerView.this.totalDy = 0;
                            WXRecyclerView.this.isStartFling = false;
                        }
                        WXRecyclerView.this.totalDy += dy;
                    }
                };
                this.addOnScrollListener(this.mChildScrollListener);
            }
        }
    }

    public int getCurrentDy() {
        return this.mCurrentDy;
    }

    public void callBackNestParent(String ref, String instanceId, float headerHeight) {
        WXRecyclerView parent = this.getParentRecyclerView();
        if (parent != null) {
            JSONObject nestInfo = new JSONObject();
            nestInfo.put("isNestParent", (Object)true);
            nestInfo.put("instanceId", (Object)instanceId);
            nestInfo.put("nestChildRef", (Object)ref);
            nestInfo.put("headerHeight", (Object)Float.valueOf(headerHeight));
            parent.setNestInfo(nestInfo);
        }
    }

    public WXRecyclerView(Context context) {
        super(context);
    }

    public WXRecyclerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public void setScrollable(boolean scrollable) {
        this.scrollable = scrollable;
    }

    public void initView(Context context, int type, int orientation) {
        this.initView(context, type, 1, 32.0f, orientation);
    }

    @TargetApi(value=16)
    public void initView(Context context, int type, int columnCount, float columnGap, final int orientation) {
        if (type == 2) {
            this.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(context, columnCount, orientation, false){

                public boolean canScrollVertically() {
                    try {
                        return WXRecyclerView.this.canParentScrollVertically(orientation, super.canScrollVertically());
                    }
                    catch (Exception exception) {
                        return true;
                    }
                }

                public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
                    try {
                        super.onLayoutChildren(recycler, state);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } else if (type == 3) {
            this.setLayoutManager((RecyclerView.LayoutManager)new ExtendedStaggeredGridLayoutManager(columnCount, orientation){

                public boolean canScrollVertically() {
                    try {
                        return WXRecyclerView.this.canParentScrollVertically(orientation, super.canScrollVertically());
                    }
                    catch (Exception exception) {
                        return true;
                    }
                }

                public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
                    try {
                        super.onLayoutChildren(recycler, state);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } else if (type == 1) {
            this.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context, orientation, false){

                public boolean canScrollVertically() {
                    try {
                        return WXRecyclerView.this.canParentScrollVertically(orientation, super.canScrollVertically());
                    }
                    catch (Exception exception) {
                        return true;
                    }
                }

                public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
                    try {
                        super.onLayoutChildren(recycler, state);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private boolean canParentScrollVertically(int orientation, boolean defV) {
        try {
            if (orientation == 1 && orientation == 1 && this.NestInfo != null && this.isNestParent) {
                WXRecyclerView childRecyclerView = this.getChildRecylerView();
                if (childRecyclerView == null) {
                    return true;
                }
                Rect rect = new Rect();
                childRecyclerView.getLocalVisibleRect(rect);
                int childNoDisplayH = childRecyclerView.getHeight() - rect.bottom;
                return childNoDisplayH != 0 || childRecyclerView.isScrollTop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defV;
    }

    @Override
    public void registerGestureListener(@Nullable WXGesture wxGesture) {
        this.mGesture = wxGesture;
    }

    @Override
    public WXGesture getGestureListener() {
        return this.mGesture;
    }

    public boolean onTouchEvent(MotionEvent event) {
        View parent;
        if (!this.scrollable) {
            return true;
        }
        if (this.NestInfo != null && this.isNestParent) {
            int deltaY;
            WXRecyclerView childRecyclerView;
            if (this.lastY.floatValue() == 0.0f) {
                this.lastY = Float.valueOf(event.getY());
            }
            if (this.isScrollEnd() && (childRecyclerView = this.getChildRecylerView()) != null && (deltaY = (int)(this.lastY.floatValue() - event.getY())) != 0) {
                childRecyclerView.scrollBy(0, deltaY);
            }
            this.lastY = Float.valueOf(event.getY());
        }
        if (event.getAction() == 1 && (parent = (View)this.getParent().getParent()) != null && parent.hasOnClickListeners() && parent instanceof BounceRecyclerView && this.pointInView(event.getX(), event.getY(), 0.0f) && this.getScrollState() == 0) {
            parent.performClick();
        }
        return super.onTouchEvent(event);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        this.hasTouch = true;
        if (this.NestInfo != null) {
            if (this.isNestParent) {
                if (event != null && event.getAction() == 0) {
                    this.velocityY = 0;
                    this.stopScroll();
                }
                if (event != null && event.getAction() != 2) {
                    this.lastY = Float.valueOf(0.0f);
                }
            } else if (event != null && event.getAction() == 0) {
                this.velocityY = 0;
            }
        }
        boolean result = super.dispatchTouchEvent(event);
        if (this.mGesture != null) {
            result |= this.mGesture.onTouch((View)this, event);
        }
        return result;
    }

    public boolean onInterceptTouchEvent(MotionEvent e) {
        return super.onInterceptTouchEvent(e);
    }

    public void scrollTo(boolean smooth, int position, final int offset, final int orientation) {
        try {
            RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
            this.stopScroll();
            if (!smooth) {
                if (layoutManager instanceof LinearLayoutManager) {
                    ((LinearLayoutManager)layoutManager).scrollToPositionWithOffset(position, -offset);
                } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                    ((StaggeredGridLayoutManager)layoutManager).scrollToPositionWithOffset(position, -offset);
                }
            } else {
                if (orientation == 1) {
                    if (layoutManager instanceof LinearLayoutManager) {
                        int firstPosition = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
                        int lastPostition = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
                        if (position >= firstPosition && position <= lastPostition) {
                            int top = this.getChildAt(position - firstPosition).getTop() + offset;
                            this.smoothScrollBy(0, top);
                            return;
                        }
                    } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                        int[] firstPosition = ((StaggeredGridLayoutManager)layoutManager).findFirstVisibleItemPositions(null);
                        int[] lastPostition = ((StaggeredGridLayoutManager)layoutManager).findLastCompletelyVisibleItemPositions(null);
                        if (position >= firstPosition[0] && position <= lastPostition[0]) {
                            int top = this.getChildAt(position - firstPosition[0]).getTop() + offset;
                            this.smoothScrollBy(0, top);
                            return;
                        }
                    }
                }
                this.smoothScrollToPosition(position);
                if (offset != 0) {
                    this.setOnSmoothScrollEndListener(new ExtendedLinearLayoutManager.OnSmoothScrollEndListener(){

                        @Override
                        public void onStop() {
                            WXRecyclerView.this.post(WXThread.secure(new Runnable(){

                                @Override
                                public void run() {
                                    if (orientation == 1) {
                                        WXRecyclerView.this.smoothScrollBy(0, offset);
                                    } else {
                                        WXRecyclerView.this.smoothScrollBy(offset, 0);
                                    }
                                }
                            }));
                        }
                    });
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void scrollTo(final int x, final int y, final int orientation) {
        this.postDelayed(WXThread.secure(new Runnable(){

            @Override
            public void run() {
                RecyclerView.LayoutManager layoutManager = WXRecyclerView.this.getLayoutManager();
                int offset = 0;
                offset = orientation == 1 ? y : x;
                if (layoutManager instanceof LinearLayoutManager) {
                    ((LinearLayoutManager)layoutManager).scrollToPositionWithOffset(0, -offset);
                } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                    ((StaggeredGridLayoutManager)layoutManager).scrollToPositionWithOffset(0, -offset);
                }
            }
        }), 100L);
    }

    public void setOnSmoothScrollEndListener(final ExtendedLinearLayoutManager.OnSmoothScrollEndListener onSmoothScrollEndListener) {
        this.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                if (newState == 0) {
                    recyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this);
                    if (onSmoothScrollEndListener != null) {
                        onSmoothScrollEndListener.onStop();
                    }
                }
            }
        });
    }

    private WXRecyclerView getParentRecyclerView() {
        if (this.NestInfo != null && !this.isNestParent) {
            WXListComponent listComponent;
            String id2 = this.NestInfo.getString("listParentId");
            WXComponent component = WXSDKManager.getInstance().getWXRenderManager().getWXComponentById(this.mInstanceId, id2);
            if (component != null && (listComponent = this.getListComponent(component)) != null && listComponent.getHostView() != null) {
                WXRecyclerView list = (WXRecyclerView)((BounceRecyclerView)listComponent.getHostView()).getInnerView();
                return list;
            }
        }
        return null;
    }

    private WXRecyclerView getChildRecylerView() {
        if (this.NestInfo != null && this.isNestParent) {
            WXListComponent listComponent;
            WXComponent component = null;
            if (this.NestInfo.getBooleanValue("isSwipelist")) {
                String swipeId = this.NestInfo.getString("swipeId");
                component = WXSDKManager.getInstance().getWXRenderManager().getWXComponentById(this.mInstanceId, swipeId);
                if (component != null && (component = this.getDCWXSliderComponent(component)) != null && component instanceof DCWXSlider) {
                    int index = ((DCWXSlider)component).getCurrentIndex();
                    component = ((DCWXSlider)component).getChild(index);
                }
            } else {
                String ref = this.NestInfo.getString("nestChildRef");
                component = WXSDKManager.getInstance().getWXRenderManager().getWXComponent(this.mInstanceId, ref);
            }
            if (component != null && (listComponent = this.getListComponent(component)) != null && listComponent.getHostView() != null) {
                WXRecyclerView list = (WXRecyclerView)((BounceRecyclerView)listComponent.getHostView()).getInnerView();
                return list;
            }
        }
        return null;
    }

    public WXListComponent getListComponent(WXComponent component) {
        WXVContainer container;
        if (component instanceof WXListComponent) {
            return (WXListComponent)component;
        }
        if (component instanceof WXVContainer && (container = (WXVContainer)component).getChildCount() > 0) {
            for (int i = 0; i < container.getChildCount(); ++i) {
                WXListComponent listComponent = this.getListComponent(container.getChild(i));
                if (listComponent == null) continue;
                return listComponent;
            }
        }
        return null;
    }

    public DCWXSlider getDCWXSliderComponent(WXComponent component) {
        WXVContainer container;
        if (component instanceof DCWXSlider) {
            return (DCWXSlider)component;
        }
        if (component instanceof WXVContainer && (container = (WXVContainer)component).getChildCount() > 0) {
            for (int i = 0; i < container.getChildCount(); ++i) {
                DCWXSlider ve = this.getDCWXSliderComponent(container.getChild(i));
                if (ve == null) continue;
                return ve;
            }
        }
        return null;
    }

    public boolean fling(int velX, int velY) {
        if (!this.isAttachedToWindow()) {
            return false;
        }
        boolean fling = super.fling(velX, velY);
        if (this.NestInfo != null) {
            if (this.isNestParent) {
                if (!fling || velY <= 0) {
                    this.velocityY = 0;
                } else {
                    this.isStartFling = true;
                    this.velocityY = velY;
                }
            } else if (!fling || velY >= 0) {
                this.velocityY = 0;
            } else {
                this.isStartFling = true;
                this.velocityY = velY;
            }
        }
        return fling;
    }

    public boolean isNestScroll() {
        return this.NestInfo != null;
    }

    public boolean isScrollTop() {
        return !this.canScrollVertically(-1);
    }

    private boolean isScrollEnd() {
        return !this.canScrollVertically(1);
    }

    private void dispatchChildFling() {
        double splineFlingDistance;
        if (this.isScrollEnd() && this.velocityY != 0 && (splineFlingDistance = this.mFlingHelper.getSplineFlingDistance(this.velocityY)) > (double)this.totalDy) {
            this.childFling(this.mFlingHelper.getVelocityByDistance(splineFlingDistance - (double)this.totalDy));
        }
        this.totalDy = 0;
        this.velocityY = 0;
    }

    private void dispatchParentFling() {
        WXRecyclerView parentRecyclerView = this.getParentRecyclerView();
        if (parentRecyclerView != null && this.isScrollTop() && this.velocityY != 0) {
            double flingDistance = this.mFlingHelper.getSplineFlingDistance(this.velocityY);
            if (flingDistance > (double)Math.abs(this.totalDy)) {
                parentRecyclerView.fling(0, -this.mFlingHelper.getVelocityByDistance(flingDistance + (double)this.totalDy));
            }
            this.totalDy = 0;
            this.velocityY = 0;
        }
    }

    private void childFling(int velY) {
        WXRecyclerView childRecyclerView = this.getChildRecylerView();
        if (childRecyclerView != null) {
            childRecyclerView.fling(0, velY);
        }
    }

    public void scrollToPosition(final int position) {
        if (this.isNestParent && this.NestInfo != null) {
            WXRecyclerView childRecyclerView = this.getChildRecylerView();
            if (childRecyclerView != null) {
                childRecyclerView.scrollToPosition(position);
            }
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    WXRecyclerView.super.scrollToPosition(position);
                }
            }, 50L);
        } else {
            super.scrollToPosition(position);
        }
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        if (this.isNestParent && this.NestInfo != null && target != null && target instanceof WXRecyclerView && !((WXRecyclerView)target).isNestParent) {
            return true;
        }
        return super.onStartNestedScroll(child, target, nestedScrollAxes);
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        if (this.isNestParent && this.NestInfo != null) {
            boolean isChildCanNotScroll;
            WXRecyclerView childRecyclerView = this.getChildRecylerView();
            boolean isParentCanScroll = dy > 0 && !this.isScrollEnd();
            boolean bl = isChildCanNotScroll = dy < 0 && childRecyclerView != null && childRecyclerView.isScrollTop();
            if (isParentCanScroll || isChildCanNotScroll) {
                this.scrollBy(0, dy);
                consumed[1] = dy;
            }
        }
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        if (this.isNestParent && this.NestInfo != null) {
            return true;
        }
        return super.onNestedFling(target, velocityX, velocityY, consumed);
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        if (this.isNestParent && this.NestInfo != null) {
            boolean isChildCanNotFling;
            WXRecyclerView childRecyclerView = this.getChildRecylerView();
            boolean isParentCanFling = velocityY > 0.0f && !this.isScrollEnd();
            boolean bl = isChildCanNotFling = !(velocityY >= 0.0f) && childRecyclerView != null && childRecyclerView.isScrollTop();
            if (!isParentCanFling && !isChildCanNotFling) {
                return false;
            }
            this.fling(0, (int)velocityY);
            return true;
        }
        return super.onNestedPreFling(target, velocityX, velocityY);
    }

    public boolean pointInView(float localX, float localY, float slop) {
        return localX >= -slop && localY >= -slop && localX < (float)(this.getRight() - this.getLeft()) + slop && localY < (float)(this.getBottom() - this.getTop()) + slop;
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        AppEventForBlurManager.onScrollChanged((int)l, (int)t);
    }
}

