/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import java.nio.ByteBuffer;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;

public class Latin1Prober
extends CharsetProber {
    public static final byte UDF = 0;
    public static final byte OTH = 1;
    public static final byte ASC = 2;
    public static final byte ASS = 3;
    public static final byte ACV = 4;
    public static final byte ACO = 5;
    public static final byte ASV = 6;
    public static final byte ASO = 7;
    public static final int CLASS_NUM = 8;
    public static final int FREQ_CAT_NUM = 4;
    private static final byte[] latin1CharToClass = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 0, 1, 7, 1, 1, 1, 1, 1, 1, 5, 1, 5, 0, 5, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 1, 7, 0, 7, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 4, 4, 4, 4, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 4, 4, 4, 4, 4, 1, 4, 4, 4, 4, 4, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 6, 6, 6, 6, 6, 1, 6, 6, 6, 6, 6, 7, 7, 7};
    private static final byte[] latin1ClassModel = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 1, 1, 3, 3, 0, 3, 3, 3, 1, 2, 1, 2, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 1, 3, 1, 1, 1, 3, 0, 3, 1, 3, 1, 1, 3, 3};
    private CharsetProber.ProbingState state;
    private byte lastCharClass;
    private int[] freqCounter;

    public Latin1Prober() {
        Latin1Prober latin1Prober = this;
        latin1Prober.freqCounter = new int[4];
        latin1Prober.reset();
    }

    @Override
    public String getCharSetName() {
        return Constants.CHARSET_WINDOWS_1252;
    }

    @Override
    public float getConfidence() {
        float f2;
        int[] nArray;
        if (this.state == CharsetProber.ProbingState.NOT_ME) {
            return 0.01f;
        }
        int n2 = 0;
        int n3 = 0;
        while (true) {
            nArray = this.freqCounter;
            if (n3 >= this.freqCounter.length) break;
            n2 += nArray[n3];
            ++n3;
        }
        if (n2 <= 0) {
            f2 = 0.0f;
        } else {
            f2 = n2;
            f2 = (float)nArray[3] * 1.0f / f2 - (float)nArray[1] * 20.0f / f2;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        return f2 * 0.5f;
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    @Override
    public CharsetProber.ProbingState handleData(byte[] byArray, int n2, int n3) {
        ByteBuffer byteBuffer = this.filterWithEnglishLetters(byArray, n2, n3);
        byArray = byteBuffer.array();
        n2 = byteBuffer.position();
        for (n3 = 0; n3 < n2; ++n3) {
            byte by = latin1CharToClass[byArray[n3] & 0xFF];
            byte by2 = latin1ClassModel[this.lastCharClass * 8 + by];
            if (by2 == 0) {
                this.state = CharsetProber.ProbingState.NOT_ME;
                break;
            }
            this.freqCounter[by2] = this.freqCounter[by2] + 1;
            this.lastCharClass = by;
        }
        return this.state;
    }

    @Override
    public void reset() {
        Latin1Prober latin1Prober = this;
        latin1Prober.state = CharsetProber.ProbingState.DETECTING;
        latin1Prober.lastCharClass = 1;
        int n2 = 0;
        while (true) {
            int[] nArray = this.freqCounter;
            if (n2 >= this.freqCounter.length) break;
            nArray[n2] = 0;
            ++n2;
        }
    }

    @Override
    public void setOption() {
    }
}

