/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.util;

import net.lingala.zip4j.headers.VersionMadeBy;
import net.lingala.zip4j.headers.VersionNeededToExtract;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.CompressionMethod;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import net.lingala.zip4j.util.FileUtils;
import net.lingala.zip4j.util.RawIO;

public class ZipVersionUtils {
    public static int determineVersionMadeBy(ZipParameters zipParameters, RawIO rawIO) {
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray[0] = VersionMadeBy.SPECIFICATION_VERSION.getCode();
        byArray[1] = VersionMadeBy.UNIX.getCode();
        if (FileUtils.isWindows() && !zipParameters.isUnixMode()) {
            byArray2[1] = VersionMadeBy.WINDOWS.getCode();
        }
        return rawIO.readShortLittleEndian(byArray2, 0);
    }

    public static VersionNeededToExtract determineVersionNeededToExtract(ZipParameters zipParameters) {
        VersionNeededToExtract versionNeededToExtract = VersionNeededToExtract.DEFAULT;
        if (zipParameters.getCompressionMethod() == CompressionMethod.DEFLATE) {
            versionNeededToExtract = VersionNeededToExtract.DEFLATE_COMPRESSED;
        }
        if (zipParameters.getEntrySize() > 0xFFFFFFFFL) {
            versionNeededToExtract = VersionNeededToExtract.ZIP_64_FORMAT;
        }
        if (zipParameters.isEncryptFiles() && zipParameters.getEncryptionMethod().equals((Object)EncryptionMethod.AES)) {
            versionNeededToExtract = VersionNeededToExtract.AES_ENCRYPTED;
        }
        return versionNeededToExtract;
    }
}

