/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.inputstream.NumberedSplitInputStream;
import net.lingala.zip4j.io.inputstream.SplitInputStream;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import net.lingala.zip4j.io.inputstream.ZipStandardSplitInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.util.FileUtils;

public class UnzipUtil {
    public static ZipInputStream createZipInputStream(ZipModel object, FileHeader fileHeader, char[] cArray) throws IOException {
        block6: {
            ZipInputStream zipInputStream;
            ZipModel zipModel = object;
            object = null;
            try {
                object = UnzipUtil.createSplitInputStream(zipModel);
            }
            catch (IOException iOException) {
                if (object != null) {
                    ((SplitInputStream)object).close();
                }
                throw iOException;
            }
            ((SplitInputStream)object).prepareExtractionForFileHeader(fileHeader);
            ZipInputStream zipInputStream2 = zipInputStream;
            zipInputStream2((InputStream)object, cArray);
            if (zipInputStream.getNextEntry(fileHeader) == null) break block6;
            return zipInputStream2;
        }
        throw new ZipException("Could not locate local file header for corresponding file header");
    }

    public static void applyFileAttributes(FileHeader fileHeader, File file) {
        Path path = file.toPath();
        try {
            FileUtils.setFileAttributes(path, fileHeader.getExternalFileAttributes());
            FileUtils.setFileLastModifiedTime(path, fileHeader.getLastModifiedTime());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            FileUtils.setFileLastModifiedTimeWithoutNio(file, fileHeader.getLastModifiedTime());
        }
    }

    public static SplitInputStream createSplitInputStream(ZipModel zipModel) throws IOException {
        if (zipModel.getZipFile().getName().endsWith(".zip.001")) {
            return new NumberedSplitInputStream(zipModel.getZipFile(), true, zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk());
        }
        ZipModel zipModel2 = zipModel;
        File file = zipModel2.getZipFile();
        boolean bl = zipModel2.isSplitArchive();
        return new ZipStandardSplitInputStream(file, bl, zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk());
    }
}

