/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.util.Zip4jUtil;

public class RawIO {
    private final byte[] shortBuff = new byte[2];
    private final byte[] intBuff = new byte[4];
    private final byte[] longBuff = new byte[8];

    private void readFully(InputStream inputStream, byte[] byArray, int n2) throws IOException {
        if (Zip4jUtil.readFully(inputStream, byArray, 0, n2) == n2) {
            return;
        }
        throw new ZipException("Could not fill buffer");
    }

    private void resetBytes(byte[] byArray) {
        Arrays.fill(byArray, (byte)0);
    }

    public long readLongLittleEndian(RandomAccessFile randomAccessFile) throws IOException {
        RawIO rawIO = this;
        randomAccessFile.readFully(this.longBuff);
        return rawIO.readLongLittleEndian(rawIO.longBuff, 0);
    }

    public long readLongLittleEndian(RandomAccessFile randomAccessFile, int n2) throws IOException {
        RawIO rawIO = this;
        RawIO rawIO2 = this;
        rawIO2.resetBytes(rawIO2.longBuff);
        randomAccessFile.readFully(rawIO2.longBuff, 0, n2);
        return rawIO.readLongLittleEndian(rawIO.longBuff, 0);
    }

    public long readLongLittleEndian(InputStream inputStream) throws IOException {
        RawIO rawIO = object;
        Object object = ((RawIO)object).longBuff;
        rawIO.readFully(inputStream, (byte[])object, ((RawIO)object).longBuff.length);
        return rawIO.readLongLittleEndian(rawIO.longBuff, 0);
    }

    public long readLongLittleEndian(InputStream inputStream, int n2) throws IOException {
        RawIO rawIO = this;
        RawIO rawIO2 = this;
        rawIO2.resetBytes(rawIO2.longBuff);
        rawIO.readFully(inputStream, rawIO2.longBuff, n2);
        return rawIO.readLongLittleEndian(rawIO.longBuff, 0);
    }

    public long readLongLittleEndian(byte[] byArray, int n2) {
        if (byArray.length - n2 < 8) {
            RawIO rawIO = object;
            rawIO.resetBytes(rawIO.longBuff);
        }
        byte[] byArray2 = ((RawIO)object).longBuff;
        int n3 = 0;
        int n4 = byArray.length < 8 ? byArray.length - n2 : 8;
        System.arraycopy(byArray, n2, byArray2, n3, n4);
        Object object = ((RawIO)object).longBuff;
        return ((((((((long)(((RawIO)object).longBuff[7] & 0xFF) | 0L) << 8 | (long)(object[6] & 0xFF)) << 8 | (long)(object[5] & 0xFF)) << 8 | (long)(object[4] & 0xFF)) << 8 | (long)(object[3] & 0xFF)) << 8 | (long)(object[2] & 0xFF)) << 8 | (long)(object[1] & 0xFF)) << 8 | (long)(object[0] & 0xFF);
    }

    public int readIntLittleEndian(RandomAccessFile randomAccessFile) throws IOException {
        RawIO rawIO = this;
        randomAccessFile.readFully(this.intBuff);
        return rawIO.readIntLittleEndian(rawIO.intBuff);
    }

    public int readIntLittleEndian(InputStream inputStream) throws IOException {
        RawIO rawIO = this;
        rawIO.readFully(inputStream, this.intBuff, 4);
        return rawIO.readIntLittleEndian(rawIO.intBuff);
    }

    public int readIntLittleEndian(byte[] byArray) {
        return this.readIntLittleEndian(byArray, 0);
    }

    public int readIntLittleEndian(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF | (byArray[n2 + 3] & 0xFF) << 8) << 16;
    }

    public int readShortLittleEndian(RandomAccessFile randomAccessFile) throws IOException {
        RawIO rawIO = this;
        randomAccessFile.readFully(this.shortBuff);
        return rawIO.readShortLittleEndian(rawIO.shortBuff, 0);
    }

    public int readShortLittleEndian(InputStream inputStream) throws IOException {
        RawIO rawIO = object;
        Object object = ((RawIO)object).shortBuff;
        rawIO.readFully(inputStream, (byte[])object, ((RawIO)object).shortBuff.length);
        return rawIO.readShortLittleEndian(rawIO.shortBuff, 0);
    }

    public int readShortLittleEndian(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8;
    }

    public void writeShortLittleEndian(OutputStream outputStream, int n2) throws IOException {
        RawIO rawIO = this;
        rawIO.writeShortLittleEndian(rawIO.shortBuff, 0, n2);
        outputStream.write(rawIO.shortBuff);
    }

    public void writeShortLittleEndian(byte[] byArray, int n2, int n3) {
        int n4 = n2 + 1;
        byArray[n4] = (byte)(n3 >>> 8);
        byArray[n2] = (byte)(n3 & 0xFF);
    }

    public void writeIntLittleEndian(OutputStream outputStream, int n2) throws IOException {
        RawIO rawIO = this;
        rawIO.writeIntLittleEndian(rawIO.intBuff, 0, n2);
        outputStream.write(rawIO.intBuff);
    }

    public void writeIntLittleEndian(byte[] byArray, int n2, int n3) {
        int n4 = n2 + 3;
        byArray[n4] = (byte)(n3 >>> 24);
        n4 = n2 + 2;
        byArray[n4] = (byte)(n3 >>> 16);
        n4 = n2 + 1;
        byArray[n4] = (byte)(n3 >>> 8);
        byArray[n2] = (byte)(n3 & 0xFF);
    }

    public void writeLongLittleEndian(OutputStream outputStream, long l2) throws IOException {
        RawIO rawIO = this;
        rawIO.writeLongLittleEndian(rawIO.longBuff, 0, l2);
        outputStream.write(rawIO.longBuff);
    }

    public void writeLongLittleEndian(byte[] byArray, int n2, long l2) {
        int n3 = n2 + 7;
        byArray[n3] = (byte)(l2 >>> 56);
        n3 = n2 + 6;
        byArray[n3] = (byte)(l2 >>> 48);
        n3 = n2 + 5;
        byArray[n3] = (byte)(l2 >>> 40);
        n3 = n2 + 4;
        byArray[n3] = (byte)(l2 >>> 32);
        n3 = n2 + 3;
        byArray[n3] = (byte)(l2 >>> 24);
        n3 = n2 + 2;
        byArray[n3] = (byte)(l2 >>> 16);
        n3 = n2 + 1;
        byArray[n3] = (byte)(l2 >>> 8);
        byArray[n2] = (byte)(l2 & 0xFFL);
    }
}

