/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ExcludeFileFilter;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.util.BitUtils;
import net.lingala.zip4j.util.InternalZipConstants;
import net.lingala.zip4j.util.Zip4jUtil;

public class FileUtils {
    public static final byte[] DEFAULT_POSIX_FILE_ATTRIBUTES = new byte[]{0, 0, -92, -127};
    public static final byte[] DEFAULT_POSIX_FOLDER_ATTRIBUTES = new byte[]{0, 0, -19, 65};

    public static void setFileAttributes(Path path, byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            if (FileUtils.isWindows()) {
                FileUtils.applyWindowsFileAttributes(path, byArray);
            } else if (FileUtils.isMac() || FileUtils.isUnix()) {
                FileUtils.applyPosixFileAttributes(path, byArray);
            }
            return;
        }
    }

    public static void setFileLastModifiedTime(Path path, long l2) {
        block2: {
            if (l2 <= 0L || !Files.exists(path, new LinkOption[0])) break block2;
            try {
                Files.setLastModifiedTime(path, FileTime.fromMillis(Zip4jUtil.dosToExtendedEpochTme(l2)));
            }
            catch (Exception exception) {}
            return;
        }
    }

    public static void setFileLastModifiedTimeWithoutNio(File file, long l2) {
        file.setLastModified(Zip4jUtil.dosToExtendedEpochTme(l2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getFileAttributes(File comparable) {
        if (comparable == null) return new byte[4];
        try {
            if (!Files.isSymbolicLink(((File)comparable).toPath()) && !((File)comparable).exists()) {
                return new byte[4];
            }
            Path path = ((File)comparable).toPath();
            if (FileUtils.isWindows()) {
                return FileUtils.getWindowsFileAttributes(path);
            }
            if (FileUtils.isMac()) return FileUtils.getPosixFileAttributes(path);
            if (!FileUtils.isUnix()) return new byte[4];
            return FileUtils.getPosixFileAttributes(path);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return new byte[4];
        }
    }

    public static List<File> getFilesInDirectoryRecursive(File file, boolean bl, boolean bl2) throws ZipException {
        return FileUtils.getFilesInDirectoryRecursive(file, bl, bl2, null);
    }

    public static List<File> getFilesInDirectoryRecursive(File file, boolean bl, boolean bl2, ExcludeFileFilter excludeFileFilter) throws ZipException {
        if (file != null) {
            ArrayList<File> arrayList;
            File file2 = file;
            ArrayList<File> arrayList2 = arrayList;
            arrayList = new ArrayList<File>();
            File[] fileArray = file2.listFiles();
            if (file2.isDirectory() && file.canRead() && fileArray != null) {
                for (File file3 : fileArray) {
                    if (excludeFileFilter != null && excludeFileFilter.isExcluded(file3) || file3.isHidden() && (file3.isDirectory() ? !bl2 : !bl)) continue;
                    arrayList2.add(file3);
                    if (!file3.isDirectory()) continue;
                    arrayList2.addAll(FileUtils.getFilesInDirectoryRecursive(file3, bl, bl2, excludeFileFilter));
                }
                return arrayList2;
            }
            return arrayList2;
        }
        throw new ZipException("input path is null, cannot read files in the directory");
    }

    public static String getFileNameWithoutExtension(String string2) {
        int n2 = string2.lastIndexOf(".");
        if (n2 == -1) {
            return string2;
        }
        return string2.substring(0, n2);
    }

    public static String getZipFileNameWithoutExtension(String string2) throws ZipException {
        if (Zip4jUtil.isStringNotNullAndNotEmpty(string2)) {
            if (string2.contains(System.getProperty("file.separator"))) {
                String string3 = string2;
                string2 = string3.substring(string3.lastIndexOf(System.getProperty("file.separator")) + 1);
            }
            if (string2.endsWith(".zip")) {
                String string4 = string2;
                string2 = string4.substring(0, string4.lastIndexOf("."));
            }
            return string2;
        }
        throw new ZipException("zip file name is empty or null, cannot determine zip file name");
    }

    public static List<File> getSplitZipFiles(ZipModel zipModel) throws ZipException {
        if (zipModel != null) {
            if (zipModel.getEndOfCentralDirectoryRecord() == null) {
                return null;
            }
            if (zipModel.getZipFile().exists()) {
                ArrayList<File> arrayList;
                ZipModel zipModel2 = zipModel;
                ArrayList<File> arrayList2 = arrayList;
                arrayList = new ArrayList<File>();
                File file = zipModel2.getZipFile();
                if (!zipModel2.isSplitArchive()) {
                    ArrayList<File> arrayList3 = arrayList2;
                    arrayList3.add(file);
                    return arrayList3;
                }
                int n2 = zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk();
                if (n2 == 0) {
                    ArrayList<File> arrayList4 = arrayList2;
                    arrayList4.add(file);
                    return arrayList4;
                }
                for (int i2 = 0; i2 <= n2; ++i2) {
                    if (i2 == n2) {
                        arrayList2.add(zipModel.getZipFile());
                        continue;
                    }
                    String string2 = ".z0";
                    if (i2 >= 9) {
                        string2 = ".z";
                    }
                    String string3 = file.getName().contains(".") ? file.getPath().substring(0, file.getPath().lastIndexOf(".")) : file.getPath();
                    string2 = string3 + string2 + (i2 + 1);
                    arrayList2.add(new File(string2));
                }
                return arrayList2;
            }
            throw new ZipException("zip file does not exist");
        }
        throw new ZipException("cannot get split zip files: zipmodel is null");
    }

    /*
     * Unable to fully structure code
     */
    public static String getRelativeFileName(File var0, ZipParameters var1_2) throws ZipException {
        block37: {
            block32: {
                block36: {
                    block35: {
                        block34: {
                            block33: {
                                v0 = var1_2;
                                var2_3 = var0.getCanonicalPath();
                                if (!Zip4jUtil.isStringNotNullAndNotEmpty(v0.getDefaultFolderPath())) break block32;
                                var3_5 = new File(var1_2.getDefaultFolderPath()).getCanonicalPath();
                                var4_6 = InternalZipConstants.FILE_SEPARATOR;
                                if (var3_5.endsWith((String)var4_6)) break block33;
                                var3_5 = var3_5 + (String)var4_6;
                            }
                            if (!FileUtils.isSymbolicLink((File)var0)) break block34;
                            v1 = v2;
                            v3 = v2;
                            v1(var0.getParentFile().getCanonicalFile().getPath() + File.separator + var0.getCanonicalFile().getName());
                            v4 = v3.getPath().substring(var3_5.length());
lbl23:
                            // 2 sources

                            while (true) {
                                var3_5 = v4;
                                ** GOTO lbl30
                                break;
                            }
                        }
                        v4 = var2_3.substring(var3_5.length());
                        ** continue;
lbl30:
                        // 1 sources

                        if (!var3_5.startsWith(System.getProperty("file.separator"))) break block35;
                        var3_5 = var3_5.substring(1);
                    }
                    var4_6 = v5;
                    if (!new File(var2_3).isDirectory()) break block36;
                    var2_3 = var3_5.replaceAll("\\\\", "/");
                    v6 = var2_3 + "/";
lbl41:
                    // 3 sources

                    while (true) {
                        var2_3 = v6;
                        break block37;
                        break;
                    }
                }
                v7 = var3_5;
                var2_4 = 0;
                try {
                    var2_3 = v7.substring(var2_4, v7.lastIndexOf(var4_6.getName())).replaceAll("\\\\", "/");
                }
                catch (IOException var0_1) {
                    throw new ZipException(var0_1);
                }
                v6 = var2_3 + FileUtils.getNameOfFileInZip((File)var4_6, var1_2.getFileNameInZip());
                ** GOTO lbl41
            }
            v8 = new File(var2_3);
            var2_3 = FileUtils.getNameOfFileInZip(v8, var1_2.getFileNameInZip());
            if (!v8.isDirectory()) break block37;
            v6 = var2_3 + "/";
            ** continue;
        }
        var3_5 = var1_2.getRootFolderNameInZip();
        if (Zip4jUtil.isStringNotNullAndNotEmpty(var3_5)) {
            if (!var3_5.endsWith("\\") && !var3_5.endsWith("/")) {
                var3_5 = var3_5 + InternalZipConstants.FILE_SEPARATOR;
            }
            var3_5 = var3_5.replaceAll("\\\\", "/");
            var2_3 = var3_5 + var2_3;
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(var2_3)) {
            v9 = var0;
            var0 = "fileName to add to zip is empty or null. fileName: '" + var2_3 + "' DefaultFolderPath: '" + var1_2.getDefaultFolderPath() + "' FileNameInZip: " + var1_2.getFileNameInZip();
            if (FileUtils.isSymbolicLink(v9)) {
                var0 = (String)var0 + "isSymlink: true ";
            }
            if (Zip4jUtil.isStringNotNullAndNotEmpty(var3_5)) {
                var0 = "rootFolderNameInZip: '" + var3_5 + "' ";
            }
            throw new ZipException((String)var0);
        }
        return var2_3;
    }

    private static String getNameOfFileInZip(File file, String string2) throws IOException {
        if (Zip4jUtil.isStringNotNullAndNotEmpty(string2)) {
            return string2;
        }
        if (FileUtils.isSymbolicLink(file)) {
            return file.toPath().toRealPath(LinkOption.NOFOLLOW_LINKS).getFileName().toString();
        }
        return file.getName();
    }

    public static boolean isZipEntryDirectory(String string2) {
        return string2.endsWith("/") || string2.endsWith("\\");
    }

    /*
     * Exception decompiling
     */
    public static void copyFile(RandomAccessFile var0, OutputStream var1_2, long var2_3, long var4_4, ProgressMonitor var6_5, int var7_6) throws ZipException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 10[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void assertFilesExist(List<File> object, ZipParameters.SymbolicLinkAction symbolicLinkAction) throws ZipException {
        object = object.iterator();
        while (object.hasNext()) {
            File file = (File)object.next();
            if (FileUtils.isSymbolicLink(file)) {
                if (!symbolicLinkAction.equals((Object)ZipParameters.SymbolicLinkAction.INCLUDE_LINK_AND_LINKED_FILE) && !symbolicLinkAction.equals((Object)ZipParameters.SymbolicLinkAction.INCLUDE_LINKED_FILE_ONLY)) continue;
                FileUtils.assertSymbolicLinkTargetExists(file);
                continue;
            }
            FileUtils.assertFileExists(file);
        }
    }

    public static boolean isNumberedSplitFile(File file) {
        return file.getName().endsWith(".zip.001");
    }

    public static String getFileExtension(File object) {
        if (!((String)(object = ((File)object).getName())).contains(".")) {
            return "";
        }
        Object object2 = object;
        return ((String)object2).substring(((String)object2).lastIndexOf(".") + 1);
    }

    public static File[] getAllSortedNumberedSplitFiles(File objectArray) {
        File file = objectArray;
        objectArray = FileUtils.getFileNameWithoutExtension(file.getName());
        objectArray = file.getParentFile().listFiles((arg_0, arg_1) -> FileUtils.lambda$getAllSortedNumberedSplitFiles$0((String)objectArray, arg_0, arg_1));
        if (objectArray == null) {
            return new File[0];
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    public static String getNextNumberedSplitFileCounterAsExtension(int n2) {
        return "." + FileUtils.getExtensionZerosPrefix(n2) + (n2 + 1);
    }

    public static boolean isSymbolicLink(File file) {
        try {
            return Files.isSymbolicLink(file.toPath());
        }
        catch (Error error) {
        }
        catch (Exception exception) {}
        return false;
    }

    public static String readSymbolicLink(File file) {
        try {
            return Files.readSymbolicLink(file.toPath()).toString();
        }
        catch (Error error) {
        }
        catch (Exception exception) {}
        return "";
    }

    public static byte[] getDefaultFileAttributes(boolean bl) {
        int n2 = 4;
        byte[] byArray = new byte[4];
        if (!FileUtils.isUnix() && !FileUtils.isMac()) {
            if (FileUtils.isWindows() && bl) {
                byArray[0] = BitUtils.setBit(byArray[0], 4);
            }
        } else if (bl) {
            System.arraycopy(DEFAULT_POSIX_FOLDER_ATTRIBUTES, 0, byArray, 0, n2);
        } else {
            System.arraycopy(DEFAULT_POSIX_FILE_ATTRIBUTES, 0, byArray, 0, n2);
        }
        return byArray;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    public static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().contains("mac");
    }

    public static boolean isUnix() {
        return System.getProperty("os.name").toLowerCase().contains("nux");
    }

    private static String getExtensionZerosPrefix(int n2) {
        if (n2 < 9) {
            return "00";
        }
        if (n2 < 99) {
            return "0";
        }
        return "";
    }

    private static void applyWindowsFileAttributes(Path object, byte[] byArray) {
        if (byArray[0] == 0) {
            return;
        }
        LinkOption[] linkOptionArray = object;
        LinkOption[] linkOptionArray2 = new LinkOption[1];
        object = linkOptionArray2;
        linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        object = Files.getFileAttributeView((Path)linkOptionArray, DosFileAttributeView.class, (LinkOption[])object);
        try {
            object.setReadOnly(BitUtils.isBitSet(byArray[0], 0));
            object.setHidden(BitUtils.isBitSet(byArray[0], 1));
            object.setSystem(BitUtils.isBitSet(byArray[0], 2));
            object.setArchive(BitUtils.isBitSet(byArray[0], 5));
        }
        catch (IOException iOException) {}
    }

    private static void applyPosixFileAttributes(Path iterable, byte[] byArray) {
        HashSet hashSet;
        byte[] byArray2;
        byte[] byArray3;
        byte[] byArray4;
        byte[] byArray5;
        byte[] byArray6;
        byte[] byArray7;
        byte[] byArray8;
        byte[] byArray9;
        byte[] byArray10;
        Path path;
        if (byArray[2] == 0 && byArray[3] == 0) {
            return;
        }
        try {
            path = iterable;
            byArray10 = byArray;
            byArray9 = byArray;
            byArray8 = byArray;
            byArray7 = byArray;
            byArray6 = byArray;
            byArray5 = byArray;
            byArray4 = byArray;
            byArray3 = byArray;
            byArray2 = byArray;
        }
        catch (IOException iOException) {}
        iterable = hashSet;
        hashSet = new HashSet();
        byte by = byArray5[3];
        FileUtils.addIfBitSet(by, 0, (Set<PosixFilePermission>)iterable, PosixFilePermission.OWNER_READ);
        byte by2 = byArray4[2];
        FileUtils.addIfBitSet(by2, 7, (Set<PosixFilePermission>)iterable, PosixFilePermission.OWNER_WRITE);
        byte by3 = byArray3[2];
        FileUtils.addIfBitSet(by3, 6, (Set<PosixFilePermission>)iterable, PosixFilePermission.OWNER_EXECUTE);
        byte by4 = byArray2[2];
        FileUtils.addIfBitSet(by4, 5, (Set<PosixFilePermission>)iterable, PosixFilePermission.GROUP_READ);
        byte by5 = byArray7[2];
        FileUtils.addIfBitSet(by5, 4, (Set<PosixFilePermission>)iterable, PosixFilePermission.GROUP_WRITE);
        byte by6 = byArray6[2];
        FileUtils.addIfBitSet(by6, 3, (Set<PosixFilePermission>)iterable, PosixFilePermission.GROUP_EXECUTE);
        byte by7 = byArray9[2];
        FileUtils.addIfBitSet(by7, 2, (Set<PosixFilePermission>)iterable, PosixFilePermission.OTHERS_READ);
        byte by8 = byArray8[2];
        FileUtils.addIfBitSet(by8, 1, (Set<PosixFilePermission>)iterable, PosixFilePermission.OTHERS_WRITE);
        byte by9 = byArray10[2];
        FileUtils.addIfBitSet(by9, 0, (Set<PosixFilePermission>)iterable, PosixFilePermission.OTHERS_EXECUTE);
        Files.setPosixFilePermissions(path, (Set<PosixFilePermission>)iterable);
    }

    private static byte[] getWindowsFileAttributes(Path path) {
        LinkOption[] linkOptionArray;
        Class<DosFileAttributeView> clazz;
        Path path2;
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        try {
            path2 = path;
            clazz = DosFileAttributeView.class;
            linkOptionArray = new LinkOption[1];
        }
        catch (IOException iOException) {}
        linkOptionArray[0] = LinkOption.NOFOLLOW_LINKS;
        DosFileAttributes dosFileAttributes = Files.getFileAttributeView(path2, clazz, linkOptionArray).readAttributes();
        byte by = 0;
        by = FileUtils.setBitIfApplicable(dosFileAttributes.isReadOnly(), by, 0);
        by = FileUtils.setBitIfApplicable(dosFileAttributes.isHidden(), by, 1);
        by = FileUtils.setBitIfApplicable(dosFileAttributes.isSystem(), by, 2);
        by = FileUtils.setBitIfApplicable(dosFileAttributes.isDirectory(), by, 4);
        byArray[0] = FileUtils.setBitIfApplicable(dosFileAttributes.isArchive(), by, 5);
        return byArray2;
    }

    private static void assertFileExists(File file) throws ZipException {
        if (file.exists()) {
            return;
        }
        throw new ZipException("File does not exist: " + file);
    }

    private static void assertSymbolicLinkTargetExists(File file) throws ZipException {
        if (file.exists()) {
            return;
        }
        throw new ZipException("Symlink target '" + FileUtils.readSymbolicLink(file) + "' does not exist for link '" + file + "'");
    }

    private static byte[] getPosixFileAttributes(Path path) {
        LinkOption[] linkOptionArray;
        Class<PosixFileAttributeView> clazz;
        Path path2;
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        try {
            path2 = path;
            clazz = PosixFileAttributeView.class;
            linkOptionArray = new LinkOption[1];
        }
        catch (IOException iOException) {}
        linkOptionArray[0] = LinkOption.NOFOLLOW_LINKS;
        Set<PosixFilePermission> set = Files.getFileAttributeView(path2, clazz, linkOptionArray).readAttributes().permissions();
        int n2 = 3;
        byArray2[n2] = FileUtils.setBitIfApplicable(Files.isRegularFile(path, new LinkOption[0]), byArray2[3], 7);
        n2 = 3;
        byArray2[n2] = FileUtils.setBitIfApplicable(Files.isDirectory(path, new LinkOption[0]), byArray2[3], 6);
        byArray2[3] = FileUtils.setBitIfApplicable(Files.isSymbolicLink(path), byArray2[3], 5);
        int n3 = 3;
        byArray2[n3] = FileUtils.setBitIfApplicable(set.contains((Object)PosixFilePermission.OWNER_READ), byArray2[3], 0);
        n3 = 2;
        byArray2[n3] = FileUtils.setBitIfApplicable(set.contains((Object)PosixFilePermission.OWNER_WRITE), byArray2[2], 7);
        n3 = 2;
        byArray2[n3] = FileUtils.setBitIfApplicable(set.contains((Object)PosixFilePermission.OWNER_EXECUTE), byArray2[2], 6);
        n3 = 2;
        byArray2[n3] = FileUtils.setBitIfApplicable(set.contains((Object)PosixFilePermission.GROUP_READ), byArray2[2], 5);
        n3 = 2;
        byArray2[n3] = FileUtils.setBitIfApplicable(set.contains((Object)PosixFilePermission.GROUP_WRITE), byArray2[2], 4);
        n3 = 2;
        byArray2[n3] = FileUtils.setBitIfApplicable(set.contains((Object)PosixFilePermission.GROUP_EXECUTE), byArray2[2], 3);
        n3 = 2;
        byArray2[n3] = FileUtils.setBitIfApplicable(set.contains((Object)PosixFilePermission.OTHERS_READ), byArray2[2], 2);
        n3 = 2;
        byArray2[n3] = FileUtils.setBitIfApplicable(set.contains((Object)PosixFilePermission.OTHERS_WRITE), byArray2[2], 1);
        n3 = 2;
        byArray[n3] = FileUtils.setBitIfApplicable(set.contains((Object)PosixFilePermission.OTHERS_EXECUTE), byArray2[2], 0);
        return byArray2;
    }

    private static byte setBitIfApplicable(boolean bl, byte by, int n2) {
        if (bl) {
            by = BitUtils.setBit(by, n2);
        }
        return by;
    }

    private static void addIfBitSet(byte by, int n2, Set<PosixFilePermission> set, PosixFilePermission posixFilePermission) {
        if (BitUtils.isBitSet(by, n2)) {
            set.add(posixFilePermission);
        }
    }

    private static /* synthetic */ boolean lambda$getAllSortedNumberedSplitFiles$0(String string2, File file, String string3) {
        return string3.startsWith(string2 + ".");
    }
}

