/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.progress.ProgressMonitor;

public class CrcUtil {
    private static final int BUF_SIZE = 16384;

    public static long computeFileCrc(File file, ProgressMonitor progressMonitor) throws IOException {
        if (file != null && file.exists() && file.canRead()) {
            FileInputStream fileInputStream;
            CRC32 cRC32;
            block12: {
                FileInputStream fileInputStream2;
                CRC32 cRC322;
                byte[] byArray = new byte[16384];
                cRC32 = cRC322;
                cRC322 = new CRC32();
                fileInputStream = fileInputStream2;
                fileInputStream2 = new FileInputStream(file);
                while (true) {
                    int n2 = ((InputStream)fileInputStream).read(byArray);
                    if (n2 == -1) break block12;
                    cRC32.update(byArray, 0, n2);
                    if (progressMonitor == null) continue;
                    ProgressMonitor progressMonitor2 = progressMonitor;
                    progressMonitor2.updateWorkCompleted(n2);
                    if (progressMonitor2.isCancelAllTasks()) break;
                    continue;
                    break;
                }
                try {
                    ProgressMonitor progressMonitor3 = progressMonitor;
                    progressMonitor3.setResult(ProgressMonitor.Result.CANCELLED);
                    progressMonitor3.setState(ProgressMonitor.State.READY);
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                ((InputStream)fileInputStream).close();
                return 0L;
            }
            long l2 = cRC32.getValue();
            ((InputStream)fileInputStream).close();
            return l2;
        }
        throw new ZipException("input file is null or does not exist or cannot read. Cannot calculate CRC for the file");
    }
}

