/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.tasks;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.headers.HeaderUtil;
import net.lingala.zip4j.headers.HeaderWriter;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.Zip4jConfig;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.tasks.AbstractModifyFileTask;
import net.lingala.zip4j.tasks.AbstractZipTaskParameters;
import net.lingala.zip4j.tasks.AsyncZipTask;
import net.lingala.zip4j.util.RawIO;
import net.lingala.zip4j.util.Zip4jUtil;

public class RenameFilesTask
extends AbstractModifyFileTask<RenameFilesTaskParameters> {
    private final ZipModel zipModel;
    private final HeaderWriter headerWriter;
    private final RawIO rawIO;

    public RenameFilesTask(ZipModel zipModel, HeaderWriter headerWriter, RawIO rawIO, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(asyncTaskParameters);
        this.zipModel = zipModel;
        this.headerWriter = headerWriter;
        this.rawIO = rawIO;
    }

    private long copyEntryAndChangeFileName(byte[] byArray, FileHeader fileHeader, long l2, long l3, RandomAccessFile randomAccessFile, OutputStream outputStream, ProgressMonitor progressMonitor, int n2) throws IOException {
        long l4 = l2 + this.copyFile(randomAccessFile, outputStream, l2, 26L, progressMonitor, n2);
        this.rawIO.writeShortLittleEndian(outputStream, byArray.length);
        long l5 = l4 + 2L;
        long l6 = l5 + this.copyFile(randomAccessFile, outputStream, l5, 2L, progressMonitor, n2);
        outputStream.write(byArray);
        long l7 = l6 + (long)fileHeader.getFileNameLength();
        l2 = l3 - (l7 - l2);
        return l7 + this.copyFile(randomAccessFile, outputStream, l7, l2, progressMonitor, n2);
    }

    private Map.Entry<String, String> getCorrespondingEntryFromMap(FileHeader fileHeader, Map<String, String> object2) {
        for (Map.Entry entry : object2.entrySet()) {
            if (!fileHeader.getFileName().startsWith((String)entry.getKey())) continue;
            return entry;
        }
        return null;
    }

    private void updateHeadersInZipModel(List<FileHeader> object, FileHeader fileHeader, String string2, byte[] byArray, int n2) throws ZipException {
        FileHeader fileHeader2 = HeaderUtil.getFileHeader(this.zipModel, fileHeader.getFileName());
        if (fileHeader2 != null) {
            RenameFilesTask renameFilesTask = this;
            List<FileHeader> list = object;
            fileHeader2.setFileName(string2);
            fileHeader2.setFileNameLength(byArray.length);
            object = this.zipModel;
            long l2 = n2;
            renameFilesTask.updateOffsetsForAllSubsequentFileHeaders(list, (ZipModel)object, fileHeader2, l2);
            renameFilesTask.zipModel.getEndOfCentralDirectoryRecord().setOffsetOfStartOfCentralDirectory(this.zipModel.getEndOfCentralDirectoryRecord().getOffsetOfStartOfCentralDirectory() + l2);
            if (renameFilesTask.zipModel.isZip64Format()) {
                RenameFilesTask renameFilesTask2 = this;
                renameFilesTask2.zipModel.getZip64EndOfCentralDirectoryRecord().setOffsetStartCentralDirectoryWRTStartDiskNumber(this.zipModel.getZip64EndOfCentralDirectoryRecord().getOffsetStartCentralDirectoryWRTStartDiskNumber() + l2);
                renameFilesTask2.zipModel.getZip64EndOfCentralDirectoryLocator().setOffsetZip64EndOfCentralDirectoryRecord(this.zipModel.getZip64EndOfCentralDirectoryLocator().getOffsetZip64EndOfCentralDirectoryRecord() + l2);
            }
            return;
        }
        throw new ZipException("could not find any header with name: " + fileHeader.getFileName());
    }

    private Map<String, String> filterNonExistingEntriesAndAddSeparatorIfNeeded(Map<String, String> hashMap) throws ZipException {
        HashMap<String, String> hashMap2;
        HashMap<String, String> hashMap3 = hashMap;
        hashMap = hashMap2;
        hashMap2 = new HashMap<String, String>();
        for (Map.Entry entry : hashMap3.entrySet()) {
            FileHeader fileHeader;
            if (!Zip4jUtil.isStringNotNullAndNotEmpty((String)entry.getKey()) || (fileHeader = HeaderUtil.getFileHeader(this.zipModel, (String)entry.getKey())) == null) continue;
            if (fileHeader.isDirectory() && !((String)entry.getValue()).endsWith("/")) {
                hashMap.put((String)entry.getKey(), (String)entry.getValue() + "/");
                continue;
            }
            Map.Entry entry2 = entry;
            entry = entry2.getKey();
            hashMap.put((String)((Object)entry), (String)entry2.getValue());
        }
        return hashMap;
    }

    private String getNewFileName(String string2, String string3, String string4) throws ZipException {
        if (string4.equals(string3)) {
            return string2;
        }
        if (string4.startsWith(string3)) {
            return string2 + string4.substring(string3.length());
        }
        throw new ZipException("old file name was neither an exact match nor a partial match");
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void executeTask(RenameFilesTaskParameters var1_1, ProgressMonitor var2_4) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected long calculateTotalWork(RenameFilesTaskParameters renameFilesTaskParameters) {
        return this.zipModel.getZipFile().length();
    }

    @Override
    protected ProgressMonitor.Task getTask() {
        return ProgressMonitor.Task.RENAME_FILE;
    }

    public static class RenameFilesTaskParameters
    extends AbstractZipTaskParameters {
        private final Map<String, String> fileNamesMap;

        public RenameFilesTaskParameters(Map<String, String> map, Zip4jConfig zip4jConfig) {
            super(zip4jConfig);
            this.fileNamesMap = map;
        }

        static /* synthetic */ Map access$000(RenameFilesTaskParameters renameFilesTaskParameters) {
            return renameFilesTaskParameters.fileNamesMap;
        }
    }
}

