/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.tasks;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import net.lingala.zip4j.headers.HeaderWriter;
import net.lingala.zip4j.model.EndOfCentralDirectoryRecord;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.Zip4jConfig;
import net.lingala.zip4j.model.Zip64EndOfCentralDirectoryLocator;
import net.lingala.zip4j.model.Zip64EndOfCentralDirectoryRecord;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.model.enums.RandomAccessFileMode;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.tasks.AbstractZipTaskParameters;
import net.lingala.zip4j.tasks.AsyncZipTask;
import net.lingala.zip4j.util.RawIO;

public class MergeSplitZipFileTask
extends AsyncZipTask<MergeSplitZipFileTaskParameters> {
    private final ZipModel zipModel;
    private final RawIO rawIO;

    public MergeSplitZipFileTask(ZipModel zipModel, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(asyncTaskParameters);
        RawIO rawIO;
        RawIO rawIO2 = rawIO;
        rawIO = new RawIO();
        v1.rawIO = rawIO2;
        v1.zipModel = zipModel;
    }

    private void updateFileHeaderOffsetsForIndex(List<FileHeader> object, long l2, int n2, int n3) {
        Iterator<FileHeader> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (FileHeader)iterator.next();
            if (((FileHeader)object).getDiskNumberStart() != n2) continue;
            Object object2 = object;
            ((FileHeader)object2).setOffsetLocalHeader(((FileHeader)object2).getOffsetLocalHeader() + l2 - (long)n3);
            ((FileHeader)object2).setDiskNumberStart(0);
        }
    }

    private File getNextSplitZipFile(ZipModel zipModel, int n2) {
        if (n2 == zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk()) {
            return zipModel.getZipFile();
        }
        Object object = ".z0";
        if (n2 >= 9) {
            object = ".z";
        }
        String string2 = zipModel.getZipFile().getPath();
        object = zipModel.getZipFile().getPath().substring(0, string2.lastIndexOf(".")) + (String)object + (n2 + 1);
        return new File((String)object);
    }

    private RandomAccessFile createSplitZipFileStream(ZipModel zipModel, int n2) throws FileNotFoundException {
        File file = ((MergeSplitZipFileTask)((Object)file)).getNextSplitZipFile(zipModel, n2);
        return new RandomAccessFile(file, RandomAccessFileMode.READ.getValue());
    }

    private void updateHeadersForMergeSplitFileAction(ZipModel zipModel, long l2, OutputStream outputStream, Charset charset) throws IOException, CloneNotSupportedException {
        MergeSplitZipFileTask mergeSplitZipFileTask = zipModel2;
        ZipModel zipModel2 = (ZipModel)zipModel.clone();
        zipModel2.getEndOfCentralDirectoryRecord().setOffsetOfStartOfCentralDirectory(l2);
        mergeSplitZipFileTask.updateSplitZipModel(zipModel2, l2);
        new HeaderWriter().finalizeZipFileWithoutValidations(zipModel2, outputStream, charset);
    }

    private void updateSplitZipModel(ZipModel zipModel, long l2) {
        ZipModel zipModel2 = zipModel;
        zipModel2.setSplitArchive(false);
        this.updateSplitEndCentralDirectory(zipModel2);
        if (zipModel.isZip64Format()) {
            MergeSplitZipFileTask mergeSplitZipFileTask = this;
            mergeSplitZipFileTask.updateSplitZip64EndCentralDirLocator(zipModel, l2);
            mergeSplitZipFileTask.updateSplitZip64EndCentralDirRec(zipModel, l2);
        }
    }

    private void updateSplitEndCentralDirectory(ZipModel object) {
        ZipModel zipModel = object;
        int n2 = zipModel.getCentralDirectory().getFileHeaders().size();
        Object object2 = object = zipModel.getEndOfCentralDirectoryRecord();
        ((EndOfCentralDirectoryRecord)object2).setNumberOfThisDisk(0);
        ((EndOfCentralDirectoryRecord)object2).setNumberOfThisDiskStartOfCentralDir(0);
        ((EndOfCentralDirectoryRecord)object).setTotalNumberOfEntriesInCentralDirectory(n2);
        ((EndOfCentralDirectoryRecord)object).setTotalNumberOfEntriesInCentralDirectoryOnThisDisk(n2);
    }

    private void updateSplitZip64EndCentralDirLocator(ZipModel zipModel, long l2) {
        if (zipModel.getZip64EndOfCentralDirectoryLocator() == null) {
            return;
        }
        Zip64EndOfCentralDirectoryLocator zip64EndOfCentralDirectoryLocator = zipModel.getZip64EndOfCentralDirectoryLocator();
        zip64EndOfCentralDirectoryLocator.setNumberOfDiskStartOfZip64EndOfCentralDirectoryRecord(0);
        zip64EndOfCentralDirectoryLocator.setOffsetZip64EndOfCentralDirectoryRecord(zip64EndOfCentralDirectoryLocator.getOffsetZip64EndOfCentralDirectoryRecord() + l2);
        zip64EndOfCentralDirectoryLocator.setTotalNumberOfDiscs(1);
    }

    private void updateSplitZip64EndCentralDirRec(ZipModel zipModel, long l2) {
        if (zipModel.getZip64EndOfCentralDirectoryRecord() == null) {
            return;
        }
        Zip64EndOfCentralDirectoryRecord zip64EndOfCentralDirectoryRecord = zipModel.getZip64EndOfCentralDirectoryRecord();
        zip64EndOfCentralDirectoryRecord.setNumberOfThisDisk(0);
        zip64EndOfCentralDirectoryRecord.setNumberOfThisDiskStartOfCentralDirectory(0);
        zip64EndOfCentralDirectoryRecord.setTotalNumberOfEntriesInCentralDirectoryOnThisDisk(zipModel.getEndOfCentralDirectoryRecord().getTotalNumberOfEntriesInCentralDirectory());
        zip64EndOfCentralDirectoryRecord.setOffsetStartCentralDirectoryWRTStartDiskNumber(zip64EndOfCentralDirectoryRecord.getOffsetStartCentralDirectoryWRTStartDiskNumber() + l2);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void executeTask(MergeSplitZipFileTaskParameters var1_4, ProgressMonitor var2_7) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [29[FORLOOP], 24[CATCHBLOCK], 23[CATCHBLOCK], 22[CATCHBLOCK]], but top level block is 16[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected long calculateTotalWork(MergeSplitZipFileTaskParameters mergeSplitZipFileTaskParameters) {
        if (!this.zipModel.isSplitArchive()) {
            return 0L;
        }
        long l2 = 0L;
        for (int i2 = 0; i2 <= this.zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk(); ++i2) {
            MergeSplitZipFileTask mergeSplitZipFileTask = this;
            l2 += mergeSplitZipFileTask.getNextSplitZipFile(mergeSplitZipFileTask.zipModel, i2).length();
        }
        return l2;
    }

    @Override
    protected ProgressMonitor.Task getTask() {
        return ProgressMonitor.Task.MERGE_ZIP_FILES;
    }

    public static class MergeSplitZipFileTaskParameters
    extends AbstractZipTaskParameters {
        private File outputZipFile;

        public MergeSplitZipFileTaskParameters(File file, Zip4jConfig zip4jConfig) {
            super(zip4jConfig);
            this.outputZipFile = file;
        }

        static /* synthetic */ File access$000(MergeSplitZipFileTaskParameters mergeSplitZipFileTaskParameters) {
            return mergeSplitZipFileTaskParameters.outputZipFile;
        }
    }
}

