/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.lingala.zip4j.headers.HeaderUtil;
import net.lingala.zip4j.io.inputstream.SplitInputStream;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.UnzipParameters;
import net.lingala.zip4j.model.Zip4jConfig;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.tasks.AbstractExtractFileTask;
import net.lingala.zip4j.tasks.AbstractZipTaskParameters;
import net.lingala.zip4j.tasks.AsyncZipTask;
import net.lingala.zip4j.util.UnzipUtil;
import net.lingala.zip4j.util.Zip4jUtil;

public class ExtractFileTask
extends AbstractExtractFileTask<ExtractFileTaskParameters> {
    private char[] password;
    private SplitInputStream splitInputStream;

    public ExtractFileTask(ZipModel zipModel, char[] cArray, UnzipParameters unzipParameters, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(zipModel, unzipParameters, asyncTaskParameters);
        this.password = cArray;
    }

    private List<FileHeader> getFileHeadersToExtract(FileHeader fileHeader) {
        if (!fileHeader.isDirectory()) {
            return Collections.singletonList(fileHeader);
        }
        return HeaderUtil.getFileHeadersUnderDirectory(this.getZipModel().getCentralDirectory().getFileHeaders(), fileHeader);
    }

    private ZipInputStream createZipInputStream(FileHeader fileHeader, Zip4jConfig zip4jConfig) throws IOException {
        SplitInputStream splitInputStream;
        ((ExtractFileTask)((Object)splitInputStream2)).splitInputStream = splitInputStream = UnzipUtil.createSplitInputStream(((AbstractExtractFileTask)((Object)splitInputStream2)).getZipModel());
        splitInputStream.prepareExtractionForFileHeader(fileHeader);
        ExtractFileTask extractFileTask = splitInputStream2;
        SplitInputStream splitInputStream2 = extractFileTask.splitInputStream;
        return new ZipInputStream((InputStream)splitInputStream2, extractFileTask.password, zip4jConfig);
    }

    private String determineNewFileName(String string2, FileHeader fileHeader, FileHeader fileHeader2) {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string2)) {
            return string2;
        }
        if (!fileHeader.isDirectory()) {
            return string2;
        }
        Object object = "/";
        if (string2.endsWith("/")) {
            object = "";
        }
        return fileHeader2.getFileName().replaceFirst(fileHeader.getFileName(), string2 + (String)object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void executeTask(ExtractFileTaskParameters extractFileTaskParameters, ProgressMonitor progressMonitor) throws IOException {
        SplitInputStream splitInputStream;
        ExtractFileTask extractFileTask = splitInputStream;
        ExtractFileTaskParameters extractFileTaskParameters2 = extractFileTaskParameters;
        ExtractFileTaskParameters extractFileTaskParameters3 = extractFileTaskParameters;
        Object object = extractFileTaskParameters3.fileHeader;
        object = ((ExtractFileTask)((Object)splitInputStream)).createZipInputStream((FileHeader)object, extractFileTaskParameters3.zip4jConfig);
        try {
            byte[] byArray = new byte[extractFileTaskParameters.zip4jConfig.getBufferSize()];
            Iterator<FileHeader> iterator = extractFileTask.getFileHeadersToExtract(extractFileTaskParameters2.fileHeader).iterator();
            while (iterator.hasNext()) {
                ExtractFileTaskParameters extractFileTaskParameters4 = extractFileTaskParameters;
                FileHeader fileHeader = iterator.next();
                String string2 = extractFileTaskParameters4.newFileName;
                string2 = super.determineNewFileName(string2, extractFileTaskParameters4.fileHeader, fileHeader);
                ((AbstractExtractFileTask)((Object)splitInputStream)).extractFile((ZipInputStream)object, fileHeader, extractFileTaskParameters.outputPath, string2, progressMonitor, byArray);
            }
            if (object == null) return;
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                if (object == null) throw throwable2;
                try {
                    ((ZipInputStream)object).close();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                    throw throwable2;
                }
            }
        }
        try {
            ((ZipInputStream)object).close();
            return;
        }
        finally {
            splitInputStream = ((ExtractFileTask)((Object)splitInputStream)).splitInputStream;
            if (splitInputStream != null) {
                splitInputStream.close();
            }
        }
    }

    @Override
    protected long calculateTotalWork(ExtractFileTaskParameters extractFileTaskParameters) {
        return HeaderUtil.getTotalUncompressedSizeOfAllFileHeaders(this.getFileHeadersToExtract(extractFileTaskParameters.fileHeader));
    }

    public static class ExtractFileTaskParameters
    extends AbstractZipTaskParameters {
        private String outputPath;
        private FileHeader fileHeader;
        private String newFileName;

        public ExtractFileTaskParameters(String string2, FileHeader fileHeader, String string3, Zip4jConfig zip4jConfig) {
            super(zip4jConfig);
            this.outputPath = string2;
            this.fileHeader = fileHeader;
            this.newFileName = string3;
        }
    }
}

