/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.tasks;

import java.io.IOException;
import java.io.InputStream;
import net.lingala.zip4j.headers.HeaderUtil;
import net.lingala.zip4j.io.inputstream.SplitInputStream;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import net.lingala.zip4j.model.AbstractFileHeader;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.UnzipParameters;
import net.lingala.zip4j.model.Zip4jConfig;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.tasks.AbstractExtractFileTask;
import net.lingala.zip4j.tasks.AbstractZipTaskParameters;
import net.lingala.zip4j.tasks.AsyncZipTask;
import net.lingala.zip4j.util.UnzipUtil;

public class ExtractAllFilesTask
extends AbstractExtractFileTask<ExtractAllFilesTaskParameters> {
    private final char[] password;
    private SplitInputStream splitInputStream;

    public ExtractAllFilesTask(ZipModel zipModel, char[] cArray, UnzipParameters unzipParameters, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(zipModel, unzipParameters, asyncTaskParameters);
        this.password = cArray;
    }

    private ZipInputStream prepareZipInputStream(Zip4jConfig zip4jConfig) throws IOException {
        ExtractAllFilesTask extractAllFilesTask = splitInputStream;
        extractAllFilesTask.splitInputStream = UnzipUtil.createSplitInputStream(extractAllFilesTask.getZipModel());
        FileHeader fileHeader = extractAllFilesTask.getFirstFileHeader(extractAllFilesTask.getZipModel());
        if (fileHeader != null) {
            ((ExtractAllFilesTask)((Object)splitInputStream)).splitInputStream.prepareExtractionForFileHeader(fileHeader);
        }
        ExtractAllFilesTask extractAllFilesTask2 = splitInputStream;
        SplitInputStream splitInputStream = extractAllFilesTask2.splitInputStream;
        return new ZipInputStream((InputStream)splitInputStream, extractAllFilesTask2.password, zip4jConfig);
    }

    private FileHeader getFirstFileHeader(ZipModel zipModel) {
        if (zipModel.getCentralDirectory() != null && zipModel.getCentralDirectory().getFileHeaders() != null && zipModel.getCentralDirectory().getFileHeaders().size() != 0) {
            return zipModel.getCentralDirectory().getFileHeaders().get(0);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void executeTask(ExtractAllFilesTaskParameters extractAllFilesTaskParameters, ProgressMonitor progressMonitor) throws IOException {
        ExtractAllFilesTask extractAllFilesTask = splitInputStream;
        ExtractAllFilesTask extractAllFilesTask2 = extractAllFilesTask;
        ZipInputStream zipInputStream = extractAllFilesTask.prepareZipInputStream(extractAllFilesTaskParameters.zip4jConfig);
        try {
            for (Object object : extractAllFilesTask2.getZipModel().getCentralDirectory().getFileHeaders()) {
                if (((AbstractFileHeader)object).getFileName().startsWith("__MACOSX")) {
                    progressMonitor.updateWorkCompleted(((AbstractFileHeader)object).getUncompressedSize());
                    continue;
                }
                Object object2 = splitInputStream;
                FileHeader fileHeader = object;
                ExtractAllFilesTaskParameters extractAllFilesTaskParameters2 = extractAllFilesTaskParameters;
                ((ExtractAllFilesTask)((Object)splitInputStream)).splitInputStream.prepareExtractionForFileHeader((FileHeader)object);
                object = new byte[extractAllFilesTaskParameters2.zip4jConfig.getBufferSize()];
                ((AbstractExtractFileTask)object2).extractFile(zipInputStream, fileHeader, extractAllFilesTaskParameters2.outputPath, null, progressMonitor, (byte[])object);
                ((AsyncZipTask)object2).verifyIfTaskIsCancelled();
            }
            if (zipInputStream == null) return;
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                if (zipInputStream == null) throw throwable2;
                try {
                    zipInputStream.close();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                    throw throwable2;
                }
            }
        }
        try {
            zipInputStream.close();
            return;
        }
        finally {
            SplitInputStream splitInputStream = ((ExtractAllFilesTask)((Object)splitInputStream)).splitInputStream;
            if (splitInputStream != null) {
                splitInputStream.close();
            }
        }
    }

    @Override
    protected long calculateTotalWork(ExtractAllFilesTaskParameters extractAllFilesTaskParameters) {
        return HeaderUtil.getTotalUncompressedSizeOfAllFileHeaders(this.getZipModel().getCentralDirectory().getFileHeaders());
    }

    public static class ExtractAllFilesTaskParameters
    extends AbstractZipTaskParameters {
        private final String outputPath;

        public ExtractAllFilesTaskParameters(String string2, Zip4jConfig zip4jConfig) {
            super(zip4jConfig);
            this.outputPath = string2;
        }
    }
}

