/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.tasks;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.headers.HeaderUtil;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.tasks.AsyncZipTask;
import net.lingala.zip4j.util.FileUtils;

abstract class AbstractModifyFileTask<T>
extends AsyncZipTask<T> {
    AbstractModifyFileTask(AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(asyncTaskParameters);
    }

    private void restoreFileName(File file, File file2) throws ZipException {
        if (file.delete()) {
            if (file2.renameTo(file)) {
                return;
            }
            throw new ZipException("cannot rename modified zip file");
        }
        throw new ZipException("cannot delete old zip file");
    }

    private int getIndexOfFileHeader(List<FileHeader> list, FileHeader fileHeader) throws ZipException {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!list.get(i2).equals(fileHeader)) continue;
            return i2;
        }
        throw new ZipException("Could not find file header in list of central directory file headers");
    }

    File getTemporaryFile(String string2) {
        File file;
        Random random;
        Random random2 = random;
        random = new Random();
        File file2 = file;
        file = new File(string2 + random2.nextInt(10000));
        while (file2.exists()) {
            File file3;
            file2 = file3;
            file3 = new File(string2 + random2.nextInt(10000));
        }
        return file2;
    }

    void updateOffsetsForAllSubsequentFileHeaders(List<FileHeader> list, ZipModel zipModel, FileHeader fileHeader, long l2) throws ZipException {
        int n2 = this.getIndexOfFileHeader(list, fileHeader);
        if (n2 != -1) {
            while (++n2 < list.size()) {
                fileHeader = list.get(n2);
                fileHeader.setOffsetLocalHeader(fileHeader.getOffsetLocalHeader() + l2);
                if (!zipModel.isZip64Format() || fileHeader.getZip64ExtendedInfo() == null || fileHeader.getZip64ExtendedInfo().getOffsetLocalHeader() == -1L) continue;
                fileHeader.getZip64ExtendedInfo().setOffsetLocalHeader(fileHeader.getZip64ExtendedInfo().getOffsetLocalHeader() + l2);
            }
            return;
        }
        throw new ZipException("Could not locate modified file header in zipModel");
    }

    void cleanupFile(boolean bl, File file, File file2) throws ZipException {
        block4: {
            block3: {
                block2: {
                    if (!bl) break block2;
                    this.restoreFileName(file, file2);
                    break block3;
                }
                if (!file2.delete()) break block4;
            }
            return;
        }
        throw new ZipException("Could not delete temporary file");
    }

    long copyFile(RandomAccessFile randomAccessFile, OutputStream outputStream, long l2, long l3, ProgressMonitor progressMonitor, int n2) throws IOException {
        long l4 = l2 + l3;
        FileUtils.copyFile(randomAccessFile, outputStream, l2, l4, progressMonitor, n2);
        return l3;
    }

    List<FileHeader> cloneAndSortFileHeadersByOffset(List<FileHeader> list) {
        ArrayList<FileHeader> arrayList = new ArrayList<FileHeader>(list);
        Collections.sort(arrayList, (fileHeader, fileHeader2) -> {
            if (fileHeader.getFileName().equals(fileHeader2.getFileName())) {
                return 0;
            }
            return fileHeader.getOffsetLocalHeader() < fileHeader2.getOffsetLocalHeader() ? -1 : 1;
        });
        return arrayList;
    }

    long getOffsetOfNextEntry(List<FileHeader> list, FileHeader fileHeader, ZipModel zipModel) throws ZipException {
        int n2 = this.getIndexOfFileHeader(list, fileHeader);
        if (n2 == list.size() - 1) {
            return HeaderUtil.getOffsetStartOfCentralDirectory(zipModel);
        }
        return list.get(n2 + 1).getOffsetLocalHeader();
    }
}

