/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io.outputstream;

import java.io.IOException;
import java.io.OutputStream;
import net.lingala.zip4j.crypto.StandardEncrypter;
import net.lingala.zip4j.io.outputstream.CipherOutputStream;
import net.lingala.zip4j.io.outputstream.ZipEntryOutputStream;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.util.Zip4jUtil;

class ZipStandardCipherOutputStream
extends CipherOutputStream<StandardEncrypter> {
    public ZipStandardCipherOutputStream(ZipEntryOutputStream zipEntryOutputStream, ZipParameters zipParameters, char[] cArray) throws IOException {
        super(zipEntryOutputStream, zipParameters, cArray);
    }

    private long getEncryptionKey(ZipParameters zipParameters) {
        if (zipParameters.isWriteExtendedLocalFileHeader()) {
            return (Zip4jUtil.epochToExtendedDosTime(zipParameters.getLastModifiedFileTime()) & 0xFFFFL) << 16;
        }
        return zipParameters.getEntryCRC();
    }

    @Override
    protected StandardEncrypter initializeEncrypter(OutputStream outputStream, ZipParameters zipParameters, char[] cArray) throws IOException {
        long l2 = this.getEncryptionKey(zipParameters);
        StandardEncrypter standardEncrypter = new StandardEncrypter(cArray, l2);
        this.writeHeaders(standardEncrypter.getHeaderBytes());
        return standardEncrypter;
    }

    @Override
    public void write(int n2) throws IOException {
        ZipStandardCipherOutputStream zipStandardCipherOutputStream = object;
        byte[] byArray = new byte[1];
        Object object = byArray;
        byArray[0] = (byte)n2;
        zipStandardCipherOutputStream.write((byte[])object);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        int n2 = byArray.length;
        this.write(byArray, 0, n2);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        super.write(byArray, n2, n3);
    }
}

