/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io.outputstream;

import java.io.IOException;
import java.io.OutputStream;
import net.lingala.zip4j.crypto.AESEncrypter;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.outputstream.CipherOutputStream;
import net.lingala.zip4j.io.outputstream.ZipEntryOutputStream;
import net.lingala.zip4j.model.ZipParameters;

class AesCipherOutputStream
extends CipherOutputStream<AESEncrypter> {
    private byte[] pendingBuffer = new byte[16];
    private int pendingBufferLength = 0;

    public AesCipherOutputStream(ZipEntryOutputStream zipEntryOutputStream, ZipParameters zipParameters, char[] cArray) throws IOException, ZipException {
        super(zipEntryOutputStream, zipParameters, cArray);
    }

    private void writeAesEncryptionHeaderData(AESEncrypter aESEncrypter) throws IOException {
        this.writeHeaders(aESEncrypter.getSaltBytes());
        this.writeHeaders(aESEncrypter.getDerivedPasswordVerifier());
    }

    @Override
    protected AESEncrypter initializeEncrypter(OutputStream object, ZipParameters zipParameters, char[] cArray) throws IOException, ZipException {
        AESEncrypter aESEncrypter;
        object = aESEncrypter;
        ((AESEncrypter)object)(cArray, zipParameters.getAesKeyStrength());
        this.writeAesEncryptionHeaderData((AESEncrypter)object);
        return aESEncrypter;
    }

    @Override
    public void write(int n2) throws IOException {
        AesCipherOutputStream aesCipherOutputStream = object;
        byte[] byArray = new byte[1];
        Object object = byArray;
        byArray[0] = (byte)n2;
        aesCipherOutputStream.write((byte[])object);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        int n2 = byArray.length;
        this.write(byArray, 0, n2);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.pendingBufferLength;
        if (n3 >= 16 - n4) {
            int n5 = n3;
            AesCipherOutputStream aesCipherOutputStream = this;
            byte[] byArray2 = this.pendingBuffer;
            n3 = 16 - n4;
            System.arraycopy(byArray, n2, byArray2, n4, n3);
            super.write(aesCipherOutputStream.pendingBuffer, 0, aesCipherOutputStream.pendingBuffer.length);
            int n6 = 16 - aesCipherOutputStream.pendingBufferLength;
            n3 = n5 - n6;
            this.pendingBufferLength = 0;
            if (n3 != 0 && (n4 = n3 % 16) != 0) {
                int n7 = n3;
                n3 = n3 + n6 - n4;
                System.arraycopy(byArray, n3, this.pendingBuffer, 0, n4);
                this.pendingBufferLength = n4;
                n3 = n7 - n4;
            }
            super.write(byArray, n6, n3);
            return;
        }
        System.arraycopy(byArray, n2, this.pendingBuffer, n4, n3);
        this.pendingBufferLength += n3;
    }

    @Override
    public void closeEntry() throws IOException {
        int n2 = this.pendingBufferLength;
        if (n2 != 0) {
            AesCipherOutputStream aesCipherOutputStream = this;
            super.write(aesCipherOutputStream.pendingBuffer, 0, n2);
            aesCipherOutputStream.pendingBufferLength = 0;
        }
        AesCipherOutputStream aesCipherOutputStream = this;
        aesCipherOutputStream.writeHeaders(((AESEncrypter)aesCipherOutputStream.getEncrypter()).getFinalMac());
        super.closeEntry();
    }
}

