/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io.inputstream;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.headers.HeaderReader;
import net.lingala.zip4j.headers.HeaderSignature;
import net.lingala.zip4j.io.inputstream.AesCipherInputStream;
import net.lingala.zip4j.io.inputstream.CipherInputStream;
import net.lingala.zip4j.io.inputstream.DecompressedInputStream;
import net.lingala.zip4j.io.inputstream.InflaterInputStream;
import net.lingala.zip4j.io.inputstream.NoCipherInputStream;
import net.lingala.zip4j.io.inputstream.StoreInputStream;
import net.lingala.zip4j.io.inputstream.ZipEntryInputStream;
import net.lingala.zip4j.io.inputstream.ZipStandardCipherInputStream;
import net.lingala.zip4j.model.DataDescriptor;
import net.lingala.zip4j.model.ExtraDataRecord;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.Zip4jConfig;
import net.lingala.zip4j.model.enums.AesVersion;
import net.lingala.zip4j.model.enums.CompressionMethod;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import net.lingala.zip4j.util.Zip4jUtil;

public class ZipInputStream
extends InputStream {
    private PushbackInputStream inputStream;
    private DecompressedInputStream decompressedInputStream;
    private HeaderReader headerReader;
    private char[] password;
    private LocalFileHeader localFileHeader;
    private CRC32 crc32;
    private byte[] endOfEntryBuffer;
    private boolean canSkipExtendedLocalFileHeader;
    private Zip4jConfig zip4jConfig;
    private boolean streamClosed;
    private boolean entryEOFReached;

    public ZipInputStream(InputStream inputStream) {
        this(inputStream, (char[])null, (Charset)null);
    }

    public ZipInputStream(InputStream inputStream, Charset charset) {
        this(inputStream, null, charset);
    }

    public ZipInputStream(InputStream inputStream, char[] cArray) {
        this(inputStream, cArray, (Charset)null);
    }

    public ZipInputStream(InputStream inputStream, char[] cArray, Charset charset) {
        Zip4jConfig zip4jConfig;
        ZipInputStream zipInputStream = zip4jConfig2;
        Zip4jConfig zip4jConfig2 = zip4jConfig;
        zip4jConfig = new Zip4jConfig(charset, 4096);
        zipInputStream(inputStream, cArray, zip4jConfig2);
    }

    public ZipInputStream(InputStream inputStream, char[] cArray, Zip4jConfig zip4jConfig) {
        inputStream2.headerReader = new HeaderReader();
        inputStream2.crc32 = new CRC32();
        inputStream2.canSkipExtendedLocalFileHeader = false;
        inputStream2.streamClosed = false;
        inputStream2.entryEOFReached = false;
        if (zip4jConfig.getBufferSize() >= 512) {
            PushbackInputStream pushbackInputStream;
            ZipInputStream zipInputStream = inputStream2;
            InputStream inputStream2 = pushbackInputStream;
            pushbackInputStream = new PushbackInputStream(inputStream, zip4jConfig.getBufferSize());
            zipInputStream.inputStream = inputStream2;
            zipInputStream.password = cArray;
            zipInputStream.zip4jConfig = zip4jConfig;
            return;
        }
        throw new IllegalArgumentException("Buffer size cannot be less than 512 bytes");
    }

    private void endOfCompressedDataReached() throws IOException {
        ZipInputStream zipInputStream = this;
        zipInputStream.decompressedInputStream.pushBackInputStreamIfNecessary(this.inputStream);
        zipInputStream.decompressedInputStream.endOfEntryReached(this.inputStream);
        zipInputStream.readExtendedLocalFileHeaderIfPresent();
        zipInputStream.verifyCrc();
        zipInputStream.resetFields();
        zipInputStream.entryEOFReached = true;
    }

    private DecompressedInputStream initializeEntryInputStream(LocalFileHeader localFileHeader) throws IOException {
        ZipInputStream zipInputStream = inputStream;
        ZipInputStream zipInputStream2 = inputStream;
        InputStream inputStream = inputStream.inputStream;
        long l2 = zipInputStream2.getCompressedSize(localFileHeader);
        return zipInputStream.initializeDecompressorForThisEntry(zipInputStream.initializeCipherInputStream(new ZipEntryInputStream(inputStream, l2), localFileHeader), localFileHeader);
    }

    private CipherInputStream initializeCipherInputStream(ZipEntryInputStream zipEntryInputStream, LocalFileHeader localFileHeader) throws IOException {
        Object object;
        if (!localFileHeader.isEncrypted()) {
            ZipInputStream zipInputStream = object;
            object = zipInputStream.password;
            int n2 = zipInputStream.zip4jConfig.getBufferSize();
            return new NoCipherInputStream(zipEntryInputStream, localFileHeader, (char[])object, n2);
        }
        if (localFileHeader.getEncryptionMethod() == EncryptionMethod.AES) {
            Object[] objectArray = object;
            object = objectArray.password;
            int n3 = objectArray.zip4jConfig.getBufferSize();
            return new AesCipherInputStream(zipEntryInputStream, localFileHeader, (char[])object, n3);
        }
        if (localFileHeader.getEncryptionMethod() == EncryptionMethod.ZIP_STANDARD) {
            object = object.password;
            int n4 = object.zip4jConfig.getBufferSize();
            return new ZipStandardCipherInputStream(zipEntryInputStream, localFileHeader, (char[])object, n4);
        }
        Object[] objectArray = new Object[1];
        object = objectArray;
        objectArray[0] = localFileHeader.getFileName();
        object = String.format("Entry [%s] Strong Encryption not supported", object);
        throw new ZipException((String)object, ZipException.Type.UNSUPPORTED_ENCRYPTION);
    }

    private DecompressedInputStream initializeDecompressorForThisEntry(CipherInputStream cipherInputStream, LocalFileHeader localFileHeader) {
        if (Zip4jUtil.getCompressionMethod(localFileHeader) == CompressionMethod.DEFLATE) {
            return new InflaterInputStream(cipherInputStream, this.zip4jConfig.getBufferSize());
        }
        return new StoreInputStream(cipherInputStream);
    }

    private void readExtendedLocalFileHeaderIfPresent() throws IOException {
        if (((ZipInputStream)object).localFileHeader.isDataDescriptorExists() && !((ZipInputStream)object).canSkipExtendedLocalFileHeader) {
            ZipInputStream zipInputStream = object;
            ZipInputStream zipInputStream2 = object;
            Object object = zipInputStream2.inputStream;
            object = zipInputStream.headerReader.readDataDescriptor((InputStream)object, zipInputStream2.checkIfZip64ExtraDataRecordPresentInLFH(zipInputStream2.localFileHeader.getExtraDataRecords()));
            zipInputStream.localFileHeader.setCompressedSize(((DataDescriptor)object).getCompressedSize());
            zipInputStream.localFileHeader.setUncompressedSize(((DataDescriptor)object).getUncompressedSize());
            zipInputStream.localFileHeader.setCrc(((DataDescriptor)object).getCrc());
            return;
        }
    }

    private void verifyLocalFileHeader(LocalFileHeader localFileHeader) throws IOException {
        if (!this.isEntryDirectory(localFileHeader.getFileName()) && localFileHeader.getCompressionMethod() == CompressionMethod.STORE && localFileHeader.getUncompressedSize() < 0L) {
            throw new IOException("Invalid local file header for: " + localFileHeader.getFileName() + ". Uncompressed size has to be set for entry of compression type store which is not a directory");
        }
    }

    private boolean checkIfZip64ExtraDataRecordPresentInLFH(List<ExtraDataRecord> list) {
        if (list == null) {
            return false;
        }
        Iterator<ExtraDataRecord> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (((ExtraDataRecord)iterator.next()).getHeader() != HeaderSignature.ZIP64_EXTRA_FIELD_SIGNATURE.getValue()) continue;
            return true;
        }
        return false;
    }

    private void verifyCrc() throws IOException {
        if (this.localFileHeader.getEncryptionMethod() == EncryptionMethod.AES && this.localFileHeader.getAesExtraDataRecord().getAesVersion().equals((Object)AesVersion.TWO)) {
            return;
        }
        if (this.localFileHeader.getCrc() != this.crc32.getValue()) {
            ZipInputStream zipInputStream = this;
            ZipException.Type type = ZipException.Type.CHECKSUM_MISMATCH;
            if (zipInputStream.isEncryptionMethodZipStandard(zipInputStream.localFileHeader)) {
                type = ZipException.Type.WRONG_PASSWORD;
            }
            throw new ZipException("Reached end of entry, but crc verification failed for " + this.localFileHeader.getFileName(), type);
        }
    }

    private void resetFields() {
        this.localFileHeader = null;
        this.crc32.reset();
    }

    private boolean isEntryDirectory(String string2) {
        return string2.endsWith("/") || string2.endsWith("\\");
    }

    private long getCompressedSize(LocalFileHeader localFileHeader) {
        if (Zip4jUtil.getCompressionMethod(localFileHeader).equals((Object)CompressionMethod.STORE)) {
            return localFileHeader.getUncompressedSize();
        }
        if (localFileHeader.isDataDescriptorExists() && !this.canSkipExtendedLocalFileHeader) {
            return -1L;
        }
        return localFileHeader.getCompressedSize() - (long)this.getEncryptionHeaderSize(localFileHeader);
    }

    private int getEncryptionHeaderSize(LocalFileHeader localFileHeader) {
        if (!localFileHeader.isEncrypted()) {
            return 0;
        }
        if (localFileHeader.getEncryptionMethod().equals((Object)EncryptionMethod.AES)) {
            return localFileHeader.getAesExtraDataRecord().getAesKeyStrength().getSaltLength() + 12;
        }
        if (localFileHeader.getEncryptionMethod().equals((Object)EncryptionMethod.ZIP_STANDARD)) {
            return 12;
        }
        return 0;
    }

    private void readUntilEndOfEntry() throws IOException {
        ZipInputStream zipInputStream;
        if ((this.localFileHeader.isDirectory() || this.localFileHeader.getCompressedSize() == 0L) && !this.localFileHeader.isDataDescriptorExists()) {
            return;
        }
        if (this.endOfEntryBuffer == null) {
            this.endOfEntryBuffer = new byte[512];
        }
        do {
            zipInputStream = this;
        } while (zipInputStream.read(zipInputStream.endOfEntryBuffer) != -1);
        this.entryEOFReached = true;
    }

    private boolean isEncryptionMethodZipStandard(LocalFileHeader localFileHeader) {
        return localFileHeader.isEncrypted() && EncryptionMethod.ZIP_STANDARD.equals((Object)localFileHeader.getEncryptionMethod());
    }

    private void assertStreamOpen() throws IOException {
        if (!this.streamClosed) {
            return;
        }
        throw new IOException("Stream closed");
    }

    public LocalFileHeader getNextEntry() throws IOException {
        return this.getNextEntry(null);
    }

    public LocalFileHeader getNextEntry(FileHeader fileHeader) throws IOException {
        LocalFileHeader localFileHeader;
        if (this.localFileHeader != null) {
            this.readUntilEndOfEntry();
        }
        this.localFileHeader = localFileHeader = this.headerReader.readLocalFileHeader(this.inputStream, this.zip4jConfig.getCharset());
        if (localFileHeader == null) {
            return null;
        }
        ZipInputStream zipInputStream = this;
        zipInputStream.verifyLocalFileHeader(localFileHeader);
        zipInputStream.crc32.reset();
        if (fileHeader != null) {
            ZipInputStream zipInputStream2 = this;
            zipInputStream2.localFileHeader.setCrc(fileHeader.getCrc());
            zipInputStream2.localFileHeader.setCompressedSize(fileHeader.getCompressedSize());
            zipInputStream2.localFileHeader.setUncompressedSize(fileHeader.getUncompressedSize());
            zipInputStream2.localFileHeader.setDirectory(fileHeader.isDirectory());
            zipInputStream2.canSkipExtendedLocalFileHeader = true;
        } else {
            this.canSkipExtendedLocalFileHeader = false;
        }
        ZipInputStream zipInputStream3 = this;
        zipInputStream3.decompressedInputStream = zipInputStream3.initializeEntryInputStream(zipInputStream3.localFileHeader);
        zipInputStream3.entryEOFReached = false;
        return zipInputStream3.localFileHeader;
    }

    @Override
    public int read() throws IOException {
        ZipInputStream zipInputStream = object;
        byte[] byArray = new byte[1];
        Object object = byArray;
        if (zipInputStream.read(byArray) == -1) {
            return -1;
        }
        return object[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 < 0) throw new IllegalArgumentException("Negative read length");
        if (n3 == 0) {
            return 0;
        }
        LocalFileHeader localFileHeader = ((ZipInputStream)((Object)string2)).localFileHeader;
        if (localFileHeader == null) {
            return -1;
        }
        if (localFileHeader.isDirectory()) {
            return -1;
        }
        try {
            n3 = ((ZipInputStream)((Object)string2)).decompressedInputStream.read(byArray, n2, n3);
            if (n3 == -1) {
                ((ZipInputStream)((Object)string2)).endOfCompressedDataReached();
                return n3;
            }
            ((ZipInputStream)((Object)string2)).crc32.update(byArray, n2, n3);
            return n3;
        }
        catch (IOException iOException) {
            ZipInputStream zipInputStream = string2;
            if (!zipInputStream.isEncryptionMethodZipStandard(zipInputStream.localFileHeader)) throw iOException;
            IOException iOException2 = iOException;
            String string2 = iOException2.getMessage();
            ZipException.Type type = ZipException.Type.WRONG_PASSWORD;
            throw new ZipException(string2, iOException2.getCause(), type);
        }
    }

    @Override
    public void close() throws IOException {
        DecompressedInputStream decompressedInputStream = this.decompressedInputStream;
        if (decompressedInputStream != null) {
            decompressedInputStream.close();
        }
        this.streamClosed = true;
    }

    @Override
    public int available() throws IOException {
        ZipInputStream zipInputStream = this;
        zipInputStream.assertStreamOpen();
        return zipInputStream.entryEOFReached ^ 1;
    }

    public void setPassword(char[] cArray) {
        this.password = cArray;
    }
}

