/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io.inputstream;

import java.io.IOException;
import java.io.InputStream;

class ZipEntryInputStream
extends InputStream {
    private static final int MAX_RAW_READ_FULLY_RETRY_ATTEMPTS = 15;
    private InputStream inputStream;
    private long numberOfBytesRead = 0L;
    private byte[] singleByteArray = new byte[1];
    private long compressedSize;

    public ZipEntryInputStream(InputStream inputStream, long l2) {
        this.inputStream = inputStream;
        this.compressedSize = l2;
    }

    private int readUntilBufferIsFull(byte[] byArray, int n2) throws IOException {
        int n3 = byArray.length - n2;
        int n4 = 0;
        for (int i2 = 0; n2 < byArray.length && n4 != -1 && i2 < 15; ++i2) {
            if ((n4 += this.inputStream.read(byArray, n2, n3)) <= 0) continue;
            n2 += n4;
            n3 -= n4;
        }
        return n2;
    }

    @Override
    public int read() throws IOException {
        ZipEntryInputStream zipEntryInputStream = this;
        if (zipEntryInputStream.read(zipEntryInputStream.singleByteArray) == -1) {
            return -1;
        }
        return this.singleByteArray[0];
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        long l2 = this.compressedSize;
        if (l2 != -1L) {
            long l3 = this.numberOfBytesRead;
            if (l3 >= l2) {
                return -1;
            }
            if ((long)n3 > l2 - l3) {
                n3 = (int)(l2 - l3);
            }
        }
        if ((n4 = this.inputStream.read(byArray, n2, n3)) > 0) {
            this.numberOfBytesRead += (long)n4;
        }
        return n4;
    }

    public int readRawFully(byte[] byArray) throws IOException {
        int n2 = this.inputStream.read(byArray);
        if (n2 != byArray.length && (n2 = this.readUntilBufferIsFull(byArray, n2)) != byArray.length) {
            throw new IOException("Cannot read fully into byte buffer");
        }
        return n2;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    public long getNumberOfBytesRead() {
        return this.numberOfBytesRead;
    }
}

