/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io.inputstream;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.enums.RandomAccessFileMode;

public abstract class SplitInputStream
extends InputStream {
    protected RandomAccessFile randomAccessFile;
    protected File zipFile;
    private boolean isSplitZipArchive;
    private int currentSplitFileCounter = 0;
    private byte[] singleByteArray = new byte[1];

    public SplitInputStream(File file, boolean bl, int n2) throws FileNotFoundException {
        this.randomAccessFile = new RandomAccessFile(file, RandomAccessFileMode.READ.getValue());
        this.zipFile = file;
        this.isSplitZipArchive = bl;
        if (bl) {
            this.currentSplitFileCounter = n2;
        }
    }

    @Override
    public int read() throws IOException {
        SplitInputStream splitInputStream = this;
        if (splitInputStream.read(splitInputStream.singleByteArray) == -1) {
            return -1;
        }
        return this.singleByteArray[0];
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (((n2 = this.randomAccessFile.read(byArray, n2, n3)) != n3 || n2 == -1) && this.isSplitZipArchive) {
            int n4;
            SplitInputStream splitInputStream = this;
            splitInputStream.openRandomAccessFileForIndex(splitInputStream.currentSplitFileCounter + 1);
            ++splitInputStream.currentSplitFileCounter;
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n4 = this.randomAccessFile.read(byArray, n2, n3 - n2)) > 0) {
                n2 += n4;
            }
        }
        return n2;
    }

    public void prepareExtractionForFileHeader(FileHeader fileHeader) throws IOException {
        if (this.isSplitZipArchive && this.currentSplitFileCounter != fileHeader.getDiskNumberStart()) {
            this.openRandomAccessFileForIndex(fileHeader.getDiskNumberStart());
            this.currentSplitFileCounter = fileHeader.getDiskNumberStart();
        }
        this.randomAccessFile.seek(fileHeader.getOffsetLocalHeader());
    }

    protected void openRandomAccessFileForIndex(int n2) throws IOException {
        File file = this.getNextSplitFile(n2);
        if (file.exists()) {
            this.randomAccessFile.close();
            this.randomAccessFile = new RandomAccessFile(file, RandomAccessFileMode.READ.getValue());
            return;
        }
        throw new FileNotFoundException("zip split file does not exist: " + file);
    }

    protected abstract File getNextSplitFile(int var1) throws IOException;

    @Override
    public void close() throws IOException {
        Closeable closeable = ((SplitInputStream)closeable).randomAccessFile;
        if (closeable != null) {
            ((RandomAccessFile)closeable).close();
        }
    }
}

