/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io.inputstream;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import net.lingala.zip4j.io.inputstream.CipherInputStream;

abstract class DecompressedInputStream
extends InputStream {
    private CipherInputStream cipherInputStream;
    protected byte[] oneByteBuffer = new byte[1];

    public DecompressedInputStream(CipherInputStream cipherInputStream) {
        this.cipherInputStream = cipherInputStream;
    }

    @Override
    public int read() throws IOException {
        DecompressedInputStream decompressedInputStream = this;
        if (decompressedInputStream.read(decompressedInputStream.oneByteBuffer) == -1) {
            return -1;
        }
        return this.oneByteBuffer[0];
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        return this.cipherInputStream.read(byArray, n2, n3);
    }

    @Override
    public void close() throws IOException {
        this.cipherInputStream.close();
    }

    public void endOfEntryReached(InputStream inputStream) throws IOException {
        this.cipherInputStream.endOfEntryReached(inputStream);
    }

    public void pushBackInputStreamIfNecessary(PushbackInputStream pushbackInputStream) throws IOException {
    }

    protected byte[] getLastReadRawDataCache() {
        return this.cipherInputStream.getLastReadRawDataCache();
    }
}

