/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io.inputstream;

import java.io.IOException;
import java.io.InputStream;
import net.lingala.zip4j.crypto.Decrypter;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.inputstream.ZipEntryInputStream;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.enums.CompressionMethod;
import net.lingala.zip4j.util.Zip4jUtil;

abstract class CipherInputStream<T extends Decrypter>
extends InputStream {
    private ZipEntryInputStream zipEntryInputStream;
    private T decrypter;
    private byte[] lastReadRawDataCache;
    private byte[] singleByteBuffer = new byte[1];
    private LocalFileHeader localFileHeader;

    public CipherInputStream(ZipEntryInputStream zipEntryInputStream, LocalFileHeader localFileHeader, char[] cArray, int n2) throws IOException {
        this.zipEntryInputStream = zipEntryInputStream;
        this.decrypter = this.initializeDecrypter(localFileHeader, cArray);
        this.localFileHeader = localFileHeader;
        if (Zip4jUtil.getCompressionMethod(localFileHeader).equals((Object)CompressionMethod.DEFLATE)) {
            this.lastReadRawDataCache = new byte[n2];
        }
    }

    private void cacheRawData(byte[] byArray, int n2) {
        Object object = ((CipherInputStream)object).lastReadRawDataCache;
        if (((CipherInputStream)object).lastReadRawDataCache != null) {
            System.arraycopy(byArray, 0, object, 0, n2);
        }
    }

    @Override
    public int read() throws IOException {
        CipherInputStream cipherInputStream = this;
        if (cipherInputStream.read(cipherInputStream.singleByteBuffer) == -1) {
            return -1;
        }
        return this.singleByteBuffer[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if ((n3 = Zip4jUtil.readFully(this.zipEntryInputStream, byArray, n2, n3)) > 0) {
            CipherInputStream cipherInputStream = this;
            cipherInputStream.cacheRawData(byArray, n3);
            cipherInputStream.decrypter.decryptData(byArray, n2, n3);
        }
        return n3;
    }

    @Override
    public void close() throws IOException {
        this.zipEntryInputStream.close();
    }

    public byte[] getLastReadRawDataCache() {
        return this.lastReadRawDataCache;
    }

    protected int readRaw(byte[] byArray) throws IOException {
        return this.zipEntryInputStream.readRawFully(byArray);
    }

    public T getDecrypter() {
        return this.decrypter;
    }

    protected void endOfEntryReached(InputStream inputStream) throws IOException {
    }

    protected long getNumberOfBytesReadForThisEntry() {
        return this.zipEntryInputStream.getNumberOfBytesRead();
    }

    public LocalFileHeader getLocalFileHeader() {
        return this.localFileHeader;
    }

    protected abstract T initializeDecrypter(LocalFileHeader var1, char[] var2) throws IOException, ZipException;
}

