/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io.inputstream;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import net.lingala.zip4j.crypto.AESDecrypter;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.inputstream.CipherInputStream;
import net.lingala.zip4j.io.inputstream.ZipEntryInputStream;
import net.lingala.zip4j.model.AESExtraDataRecord;
import net.lingala.zip4j.model.AbstractFileHeader;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.enums.CompressionMethod;
import net.lingala.zip4j.util.Zip4jUtil;

class AesCipherInputStream
extends CipherInputStream<AESDecrypter> {
    private byte[] singleByteBuffer = new byte[1];
    private byte[] aes16ByteBlock = new byte[16];
    private int aes16ByteBlockPointer = 0;
    private int remainingAes16ByteBlockLength = 0;
    private int lengthToRead = 0;
    private int offsetWithAesBlock = 0;
    private int bytesCopiedInThisIteration = 0;
    private int lengthToCopyInThisIteration = 0;
    private int aes16ByteBlockReadLength = 0;

    public AesCipherInputStream(ZipEntryInputStream zipEntryInputStream, LocalFileHeader localFileHeader, char[] cArray, int n2) throws IOException {
        super(zipEntryInputStream, localFileHeader, cArray, n2);
    }

    private void copyBytesFromBuffer(byte[] byArray, int n2) {
        int n3 = this.lengthToRead;
        int n4 = this.remainingAes16ByteBlockLength;
        if (n3 < n4) {
            n4 = n3;
        }
        AesCipherInputStream aesCipherInputStream = this;
        aesCipherInputStream.lengthToCopyInThisIteration = n4;
        System.arraycopy(aesCipherInputStream.aes16ByteBlock, this.aes16ByteBlockPointer, byArray, n2, n4);
        aesCipherInputStream.incrementAesByteBlockPointer(aesCipherInputStream.lengthToCopyInThisIteration);
        aesCipherInputStream.decrementRemainingAesBytesLength(aesCipherInputStream.lengthToCopyInThisIteration);
        int n5 = this.lengthToCopyInThisIteration;
        aesCipherInputStream.bytesCopiedInThisIteration += n5;
        aesCipherInputStream.lengthToRead -= n5;
        aesCipherInputStream.offsetWithAesBlock += n5;
    }

    private void verifyContent(byte[] byArray) throws IOException {
        if (((CipherInputStream)object).getLocalFileHeader().isDataDescriptorExists() && CompressionMethod.DEFLATE.equals((Object)Zip4jUtil.getCompressionMethod(((CipherInputStream)object).getLocalFileHeader()))) {
            return;
        }
        byte[] byArray2 = ((AESDecrypter)((CipherInputStream)object).getDecrypter()).getCalculatedAuthenticationBytes();
        Object object = new byte[10];
        System.arraycopy(byArray2, 0, object, 0, 10);
        if (Arrays.equals(byArray, (byte[])object)) {
            return;
        }
        throw new IOException("Reached end of data for this entry, but aes verification failed");
    }

    private byte[] getSalt(LocalFileHeader localFileHeader) throws IOException {
        if (localFileHeader.getAesExtraDataRecord() != null) {
            byte[] byArray = new byte[localFileHeader.getAesExtraDataRecord().getAesKeyStrength().getSaltLength()];
            this.readRaw(byArray);
            return byArray;
        }
        throw new IOException("invalid aes extra data record");
    }

    private byte[] getPasswordVerifier() throws IOException {
        byte[] byArray = new byte[2];
        this.readRaw(byArray);
        return byArray;
    }

    private void incrementAesByteBlockPointer(int n2) {
        if ((this.aes16ByteBlockPointer += n2) >= 15) {
            this.aes16ByteBlockPointer = 15;
        }
    }

    private void decrementRemainingAesBytesLength(int n2) {
        if ((this.remainingAes16ByteBlockLength -= n2) <= 0) {
            this.remainingAes16ByteBlockLength = 0;
        }
    }

    @Override
    protected AESDecrypter initializeDecrypter(LocalFileHeader object, char[] cArray) throws IOException {
        AesCipherInputStream aesCipherInputStream = aESExtraDataRecord;
        AESExtraDataRecord aESExtraDataRecord = ((AbstractFileHeader)object).getAesExtraDataRecord();
        object = aesCipherInputStream.getSalt((LocalFileHeader)object);
        byte[] byArray = aesCipherInputStream.getPasswordVerifier();
        return new AESDecrypter(aESExtraDataRecord, cArray, (byte[])object, byArray);
    }

    @Override
    public int read() throws IOException {
        AesCipherInputStream aesCipherInputStream = this;
        if (aesCipherInputStream.read(aesCipherInputStream.singleByteBuffer) == -1) {
            return -1;
        }
        return this.singleByteBuffer[0];
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        this.lengthToRead = n3;
        this.offsetWithAesBlock = n2;
        this.bytesCopiedInThisIteration = 0;
        if (this.remainingAes16ByteBlockLength != 0) {
            AesCipherInputStream aesCipherInputStream = this;
            aesCipherInputStream.copyBytesFromBuffer(byArray, n2);
            n2 = aesCipherInputStream.bytesCopiedInThisIteration;
            if (n2 == n3) {
                return n2;
            }
        }
        if (this.lengthToRead < 16) {
            AesCipherInputStream aesCipherInputStream = this;
            byte[] byArray2 = aesCipherInputStream.aes16ByteBlock;
            int n4 = aesCipherInputStream.aes16ByteBlock.length;
            int n5 = super.read(byArray2, 0, n4);
            AesCipherInputStream aesCipherInputStream2 = this;
            aesCipherInputStream2.aes16ByteBlockReadLength = n5;
            aesCipherInputStream2.aes16ByteBlockPointer = 0;
            if (n5 == -1) {
                this.remainingAes16ByteBlockLength = 0;
                int n6 = this.bytesCopiedInThisIteration;
                if (n6 > 0) {
                    return n6;
                }
                return -1;
            }
            AesCipherInputStream aesCipherInputStream3 = this;
            aesCipherInputStream3.remainingAes16ByteBlockLength = n5;
            aesCipherInputStream3.copyBytesFromBuffer(byArray, aesCipherInputStream3.offsetWithAesBlock);
            n5 = aesCipherInputStream3.bytesCopiedInThisIteration;
            if (n5 == n3) {
                return n5;
            }
        }
        AesCipherInputStream aesCipherInputStream = this;
        int n7 = aesCipherInputStream.offsetWithAesBlock;
        int n8 = aesCipherInputStream.lengthToRead;
        if ((n7 = super.read(byArray, n7, n8 - n8 % 16)) == -1) {
            int n9 = this.bytesCopiedInThisIteration;
            if (n9 > 0) {
                return n9;
            }
            return -1;
        }
        return n7 + this.bytesCopiedInThisIteration;
    }

    @Override
    protected void endOfEntryReached(InputStream inputStream) throws IOException {
        AesCipherInputStream aesCipherInputStream = this;
        aesCipherInputStream.verifyContent(aesCipherInputStream.readStoredMac(inputStream));
    }

    protected byte[] readStoredMac(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[10];
        Object object = byArray;
        if (Zip4jUtil.readFully(inputStream, byArray) == 10) {
            return object;
        }
        throw new ZipException("Invalid AES Mac bytes. Could not read sufficient data");
    }
}

