/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.headers;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.util.InternalZipConstants;
import net.lingala.zip4j.util.Zip4jUtil;

public class HeaderUtil {
    public static FileHeader getFileHeader(ZipModel zipModel, String string2) throws ZipException {
        FileHeader fileHeader = HeaderUtil.getFileHeaderWithExactMatch(zipModel, string2);
        if (fileHeader == null && (fileHeader = HeaderUtil.getFileHeaderWithExactMatch(zipModel, string2 = string2.replaceAll("\\\\", "/"))) == null) {
            fileHeader = HeaderUtil.getFileHeaderWithExactMatch(zipModel, string2.replaceAll("/", "\\\\"));
        }
        return fileHeader;
    }

    public static String decodeStringWithCharset(byte[] byArray, boolean bl, Charset charset) {
        if (charset != null) {
            return new String(byArray, charset);
        }
        if (bl) {
            return new String(byArray, InternalZipConstants.CHARSET_UTF_8);
        }
        try {
            return new String(byArray, "Cp437");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray);
        }
    }

    public static byte[] getBytesFromString(String string2, Charset charset) {
        if (charset == null) {
            return string2.getBytes(InternalZipConstants.ZIP4J_DEFAULT_CHARSET);
        }
        return string2.getBytes(charset);
    }

    public static long getOffsetStartOfCentralDirectory(ZipModel zipModel) {
        if (zipModel.isZip64Format()) {
            return zipModel.getZip64EndOfCentralDirectoryRecord().getOffsetStartCentralDirectoryWRTStartDiskNumber();
        }
        return zipModel.getEndOfCentralDirectoryRecord().getOffsetOfStartOfCentralDirectory();
    }

    public static List<FileHeader> getFileHeadersUnderDirectory(List<FileHeader> list, FileHeader fileHeader) {
        if (!fileHeader.isDirectory()) {
            return Collections.emptyList();
        }
        return list.stream().filter(fileHeader2 -> fileHeader2.getFileName().startsWith(fileHeader.getFileName())).collect(Collectors.toList());
    }

    public static long getTotalUncompressedSizeOfAllFileHeaders(List<FileHeader> object) {
        long l2 = 0L;
        object = object.iterator();
        while (object.hasNext()) {
            FileHeader fileHeader = (FileHeader)object.next();
            if (fileHeader.getZip64ExtendedInfo() != null && fileHeader.getZip64ExtendedInfo().getUncompressedSize() > 0L) {
                l2 += fileHeader.getZip64ExtendedInfo().getUncompressedSize();
                continue;
            }
            l2 += fileHeader.getUncompressedSize();
        }
        return l2;
    }

    private static FileHeader getFileHeaderWithExactMatch(ZipModel object, String string2) throws ZipException {
        if (object != null) {
            if (Zip4jUtil.isStringNotNullAndNotEmpty(string2)) {
                if (((ZipModel)object).getCentralDirectory() != null) {
                    if (((ZipModel)object).getCentralDirectory().getFileHeaders() != null) {
                        if (((ZipModel)object).getCentralDirectory().getFileHeaders().size() == 0) {
                            return null;
                        }
                        for (FileHeader fileHeader : ((ZipModel)object).getCentralDirectory().getFileHeaders()) {
                            String string3 = fileHeader.getFileName();
                            if (!Zip4jUtil.isStringNotNullAndNotEmpty(string3) || !string2.equalsIgnoreCase(string3)) continue;
                            return fileHeader;
                        }
                        return null;
                    }
                    throw new ZipException("file Headers are null, cannot determine file header with exact match for fileName: " + string2);
                }
                throw new ZipException("central directory is null, cannot determine file header with exact match for fileName: " + string2);
            }
            throw new ZipException("file name is null, cannot determine file header with exact match for fileName: " + string2);
        }
        throw new ZipException("zip model is null, cannot determine file header with exact match for fileName: " + string2);
    }
}

