/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.headers;

import java.nio.charset.Charset;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.headers.HeaderSignature;
import net.lingala.zip4j.headers.HeaderUtil;
import net.lingala.zip4j.model.AESExtraDataRecord;
import net.lingala.zip4j.model.AbstractFileHeader;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.ZipHeader;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.AesKeyStrength;
import net.lingala.zip4j.model.enums.CompressionLevel;
import net.lingala.zip4j.model.enums.CompressionMethod;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import net.lingala.zip4j.util.BitUtils;
import net.lingala.zip4j.util.FileUtils;
import net.lingala.zip4j.util.InternalZipConstants;
import net.lingala.zip4j.util.RawIO;
import net.lingala.zip4j.util.Zip4jUtil;
import net.lingala.zip4j.util.ZipVersionUtils;

public class FileHeaderFactory {
    private byte[] determineGeneralPurposeBitFlag(boolean bl, ZipParameters zipParameters, Charset charset) {
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray[0] = this.generateFirstGeneralPurposeByte(bl, zipParameters);
        if (charset == null || InternalZipConstants.CHARSET_UTF_8.equals(charset)) {
            byArray2[1] = BitUtils.setBit(byArray2[1], 3);
        }
        return byArray2;
    }

    private byte generateFirstGeneralPurposeByte(boolean bl, ZipParameters zipParameters) {
        byte by = 0;
        if (bl) {
            by = BitUtils.setBit(by, 0);
        }
        if (CompressionMethod.DEFLATE.equals((Object)zipParameters.getCompressionMethod())) {
            if (CompressionLevel.NORMAL.equals((Object)zipParameters.getCompressionLevel())) {
                by = BitUtils.unsetBit(BitUtils.unsetBit(by, 1), 2);
            } else if (CompressionLevel.MAXIMUM.equals((Object)zipParameters.getCompressionLevel())) {
                by = BitUtils.unsetBit(BitUtils.setBit(by, 1), 2);
            } else if (CompressionLevel.FAST.equals((Object)zipParameters.getCompressionLevel())) {
                by = BitUtils.setBit(BitUtils.unsetBit(by, 1), 2);
            } else if (CompressionLevel.FASTEST.equals((Object)zipParameters.getCompressionLevel()) || CompressionLevel.ULTRA.equals((Object)zipParameters.getCompressionLevel())) {
                by = BitUtils.setBit(BitUtils.setBit(by, 1), 2);
            }
        }
        if (zipParameters.isWriteExtendedLocalFileHeader()) {
            by = BitUtils.setBit(by, 3);
        }
        return by;
    }

    private String validateAndGetFileName(String string2) throws ZipException {
        if (Zip4jUtil.isStringNotNullAndNotEmpty(string2)) {
            return string2;
        }
        throw new ZipException("fileNameInZip is null or empty");
    }

    private AESExtraDataRecord generateAESExtraDataRecord(ZipParameters zipParameters) throws ZipException {
        block7: {
            block5: {
                AesKeyStrength aesKeyStrength;
                block6: {
                    block4: {
                        AESExtraDataRecord aESExtraDataRecord;
                        AESExtraDataRecord aESExtraDataRecord2 = aESExtraDataRecord;
                        aESExtraDataRecord = new AESExtraDataRecord();
                        if (zipParameters.getAesVersion() != null) {
                            aESExtraDataRecord2.setAesVersion(zipParameters.getAesVersion());
                        }
                        aesKeyStrength = AesKeyStrength.KEY_STRENGTH_128;
                        if (zipParameters.getAesKeyStrength() != aesKeyStrength) break block4;
                        aESExtraDataRecord2.setAesKeyStrength(aesKeyStrength);
                        break block5;
                    }
                    aesKeyStrength = AesKeyStrength.KEY_STRENGTH_192;
                    if (zipParameters.getAesKeyStrength() != aesKeyStrength) break block6;
                    aESExtraDataRecord2.setAesKeyStrength(aesKeyStrength);
                    break block5;
                }
                aesKeyStrength = AesKeyStrength.KEY_STRENGTH_256;
                if (zipParameters.getAesKeyStrength() != aesKeyStrength) break block7;
                aESExtraDataRecord2.setAesKeyStrength(aesKeyStrength);
            }
            AESExtraDataRecord aESExtraDataRecord = aESExtraDataRecord2;
            aESExtraDataRecord.setCompressionMethod(zipParameters.getCompressionMethod());
            return aESExtraDataRecord;
        }
        throw new ZipException("invalid AES key strength");
    }

    private int determineFileNameLength(String string2, Charset charset) {
        return HeaderUtil.getBytesFromString(string2, charset).length;
    }

    public FileHeader generateFileHeader(ZipParameters zipParameters, boolean bl, int n2, Charset charset, RawIO rawIO) throws ZipException {
        FileHeader fileHeader;
        FileHeader fileHeader2;
        FileHeader fileHeader3 = fileHeader2 = fileHeader;
        fileHeader3();
        fileHeader3.setSignature(HeaderSignature.CENTRAL_DIRECTORY);
        fileHeader2.setVersionMadeBy(ZipVersionUtils.determineVersionMadeBy(zipParameters, rawIO));
        fileHeader.setVersionNeededToExtract(ZipVersionUtils.determineVersionNeededToExtract(zipParameters).getCode());
        if (zipParameters.isEncryptFiles() && zipParameters.getEncryptionMethod() == EncryptionMethod.AES) {
            FileHeader fileHeader4 = fileHeader2;
            fileHeader2.setCompressionMethod(CompressionMethod.AES_INTERNAL_ONLY);
            fileHeader4.setAesExtraDataRecord(this.generateAESExtraDataRecord(zipParameters));
            fileHeader4.setExtraFieldLength(fileHeader4.getExtraFieldLength() + 11);
        } else {
            fileHeader2.setCompressionMethod(zipParameters.getCompressionMethod());
        }
        if (zipParameters.isEncryptFiles()) {
            if (zipParameters.getEncryptionMethod() != null && zipParameters.getEncryptionMethod() != EncryptionMethod.NONE) {
                fileHeader2.setEncrypted(true);
                fileHeader2.setEncryptionMethod(zipParameters.getEncryptionMethod());
            } else {
                throw new ZipException("Encryption method has to be set when encryptFiles flag is set in zip parameters");
            }
        }
        String string2 = this.validateAndGetFileName(zipParameters.getFileNameInZip());
        fileHeader2.setFileName(string2);
        fileHeader2.setFileNameLength(this.determineFileNameLength(string2, charset));
        if (!bl) {
            n2 = 0;
        }
        fileHeader2.setDiskNumberStart(n2);
        if (zipParameters.getLastModifiedFileTime() > 0L) {
            fileHeader2.setLastModifiedTime(Zip4jUtil.epochToExtendedDosTime(zipParameters.getLastModifiedFileTime()));
        } else {
            fileHeader2.setLastModifiedTime(Zip4jUtil.epochToExtendedDosTime(System.currentTimeMillis()));
        }
        FileHeader fileHeader5 = fileHeader2;
        boolean bl2 = FileUtils.isZipEntryDirectory(string2);
        fileHeader5.setDirectory(bl2);
        fileHeader5.setExternalFileAttributes(FileUtils.getDefaultFileAttributes(bl2));
        if (zipParameters.isWriteExtendedLocalFileHeader() && zipParameters.getEntrySize() == -1L) {
            fileHeader2.setUncompressedSize(0L);
        } else {
            fileHeader2.setUncompressedSize(zipParameters.getEntrySize());
        }
        if (zipParameters.isEncryptFiles() && zipParameters.getEncryptionMethod() == EncryptionMethod.ZIP_STANDARD) {
            fileHeader2.setCrc(zipParameters.getEntryCRC());
        }
        FileHeader fileHeader6 = fileHeader2;
        fileHeader2.setGeneralPurposeFlag(this.determineGeneralPurposeBitFlag(fileHeader2.isEncrypted(), zipParameters, charset));
        fileHeader2.setDataDescriptorExists(zipParameters.isWriteExtendedLocalFileHeader());
        fileHeader6.setFileComment(zipParameters.getFileComment());
        return fileHeader6;
    }

    public LocalFileHeader generateLocalFileHeader(FileHeader fileHeader) {
        LocalFileHeader localFileHeader;
        Object object = this = localFileHeader;
        ((LocalFileHeader)object)();
        ((ZipHeader)object).setSignature(HeaderSignature.LOCAL_FILE_HEADER);
        ((AbstractFileHeader)this).setVersionNeededToExtract(fileHeader.getVersionNeededToExtract());
        ((AbstractFileHeader)this).setCompressionMethod(fileHeader.getCompressionMethod());
        ((AbstractFileHeader)this).setLastModifiedTime(fileHeader.getLastModifiedTime());
        ((AbstractFileHeader)this).setUncompressedSize(fileHeader.getUncompressedSize());
        ((AbstractFileHeader)this).setFileNameLength(fileHeader.getFileNameLength());
        ((AbstractFileHeader)this).setFileName(fileHeader.getFileName());
        ((AbstractFileHeader)this).setEncrypted(fileHeader.isEncrypted());
        ((AbstractFileHeader)this).setEncryptionMethod(fileHeader.getEncryptionMethod());
        ((AbstractFileHeader)this).setAesExtraDataRecord(fileHeader.getAesExtraDataRecord());
        ((AbstractFileHeader)this).setCrc(fileHeader.getCrc());
        ((AbstractFileHeader)this).setCompressedSize(fileHeader.getCompressedSize());
        ((AbstractFileHeader)this).setGeneralPurposeFlag((byte[])fileHeader.getGeneralPurposeFlag().clone());
        ((AbstractFileHeader)this).setDataDescriptorExists(fileHeader.isDataDescriptorExists());
        localFileHeader.setExtraFieldLength(fileHeader.getExtraFieldLength());
        return localFileHeader;
    }
}

