/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto.engine;

import net.lingala.zip4j.util.Zip4jUtil;

public class ZipCryptoEngine {
    private static final int[] CRC_TABLE = new int[256];
    private final int[] keys = new int[3];

    private int crc32(int n2, byte by) {
        return n2 >>> 8 ^ CRC_TABLE[(n2 ^ by) & 0xFF];
    }

    static {
        for (int i2 = 0; i2 < 256; ++i2) {
            int n2 = i2;
            for (int i3 = 0; i3 < 8; ++i3) {
                if ((n2 & 1) == 1) {
                    n2 = n2 >>> 1 ^ 0xEDB88320;
                    continue;
                }
                n2 >>>= 1;
            }
            ZipCryptoEngine.CRC_TABLE[i2] = n2;
        }
    }

    public void initKeys(char[] objectArray) {
        int[] nArray = this.keys;
        nArray[0] = 305419896;
        nArray[1] = 591751049;
        this.keys[2] = 878082192;
        byte[] byArray = Zip4jUtil.convertCharArrayToByteArray(objectArray);
        objectArray = byArray;
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.updateKeys((byte)(objectArray[i2] & 0xFF));
        }
    }

    public void updateKeys(byte by) {
        int[] nArray;
        ZipCryptoEngine zipCryptoEngine = this;
        zipCryptoEngine.keys[0] = this.crc32(zipCryptoEngine.keys[0], by);
        int[] nArray2 = nArray = zipCryptoEngine.keys;
        nArray2[1] = nArray[1] + (nArray[0] & 0xFF);
        nArray2[1] = nArray[1] * 134775813 + 1;
        int n2 = nArray[2];
        zipCryptoEngine.keys[2] = this.crc32(n2, (byte)(nArray2[1] >> 24));
    }

    public byte decryptByte() {
        int n2 = this.keys[2] | 2;
        return (byte)(n2 * (n2 ^ 1) >>> 8);
    }
}

