/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto;

import java.security.SecureRandom;
import net.lingala.zip4j.crypto.Encrypter;
import net.lingala.zip4j.crypto.engine.ZipCryptoEngine;
import net.lingala.zip4j.exception.ZipException;

public class StandardEncrypter
implements Encrypter {
    private final ZipCryptoEngine zipCryptoEngine;
    private byte[] headerBytes;

    public StandardEncrypter(char[] cArray, long l2) throws ZipException {
        ZipCryptoEngine zipCryptoEngine;
        StandardEncrypter standardEncrypter = zipCryptoEngine2;
        ZipCryptoEngine zipCryptoEngine2 = zipCryptoEngine;
        zipCryptoEngine = new ZipCryptoEngine();
        standardEncrypter.zipCryptoEngine = zipCryptoEngine2;
        standardEncrypter.init(cArray, l2);
    }

    private void init(char[] cArray, long l2) throws ZipException {
        if (cArray != null && cArray.length > 0) {
            StandardEncrypter standardEncrypter = object;
            standardEncrypter.zipCryptoEngine.initKeys(cArray);
            standardEncrypter.headerBytes = standardEncrypter.generateRandomBytes();
            standardEncrypter.zipCryptoEngine.initKeys(cArray);
            byte[] byArray = standardEncrypter.headerBytes;
            Object object = byArray;
            object[11] = (byte)(l2 >>> 24);
            byArray[10] = (byte)(l2 >>> 16);
            standardEncrypter.encryptData(standardEncrypter.headerBytes);
            return;
        }
        throw new ZipException("input password is null or empty, cannot initialize standard encrypter");
    }

    @Override
    public int encryptData(byte[] byArray) throws ZipException {
        byte[] byArray2 = byArray;
        byArray2.getClass();
        return this.encryptData(byArray, 0, byArray2.length);
    }

    @Override
    public int encryptData(byte[] byArray, int n2, int n3) throws ZipException {
        if (n3 >= 0) {
            for (int i2 = n2; i2 < n2 + n3; ++i2) {
                byArray[i2] = this.encryptByte(byArray[i2]);
            }
            return n3;
        }
        throw new ZipException("invalid length specified to decrpyt data");
    }

    protected byte encryptByte(byte by) {
        byte by2 = (byte)(by ^ this.zipCryptoEngine.decryptByte() & 0xFF);
        this.zipCryptoEngine.updateKeys(by);
        return by2;
    }

    protected byte[] generateRandomBytes() {
        SecureRandom secureRandom;
        int n2 = 12;
        byte[] byArray = new byte[12];
        SecureRandom secureRandom2 = secureRandom;
        secureRandom = new SecureRandom();
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = this.encryptByte((byte)secureRandom2.nextInt(256));
        }
        return byArray;
    }

    public byte[] getHeaderBytes() {
        return this.headerBytes;
    }
}

