/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto;

import net.lingala.zip4j.crypto.Decrypter;
import net.lingala.zip4j.crypto.engine.ZipCryptoEngine;
import net.lingala.zip4j.exception.ZipException;

public class StandardDecrypter
implements Decrypter {
    private ZipCryptoEngine zipCryptoEngine;

    public StandardDecrypter(char[] cArray, long l2, long l3, byte[] byArray) throws ZipException {
        ZipCryptoEngine zipCryptoEngine;
        StandardDecrypter standardDecrypter = zipCryptoEngine2;
        ZipCryptoEngine zipCryptoEngine2 = zipCryptoEngine;
        zipCryptoEngine = new ZipCryptoEngine();
        standardDecrypter.zipCryptoEngine = zipCryptoEngine2;
        standardDecrypter.init(byArray, cArray, l3, l2);
    }

    private void init(byte[] byArray, char[] cArray, long l2, long l3) throws ZipException {
        if (cArray != null && cArray.length > 0) {
            this.zipCryptoEngine.initKeys(cArray);
            byte by = byArray[0];
            int n2 = 0;
            while (n2 < 12) {
                byte by2;
                if (++n2 == 12 && (by2 = (byte)(by ^ this.zipCryptoEngine.decryptByte())) != (byte)(l3 >> 24) && by2 != (byte)(l2 >> 8)) {
                    throw new ZipException("Wrong password!", ZipException.Type.WRONG_PASSWORD);
                }
                ZipCryptoEngine zipCryptoEngine = this.zipCryptoEngine;
                zipCryptoEngine.updateKeys((byte)(by ^ zipCryptoEngine.decryptByte()));
                if (n2 == 12) continue;
                by = byArray[n2];
            }
            return;
        }
        throw new ZipException("Wrong password!", ZipException.Type.WRONG_PASSWORD);
    }

    @Override
    public int decryptData(byte[] byArray, int n2, int n3) throws ZipException {
        if (n2 >= 0 && n3 >= 0) {
            for (int i2 = n2; i2 < n2 + n3; ++i2) {
                int n4 = (byArray[i2] & 0xFF ^ this.zipCryptoEngine.decryptByte()) & 0xFF;
                byte by = (byte)n4;
                n4 = by;
                this.zipCryptoEngine.updateKeys(by);
                byArray[i2] = n4;
            }
            return n3;
        }
        throw new ZipException("one of the input parameters were null in standard decrypt data");
    }
}

