/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto;

import net.lingala.zip4j.crypto.PBKDF2.MacBasedPRF;
import net.lingala.zip4j.crypto.PBKDF2.PBKDF2Engine;
import net.lingala.zip4j.crypto.PBKDF2.PBKDF2Parameters;
import net.lingala.zip4j.crypto.engine.AESEngine;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.enums.AesKeyStrength;

public class AesCipherUtil {
    private static final int START_INDEX = 0;

    public static byte[] derivePasswordBasedKey(byte[] object, char[] cArray, AesKeyStrength aesKeyStrength) throws ZipException {
        PBKDF2Engine pBKDF2Engine;
        PBKDF2Parameters pBKDF2Parameters;
        Object object2 = pBKDF2Parameters;
        pBKDF2Parameters = new PBKDF2Parameters("HmacSHA1", "ISO-8859-1", (byte[])object, 1000);
        object = pBKDF2Engine;
        object((PBKDF2Parameters)object2);
        int n2 = aesKeyStrength.getKeyLength();
        int n3 = aesKeyStrength.getMacLength();
        int n4 = n2 + n3 + 2;
        byte[] byArray = pBKDF2Engine.deriveKey(cArray, n4);
        object2 = byArray;
        if (byArray != null && ((Object)object2).length == n4) {
            return object2;
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = n2;
        objectArray[1] = n3;
        String string2 = String.format("Derived Key invalid for Key Length [%d] MAC Length [%d]", objectArray2);
        throw new ZipException(string2);
    }

    public static byte[] derivePasswordVerifier(byte[] byArray, AesKeyStrength aesKeyStrength) {
        byte[] byArray2 = new byte[2];
        System.arraycopy(byArray, aesKeyStrength.getKeyLength() + aesKeyStrength.getMacLength(), byArray2, 0, 2);
        return byArray2;
    }

    public static MacBasedPRF getMacBasedPRF(byte[] byArray, AesKeyStrength object) {
        AesKeyStrength aesKeyStrength = object;
        int n2 = aesKeyStrength.getMacLength();
        object = new byte[n2];
        System.arraycopy(byArray, aesKeyStrength.getKeyLength(), object, 0, n2);
        MacBasedPRF macBasedPRF = new MacBasedPRF("HmacSHA1");
        macBasedPRF.init((byte[])object);
        return macBasedPRF;
    }

    public static AESEngine getAESEngine(byte[] byArray, AesKeyStrength object) throws ZipException {
        int n2 = object.getKeyLength();
        object = new byte[n2];
        System.arraycopy(byArray, 0, object, 0, n2);
        return new AESEngine((byte[])object);
    }

    public static void prepareBuffAESIVBytes(byte[] byArray, int n2) {
        byArray[0] = (byte)n2;
        byArray[1] = (byte)(n2 >> 8);
        byArray[2] = (byte)(n2 >> 16);
        byArray[3] = (byte)(n2 >> 24);
        for (n2 = 4; n2 <= 15; ++n2) {
            byArray[n2] = 0;
        }
    }
}

