/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto;

import java.util.Arrays;
import net.lingala.zip4j.crypto.AesCipherUtil;
import net.lingala.zip4j.crypto.Decrypter;
import net.lingala.zip4j.crypto.PBKDF2.MacBasedPRF;
import net.lingala.zip4j.crypto.engine.AESEngine;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.AESExtraDataRecord;
import net.lingala.zip4j.model.enums.AesKeyStrength;

public class AESDecrypter
implements Decrypter {
    private AESEngine aesEngine;
    private MacBasedPRF mac;
    private int nonce = 1;
    private byte[] iv = new byte[16];
    private byte[] counterBlock = new byte[16];

    public AESDecrypter(AESExtraDataRecord aESExtraDataRecord, char[] cArray, byte[] byArray, byte[] byArray2) throws ZipException {
        this.init(byArray, byArray2, cArray, aESExtraDataRecord);
    }

    private void init(byte[] object, byte[] byArray, char[] cArray, AESExtraDataRecord aESExtraDataRecord) throws ZipException {
        if (cArray != null && cArray.length > 0) {
            byte[] byArray2 = object;
            AesKeyStrength aesKeyStrength = aESExtraDataRecord.getAesKeyStrength();
            object = (Object)aesKeyStrength;
            if (Arrays.equals(byArray, AesCipherUtil.derivePasswordVerifier(byArray = AesCipherUtil.derivePasswordBasedKey(byArray2, cArray, aesKeyStrength), (AesKeyStrength)((Object)object)))) {
                this.aesEngine = AesCipherUtil.getAESEngine(byArray, (AesKeyStrength)((Object)object));
                this.mac = AesCipherUtil.getMacBasedPRF(byArray, (AesKeyStrength)((Object)object));
                return;
            }
            throw new ZipException("Wrong Password", ZipException.Type.WRONG_PASSWORD);
        }
        throw new ZipException("empty or null password provided for AES decryption");
    }

    @Override
    public int decryptData(byte[] byArray, int n2, int n3) throws ZipException {
        int n4;
        int n5 = n2;
        while (n5 < (n4 = n2 + n3)) {
            int n6 = n5 + 16;
            n4 = n6 <= n4 ? 16 : (n4 -= n5);
            AESDecrypter aESDecrypter = this;
            aESDecrypter.mac.update(byArray, n5, n4);
            AesCipherUtil.prepareBuffAESIVBytes(aESDecrypter.iv, this.nonce);
            AESDecrypter aESDecrypter2 = this;
            byte[] byArray2 = aESDecrypter2.iv;
            aESDecrypter.aesEngine.processBlock(byArray2, aESDecrypter2.counterBlock);
            for (int i2 = 0; i2 < n4; ++i2) {
                int n7 = n5 + i2;
                byArray[n7] = (byte)(byArray[n7] ^ this.counterBlock[i2]);
            }
            ++this.nonce;
            n5 = n6;
        }
        return n3;
    }

    public byte[] getCalculatedAuthenticationBytes() {
        return this.mac.doFinal();
    }
}

